/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util;

import com.google.common.collect.ImmutableSet;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.jasig.cas.client.util.URIBuilder;
import org.pac4j.cas.client.CasClient;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcAuthorizationRequestSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcAuthorizationRequestSupport.class);
    private CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator;
    private TicketRegistrySupport ticketRegistrySupport;

    public static Set<String> getOidcPromptFromAuthorizationRequest(String url) {
        URIBuilder builderContext = new URIBuilder(url);
        Optional<URIBuilder.BasicNameValuePair> parameter = builderContext.getQueryParams().stream().filter(p -> p.getName().equals("prompt")).findFirst();
        if (parameter.isPresent()) {
            return ImmutableSet.copyOf((Object[])parameter.get().getValue().split(" "));
        }
        return Collections.emptySet();
    }

    public static Set<String> getOidcPromptFromAuthorizationRequest(WebContext context) {
        return OidcAuthorizationRequestSupport.getOidcPromptFromAuthorizationRequest(context.getFullRequestURL());
    }

    public static Optional<Long> getOidcMaxAgeFromAuthorizationRequest(WebContext context) {
        URIBuilder builderContext = new URIBuilder(context.getFullRequestURL());
        Optional<URIBuilder.BasicNameValuePair> parameter = builderContext.getQueryParams().stream().filter(p -> p.getName().equals("max_age")).findFirst();
        if (parameter.isPresent()) {
            long maxAge = NumberUtils.toLong((String)parameter.get().getValue(), (long)-1L);
            return Optional.of(maxAge);
        }
        return Optional.empty();
    }

    public static Optional<UserProfile> isAuthenticationProfileAvailable(WebContext context) {
        ProfileManager manager = new ProfileManager(context);
        return manager.get(true);
    }

    public Optional<Authentication> isCasAuthenticationAvailable(WebContext context) {
        Authentication authentication;
        String tgtId;
        J2EContext j2EContext = (J2EContext)context;
        if (j2EContext != null && StringUtils.isNotBlank((CharSequence)(tgtId = this.ticketGrantingTicketCookieGenerator.retrieveCookieValue(j2EContext.getRequest()))) && (authentication = this.ticketRegistrySupport.getAuthenticationFrom(tgtId)) != null) {
            return Optional.of(authentication);
        }
        return Optional.empty();
    }

    public boolean isCasAuthenticationOldForMaxAgeAuthorizationRequest(WebContext context, ZonedDateTime authenticationDate) {
        long authTime;
        long now;
        long diffInSeconds;
        Optional<Long> maxAge = OidcAuthorizationRequestSupport.getOidcMaxAgeFromAuthorizationRequest(context);
        if (maxAge.isPresent() && maxAge.get() > 0L && (diffInSeconds = (now = ZonedDateTime.now().toEpochSecond()) - (authTime = authenticationDate.toEpochSecond())) > maxAge.get()) {
            LOGGER.info("Authentication is too old: {} and was created {} seconds ago.", (Object)authTime, (Object)diffInSeconds);
            return true;
        }
        return false;
    }

    public boolean isCasAuthenticationOldForMaxAgeAuthorizationRequest(WebContext context, Authentication authentication) {
        return this.isCasAuthenticationOldForMaxAgeAuthorizationRequest(context, authentication.getAuthenticationDate());
    }

    public boolean isCasAuthenticationOldForMaxAgeAuthorizationRequest(WebContext context, UserProfile profile) {
        Object authTime = profile.getAttribute("authenticationDate");
        if (authTime == null) {
            return false;
        }
        ZonedDateTime dt = ZonedDateTime.parse(authTime.toString());
        return this.isCasAuthenticationOldForMaxAgeAuthorizationRequest(context, dt);
    }

    public void configureClientForMaxAgeAuthorizationRequest(CasClient casClient, WebContext context, Authentication authentication) {
        if (this.isCasAuthenticationOldForMaxAgeAuthorizationRequest(context, authentication)) {
            casClient.setRenew(true);
        }
    }

    public static void configureClientForPromptLoginAuthorizationRequest(CasClient casClient, WebContext context) {
        Set<String> prompts = OidcAuthorizationRequestSupport.getOidcPromptFromAuthorizationRequest(context);
        if (prompts.contains("login")) {
            casClient.setRenew(true);
        }
    }

    public static void configureClientForPromptNoneAuthorizationRequest(CasClient casClient, WebContext context) {
        Set<String> prompts = OidcAuthorizationRequestSupport.getOidcPromptFromAuthorizationRequest(context);
        if (prompts.contains("none")) {
            casClient.setRenew(false);
            casClient.setGateway(true);
        }
    }

    public void setTicketGrantingTicketCookieGenerator(CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator) {
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
    }

    public void setTicketRegistrySupport(TicketRegistrySupport ticketRegistrySupport) {
        this.ticketRegistrySupport = ticketRegistrySupport;
    }
}

