/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.controllers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.apereo.cas.OidcConstants;
import org.apereo.cas.config.OidcServerDiscoverySettings;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.support.oauth.web.BaseOAuthWrapperController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class OidcWellKnownEndpointController
extends BaseOAuthWrapperController {
    @Autowired
    private CasConfigurationProperties casProperties;

    @RequestMapping(value={"/oidc/.well-known"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<OidcServerDiscoverySettings> getWellKnownDiscoveryConfiguration() {
        OidcServerDiscoverySettings discoveryProperties = new OidcServerDiscoverySettings(this.casProperties.getServer().getPrefix(), this.casProperties.getAuthn().getOidc().getIssuer());
        discoveryProperties.setClaimsSupported((List<String>)ImmutableList.of((Object)"sub", (Object)"name", (Object)"preferred_username", (Object)"family_name", (Object)"given_name", (Object)"middle_name", (Object)"given_name", (Object)"profile", (Object)"picture", (Object)"nickname", (Object)"website", (Object)"zoneinfo", (Object[])new String[]{"locale", "updated_at", "birthdate", "email", "email_verified", "phone_number", "phone_number_verified", "address"}));
        discoveryProperties.setScopesSupported(OidcConstants.SCOPES);
        discoveryProperties.setResponseTypesSupported((List<String>)ImmutableList.of((Object)"code", (Object)"token"));
        discoveryProperties.setSubjectTypesSupported((List<String>)ImmutableList.of((Object)"public", (Object)"pairwise"));
        discoveryProperties.setClaimTypesSupported((List<String>)ImmutableList.of((Object)"normal"));
        discoveryProperties.setGrantTypesSupported((List<String>)ImmutableList.of((Object)"authorization_code", (Object)"password", (Object)"implicit"));
        String idTokenSigningAlgValues = this.casProperties.getAuthn().getOidc().getIdTokenSigningAlgs();
        discoveryProperties.setIdTokenSigningAlgValuesSupported(Lists.newArrayList((Object[])idTokenSigningAlgValues.split(",")));
        return new ResponseEntity((Object)discoveryProperties, HttpStatus.OK);
    }

    @RequestMapping(value={"/oidc/.well-known/openid-configuration"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<OidcServerDiscoverySettings> getWellKnownOpenIdDiscoveryConfiguration() {
        return this.getWellKnownDiscoveryConfiguration();
    }
}

