/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Optional;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.support.oauth.DefaultOAuthCasClientRedirectActionBuilder;
import org.apereo.cas.util.OidcAuthorizationRequestSupport;
import org.pac4j.cas.client.CasClient;
import org.pac4j.core.client.RedirectAction;
import org.pac4j.core.context.WebContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcCasClientRedirectActionBuilder
extends DefaultOAuthCasClientRedirectActionBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcCasClientRedirectActionBuilder.class);
    private OidcAuthorizationRequestSupport oidcAuthorizationRequestSupport;

    public RedirectAction build(CasClient casClient, WebContext context) {
        Optional<Authentication> auth = this.oidcAuthorizationRequestSupport.isCasAuthenticationAvailable(context);
        if (auth.isPresent()) {
            this.oidcAuthorizationRequestSupport.configureClientForMaxAgeAuthorizationRequest(casClient, context, auth.get());
        }
        OidcAuthorizationRequestSupport.configureClientForPromptLoginAuthorizationRequest(casClient, context);
        OidcAuthorizationRequestSupport.configureClientForPromptNoneAuthorizationRequest(casClient, context);
        RedirectAction action = super.build(casClient, context);
        LOGGER.debug("Final redirect action is [{}]", (Object)action);
        return action;
    }

    public void setOidcAuthorizationRequestSupport(OidcAuthorizationRequestSupport oidcAuthorizationRequestSupport) {
        this.oidcAuthorizationRequestSupport = oidcAuthorizationRequestSupport;
    }
}

