/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web;

import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.OidcConstants;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.OAuth20AccessTokenResponseGenerator;
import org.apereo.cas.ticket.accesstoken.AccessToken;
import org.apereo.cas.ticket.refreshtoken.RefreshToken;
import org.apereo.cas.util.CollectionUtils;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.RsaJsonWebKey;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.jose4j.lang.JoseException;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.springframework.core.io.Resource;

public class OidcAccessTokenResponseGenerator
extends OAuth20AccessTokenResponseGenerator {
    private String issuer;
    private int skew;
    private Resource jwksFile;

    protected void generateJsonInternal(HttpServletRequest request, HttpServletResponse response, JsonGenerator jsonGenerator, AccessToken accessTokenId, RefreshToken refreshTokenId, long timeout, Service service, OAuthRegisteredService registeredService) throws Exception {
        super.generateJsonInternal(request, response, jsonGenerator, accessTokenId, refreshTokenId, timeout, service, registeredService);
        OidcRegisteredService oidcRegisteredService = (OidcRegisteredService)registeredService;
        J2EContext context = new J2EContext(request, response);
        ProfileManager manager = new ProfileManager((WebContext)context);
        Optional profile = manager.get(true);
        JwtClaims claims = this.produceIdTokenClaims(request, accessTokenId, timeout, oidcRegisteredService, (UserProfile)profile.get(), context);
        Optional<JsonWebKeySet> jwks = this.buildJsonWebKeySet(oidcRegisteredService);
        String idToken = this.signIdTokenClaim(oidcRegisteredService, jwks, claims);
        jsonGenerator.writeStringField("id_token", idToken);
    }

    protected JwtClaims produceIdTokenClaims(HttpServletRequest request, AccessToken accessTokenId, long timeout, OidcRegisteredService service, UserProfile profile, J2EContext context) {
        Set val;
        Authentication authentication = accessTokenId.getAuthentication();
        Principal principal = authentication.getPrincipal();
        JwtClaims claims = new JwtClaims();
        claims.setJwtId(UUID.randomUUID().toString());
        claims.setIssuer(this.issuer);
        claims.setAudience(service.getClientId());
        NumericDate expirationDate = NumericDate.now();
        expirationDate.addSeconds(timeout);
        claims.setExpirationTime(expirationDate);
        claims.setIssuedAtToNow();
        claims.setNotBeforeMinutesInThePast((float)this.skew);
        claims.setSubject(principal.getId());
        if (authentication.getAttributes().containsKey(this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute())) {
            val = CollectionUtils.convertValueToCollection(authentication.getAttributes().get(this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute()));
            claims.setStringClaim("acr", val.iterator().next().toString());
        }
        if (authentication.getAttributes().containsKey("successfulAuthenticationHandlers")) {
            val = CollectionUtils.convertValueToCollection(authentication.getAttributes().get("successfulAuthenticationHandlers"));
            claims.setStringListClaim("amr", val.toArray(new String[0]));
        }
        claims.setClaim("state", authentication.getAttributes().get("state"));
        claims.setClaim("nonce", authentication.getAttributes().get("nonce"));
        Sets.SetView setView = Sets.intersection(OidcConstants.CLAIMS, principal.getAttributes().keySet());
        setView.immutableCopy().stream().forEach(k -> claims.setClaim(k, principal.getAttributes().get(k)));
        if (!claims.hasClaim("preferred_username")) {
            claims.setClaim("preferred_username", (Object)profile.getId());
        }
        return claims;
    }

    protected String signIdTokenClaim(OidcRegisteredService svc, Optional<JsonWebKeySet> jwks, JwtClaims claims) throws JoseException {
        JsonWebSignature jws = new JsonWebSignature();
        String jsonClaims = claims.toJson();
        jws.setPayload(jsonClaims);
        this.logger.debug("Generated claims are {}", (Object)jsonClaims);
        jws.setAlgorithmHeaderValue("none");
        jws.setAlgorithmConstraints(AlgorithmConstraints.NO_CONSTRAINTS);
        if (svc.isSignIdToken() && jwks.isPresent() && !jwks.get().getJsonWebKeys().isEmpty()) {
            RsaJsonWebKey jsonWebKey = (RsaJsonWebKey)jwks.get().getJsonWebKeys().get(0);
            jws.setKey((Key)jsonWebKey.getPrivateKey());
            jws.setAlgorithmConstraints(AlgorithmConstraints.DISALLOW_NONE);
            if (StringUtils.isBlank((CharSequence)jsonWebKey.getKeyId())) {
                jws.setKeyIdHeaderValue(UUID.randomUUID().toString());
            } else {
                jws.setKeyIdHeaderValue(jsonWebKey.getKeyId());
            }
            this.logger.debug("Signing id token with key id header value {}", (Object)jws.getKeyIdHeaderValue());
            jws.setAlgorithmHeaderValue("RS256");
        }
        this.logger.debug("Signing id token with algorithm {}", (Object)jws.getAlgorithmHeaderValue());
        return jws.getCompactSerialization();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Optional<JsonWebKeySet> buildJsonWebKeySet(OidcRegisteredService service) throws Exception {
        JsonWebKeySet jsonWebKeySet = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)service.getJwks())) {
                this.logger.debug("Loading JWKS from {}", (Object)service.getJwks());
                Resource resource = this.resourceLoader.getResource(service.getJwks());
                jsonWebKeySet = new JsonWebKeySet(IOUtils.toString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8));
            }
        }
        catch (Exception e) {
            this.logger.debug(e.getMessage(), (Throwable)e);
        }
        finally {
            if (jsonWebKeySet == null) {
                this.logger.debug("Loading default JWKS from {}", (Object)this.jwksFile);
                if (this.jwksFile != null) {
                    String jsonJwks = IOUtils.toString((InputStream)this.jwksFile.getInputStream(), (Charset)StandardCharsets.UTF_8);
                    jsonWebKeySet = new JsonWebKeySet(jsonJwks);
                }
            }
        }
        return jsonWebKeySet != null ? Optional.of(jsonWebKeySet) : Optional.empty();
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public void setSkew(int skew) {
        this.skew = skew;
    }

    public void setJwksFile(Resource jwksFile) {
        this.jwksFile = jwksFile;
    }
}

