/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.services.MultifactorAuthenticationProvider;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.web.flow.resolver.impl.AbstractCasWebflowEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.jasig.cas.client.util.URIBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class OidcAuthenticationContextWebflowEventResolver
extends AbstractCasWebflowEventResolver {
    protected Set<Event> resolveInternal(RequestContext context) {
        URIBuilder builderContext;
        Optional<URIBuilder.BasicNameValuePair> parameter;
        RegisteredService service = WebUtils.getRegisteredService((RequestContext)context);
        Authentication authentication = WebUtils.getAuthentication((RequestContext)context);
        HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)context);
        if (service == null || authentication == null) {
            this.logger.debug("No service or authentication is available to determine event for principal");
            return null;
        }
        String acr = request.getParameter("acr_values");
        if (StringUtils.isBlank((CharSequence)acr) && (parameter = (builderContext = new URIBuilder(context.getFlowExecutionUrl())).getQueryParams().stream().filter(p -> p.getName().equals("acr_values")).findFirst()).isPresent()) {
            acr = parameter.get().getValue();
        }
        if (StringUtils.isBlank((CharSequence)acr)) {
            this.logger.debug("No ACR provided in the authentication request");
            return null;
        }
        Set values = org.springframework.util.StringUtils.commaDelimitedListToSet((String)acr);
        if (values.isEmpty()) {
            this.logger.debug("No ACR provided in the authentication request");
            return null;
        }
        Map providerMap = WebUtils.getAllMultifactorAuthenticationProviders((ApplicationContext)this.applicationContext);
        if (providerMap == null || providerMap.isEmpty()) {
            this.logger.warn("No multifactor authentication providers are available in the application context");
            throw new AuthenticationException();
        }
        Optional<MultifactorAuthenticationProvider> provider = providerMap.values().stream().filter(v -> values.contains(v.getId())).findAny();
        if (provider.isPresent()) {
            return Sets.newHashSet((Object[])new Event[]{new Event((Object)this, provider.get().getId())});
        }
        this.logger.warn("The requested authentication class cannot be satisfied by any of the MFA providers available");
        throw new AuthenticationException();
    }
}

