/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import java.util.Set;
import lombok.Generated;
import org.apereo.cas.oidc.util.OidcAuthorizationRequestSupport;
import org.apereo.cas.support.oauth.web.response.OAuth20DefaultCasClientRedirectActionBuilder;
import org.pac4j.cas.client.CasClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.redirect.RedirectAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcCasClientRedirectActionBuilder
extends OAuth20DefaultCasClientRedirectActionBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcCasClientRedirectActionBuilder.class);
    private final OidcAuthorizationRequestSupport oidcAuthorizationRequestSupport;

    public RedirectAction build(CasClient casClient, WebContext context) {
        boolean renew = casClient.getConfiguration().isRenew();
        boolean gateway = casClient.getConfiguration().isGateway();
        Set<String> prompts = OidcAuthorizationRequestSupport.getOidcPromptFromAuthorizationRequest(context);
        if (prompts.contains("none")) {
            renew = false;
            gateway = true;
        } else if (prompts.contains("login") || this.oidcAuthorizationRequestSupport.isCasAuthenticationOldForMaxAgeAuthorizationRequest(context)) {
            renew = true;
        }
        RedirectAction action = super.build(casClient, context, renew, gateway);
        LOGGER.debug("Final redirect action is [{}]", (Object)action);
        return action;
    }

    @Generated
    public OidcCasClientRedirectActionBuilder(OidcAuthorizationRequestSupport oidcAuthorizationRequestSupport) {
        this.oidcAuthorizationRequestSupport = oidcAuthorizationRequestSupport;
    }
}

