/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.oidc.util.OidcAuthorizationRequestSupport;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.views.OAuth20ConsentApprovalViewResolver;
import org.pac4j.core.context.J2EContext;

public class OidcConsentApprovalViewResolver
extends OAuth20ConsentApprovalViewResolver {
    public OidcConsentApprovalViewResolver(CasConfigurationProperties casProperties) {
        super(casProperties);
    }

    protected boolean isConsentApprovalBypassed(J2EContext context, OAuthRegisteredService service) {
        String url = context.getFullRequestURL();
        Set<String> prompts = OidcAuthorizationRequestSupport.getOidcPromptFromAuthorizationRequest(url);
        if (prompts.contains("consent")) {
            return false;
        }
        return super.isConsentApprovalBypassed(context, service);
    }

    protected String getApprovalViewName() {
        return "oidcConfirmView";
    }

    protected void prepareApprovalViewModel(Map<String, Object> model, J2EContext ctx, OAuthRegisteredService svc) {
        super.prepareApprovalViewModel(model, ctx, svc);
        if (svc instanceof OidcRegisteredService) {
            OidcRegisteredService oidcRegisteredService = (OidcRegisteredService)svc;
            model.put("dynamic", oidcRegisteredService.isDynamicallyRegistered());
            model.put("dynamicTime", oidcRegisteredService.getDynamicRegistrationDateTime());
            HashSet supportedScopes = new HashSet(this.casProperties.getAuthn().getOidc().getScopes());
            supportedScopes.retainAll(oidcRegisteredService.getScopes());
            supportedScopes.retainAll(OAuth20Utils.getRequestedScopes((J2EContext)ctx));
            model.put("scopes", supportedScopes);
        }
    }
}

