/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.dynareg;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.oidc.dynareg.OidcClientRegistrationRequest;
import org.apereo.cas.oidc.dynareg.OidcClientRegistrationResponse;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.OidcSubjectTypes;
import org.apereo.cas.services.PairwiseOidcRegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.web.endpoints.BaseOAuth20Controller;
import org.apereo.cas.ticket.accesstoken.AccessTokenFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.gen.RandomStringGenerator;
import org.apereo.cas.util.serialization.StringSerializer;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

public class OidcDynamicClientRegistrationEndpointController
extends BaseOAuth20Controller {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcDynamicClientRegistrationEndpointController.class);
    private final StringSerializer<OidcClientRegistrationRequest> clientRegistrationRequestSerializer;
    private final RandomStringGenerator clientIdGenerator;
    private final RandomStringGenerator clientSecretGenerator;

    public OidcDynamicClientRegistrationEndpointController(ServicesManager servicesManager, TicketRegistry ticketRegistry, AccessTokenFactory accessTokenFactory, PrincipalFactory principalFactory, ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory, StringSerializer<OidcClientRegistrationRequest> clientRegistrationRequestSerializer, RandomStringGenerator clientIdGenerator, RandomStringGenerator clientSecretGenerator, OAuth20ProfileScopeToAttributesFilter scopeToAttributesFilter, CasConfigurationProperties casProperties, CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator) {
        super(servicesManager, ticketRegistry, accessTokenFactory, principalFactory, webApplicationServiceServiceFactory, scopeToAttributesFilter, casProperties, ticketGrantingTicketCookieGenerator);
        this.clientRegistrationRequestSerializer = clientRegistrationRequestSerializer;
        this.clientIdGenerator = clientIdGenerator;
        this.clientSecretGenerator = clientSecretGenerator;
    }

    @PostMapping(value={"/oidc/register"}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<OidcClientRegistrationResponse> handleRequestInternal(@RequestBody String jsonInput, HttpServletRequest request, HttpServletResponse response) {
        try {
            OidcClientRegistrationRequest registrationRequest = (OidcClientRegistrationRequest)this.clientRegistrationRequestSerializer.from(jsonInput);
            LOGGER.debug("Received client registration request [{}]", (Object)registrationRequest);
            if (registrationRequest.getScopes().isEmpty()) {
                throw new Exception("Registration request does not contain any scope values");
            }
            if (!registrationRequest.getScope().contains(OidcConstants.StandardScopes.OPENID.getScope())) {
                throw new Exception("Registration request scopes do not contain " + OidcConstants.StandardScopes.OPENID.getScope());
            }
            OidcRegisteredService registeredService = new OidcRegisteredService();
            registeredService.setName(registrationRequest.getClientName());
            registeredService.setSectorIdentifierUri(registrationRequest.getSectorIdentifierUri());
            registeredService.setSubjectType(registrationRequest.getSubjectType());
            if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)OidcSubjectTypes.PAIRWISE.getType(), (CharSequence)registeredService.getSubjectType())) {
                registeredService.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new PairwiseOidcRegisteredServiceUsernameAttributeProvider());
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)registrationRequest.getJwksUri())) {
                registeredService.setJwks(registrationRequest.getJwksUri());
                registeredService.setSignIdToken(true);
            }
            String uri = (String)registrationRequest.getRedirectUris().stream().findFirst().get();
            registeredService.setServiceId(uri);
            registeredService.setClientId(this.clientIdGenerator.getNewString());
            registeredService.setClientSecret(this.clientSecretGenerator.getNewString());
            registeredService.setEvaluationOrder(Integer.MIN_VALUE);
            registeredService.setLogoutUrl(StringUtils.collectionToCommaDelimitedString(registrationRequest.getPostLogoutRedirectUris()));
            HashSet supportedScopes = new HashSet(this.casProperties.getAuthn().getOidc().getScopes());
            supportedScopes.retainAll(registrationRequest.getScopes());
            OidcClientRegistrationResponse clientResponse = this.getClientRegistrationResponse(registrationRequest, registeredService);
            registeredService.setScopes(supportedScopes);
            LinkedHashSet processedScopes = new LinkedHashSet(supportedScopes);
            registeredService.setScopes(processedScopes);
            registeredService.setDescription("Dynamically registered service ".concat(registeredService.getName()).concat(" with grant types ").concat(String.join((CharSequence)",", clientResponse.getGrantTypes())).concat(" and with scopes ").concat(String.join((CharSequence)",", registeredService.getScopes())).concat(" and response types ").concat(String.join((CharSequence)",", clientResponse.getResponseTypes())));
            registeredService.setDynamicallyRegistered(true);
            this.scopeToAttributesFilter.reconcile((RegisteredService)registeredService);
            return new ResponseEntity((Object)clientResponse, HttpStatus.CREATED);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("error", "invalid_client_metadata");
            map.put("error_message", e.getMessage());
            return new ResponseEntity(map, HttpStatus.BAD_REQUEST);
        }
    }

    protected OidcClientRegistrationResponse getClientRegistrationResponse(OidcClientRegistrationRequest registrationRequest, OidcRegisteredService registeredService) {
        OidcClientRegistrationResponse clientResponse = new OidcClientRegistrationResponse();
        clientResponse.setApplicationType("web");
        clientResponse.setClientId(registeredService.getClientId());
        clientResponse.setClientSecret(registeredService.getClientSecret());
        clientResponse.setSubjectType("public");
        clientResponse.setTokenEndpointAuthMethod(registrationRequest.getTokenEndpointAuthMethod());
        clientResponse.setClientName(registeredService.getName());
        clientResponse.setGrantTypes(CollectionUtils.wrapList((Object[])new String[]{OAuth20GrantTypes.AUTHORIZATION_CODE.name().toLowerCase(), OAuth20GrantTypes.REFRESH_TOKEN.name().toLowerCase()}));
        clientResponse.setRedirectUris(CollectionUtils.wrap((Object)registeredService.getServiceId()));
        clientResponse.setResponseTypes(CollectionUtils.wrap((Object)OAuth20ResponseTypes.CODE.name().toLowerCase()));
        return clientResponse;
    }
}

