/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.logout;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.logout.slo.SingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.endpoints.BaseOAuth20Controller;
import org.apereo.cas.ticket.IdTokenSigningAndEncryptionService;
import org.apereo.cas.ticket.accesstoken.AccessTokenFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.jose4j.jwt.JwtClaims;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.web.util.UriComponentsBuilder;

public class OidcLogoutEndpointController
extends BaseOAuth20Controller {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcLogoutEndpointController.class);
    private final AuditableExecution registeredServiceAccessStrategyEnforcer;
    private final IdTokenSigningAndEncryptionService idTokenSigningAndEncryptionService;
    private final SingleLogoutServiceLogoutUrlBuilder singleLogoutServiceLogoutUrlBuilder;

    public OidcLogoutEndpointController(ServicesManager servicesManager, TicketRegistry ticketRegistry, AccessTokenFactory accessTokenFactory, PrincipalFactory principalFactory, ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory, OAuth20ProfileScopeToAttributesFilter scopeToAttributesFilter, CasConfigurationProperties casProperties, CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator, AuditableExecution registeredServiceAccessStrategyEnforcer, IdTokenSigningAndEncryptionService idTokenSigningAndEncryptionService, SingleLogoutServiceLogoutUrlBuilder singleLogoutServiceLogoutUrlBuilder) {
        super(servicesManager, ticketRegistry, accessTokenFactory, principalFactory, webApplicationServiceServiceFactory, scopeToAttributesFilter, casProperties, ticketGrantingTicketCookieGenerator);
        this.registeredServiceAccessStrategyEnforcer = registeredServiceAccessStrategyEnforcer;
        this.idTokenSigningAndEncryptionService = idTokenSigningAndEncryptionService;
        this.singleLogoutServiceLogoutUrlBuilder = singleLogoutServiceLogoutUrlBuilder;
    }

    @GetMapping(value={"/oidc/logout"}, produces={"application/json"})
    public View handleRequestInternal(@RequestParam(value="post_logout_redirect_uri", required=false) String postLogoutRedirectUrl, @RequestParam(value="state", required=false) String state, @RequestParam(value="id_token_hint", required=false) String idToken, HttpServletRequest request, HttpServletResponse response) {
        if (StringUtils.isNotBlank((CharSequence)idToken)) {
            boolean matchResult;
            JwtClaims claims = this.idTokenSigningAndEncryptionService.validate(idToken);
            String clientId = claims.getStringClaimValue("client_id");
            OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)this.servicesManager, (String)clientId);
            WebApplicationService service = (WebApplicationService)this.webApplicationServiceServiceFactory.createService(clientId);
            AuditableContext audit = AuditableContext.builder().service((Service)service).registeredService((RegisteredService)registeredService).retrievePrincipalAttributesFromReleasePolicy(Boolean.FALSE).build();
            AuditableExecutionResult accessResult = this.registeredServiceAccessStrategyEnforcer.execute(audit);
            accessResult.throwExceptionIfNeeded();
            Collection urls = this.singleLogoutServiceLogoutUrlBuilder.determineLogoutUrl((RegisteredService)registeredService, service);
            if (StringUtils.isNotBlank((CharSequence)postLogoutRedirectUrl) && (matchResult = urls.stream().anyMatch(url -> url.getUrl().equalsIgnoreCase(postLogoutRedirectUrl)))) {
                return this.getLogoutRedirectView(state, postLogoutRedirectUrl);
            }
            if (urls.isEmpty()) {
                return this.getLogoutRedirectView(state, null);
            }
            return this.getLogoutRedirectView(state, urls.toArray()[0].toString());
        }
        return this.getLogoutRedirectView(state, null);
    }

    private View getLogoutRedirectView(String state, String redirectUrl) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)this.casProperties.getServer().getLogoutUrl());
        if (StringUtils.isNotBlank((CharSequence)redirectUrl)) {
            builder.queryParam(this.casProperties.getLogout().getRedirectParameter(), new Object[]{redirectUrl});
        }
        if (StringUtils.isNotBlank((CharSequence)state)) {
            builder.queryParam("state", new Object[]{redirectUrl});
        }
        String logoutUrl = builder.build().toUriString();
        return new RedirectView(logoutUrl);
    }
}

