/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.token;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.endpoints.BaseOAuth20Controller;
import org.apereo.cas.ticket.accesstoken.AccessTokenFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.HttpRequestUtils;
import org.apereo.cas.util.Pac4jUtils;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.extractor.BasicAuthExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;

public class OidcRevocationEndpointController
extends BaseOAuth20Controller {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcRevocationEndpointController.class);
    private final AuditableExecution registeredServiceAccessStrategyEnforcer;

    public OidcRevocationEndpointController(ServicesManager servicesManager, TicketRegistry ticketRegistry, AccessTokenFactory accessTokenFactory, PrincipalFactory principalFactory, ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory, OAuth20ProfileScopeToAttributesFilter scopeToAttributesFilter, CasConfigurationProperties casProperties, CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator, AuditableExecution registeredServiceAccessStrategyEnforcer) {
        super(servicesManager, ticketRegistry, accessTokenFactory, principalFactory, webApplicationServiceServiceFactory, scopeToAttributesFilter, casProperties, ticketGrantingTicketCookieGenerator);
        this.registeredServiceAccessStrategyEnforcer = registeredServiceAccessStrategyEnforcer;
    }

    @PostMapping(value={"/oidc/revoke"})
    public ResponseEntity<String> handleRequestInternal(HttpServletRequest request, HttpServletResponse response) {
        try {
            BasicAuthExtractor authExtractor = new BasicAuthExtractor();
            UsernamePasswordCredentials credentials = authExtractor.extract((WebContext)Pac4jUtils.getPac4jJ2EContext((HttpServletRequest)request, (HttpServletResponse)response));
            if (credentials == null) {
                throw new IllegalArgumentException("No credentials are provided to verify revocation of the token");
            }
            OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)this.servicesManager, (String)credentials.getUsername());
            WebApplicationService service = (WebApplicationService)this.webApplicationServiceServiceFactory.createService(registeredService.getServiceId());
            AuditableContext audit = AuditableContext.builder().service((Service)service).registeredService((RegisteredService)registeredService).build();
            AuditableExecutionResult accessResult = this.registeredServiceAccessStrategyEnforcer.execute(audit);
            if (!accessResult.isExecutionFailure() && HttpRequestUtils.doesParameterExist((HttpServletRequest)request, (String)"token") && OAuth20Utils.checkClientSecret((OAuthRegisteredService)registeredService, (String)credentials.getPassword())) {
                String token = request.getParameter("token");
                LOGGER.debug("Located token [{}] in the revocation request", (Object)token);
                this.ticketRegistry.deleteTicket(token);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return new ResponseEntity(HttpStatus.OK);
    }
}

