/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.config;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderResolver;
import org.apereo.cas.authentication.MultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.RestEndpointProperties;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.apereo.cas.configuration.model.support.oidc.OidcWebFingerProperties;
import org.apereo.cas.logout.LogoutExecutionPlanConfigurer;
import org.apereo.cas.logout.slo.SingleLogoutMessageCreator;
import org.apereo.cas.logout.slo.SingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.logout.slo.SingleLogoutServiceLogoutUrlBuilderConfigurer;
import org.apereo.cas.logout.slo.SingleLogoutServiceMessageHandler;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.oidc.authn.OidcAccessTokenAuthenticator;
import org.apereo.cas.oidc.authn.OidcClientConfigurationAccessTokenAuthenticator;
import org.apereo.cas.oidc.authn.OidcClientSecretJwtAuthenticator;
import org.apereo.cas.oidc.authn.OidcPrivateKeyJwtAuthenticator;
import org.apereo.cas.oidc.claims.mapping.OidcAttributeToScopeClaimMapper;
import org.apereo.cas.oidc.claims.mapping.OidcDefaultAttributeToScopeClaimMapper;
import org.apereo.cas.oidc.discovery.OidcServerDiscoverySettings;
import org.apereo.cas.oidc.discovery.OidcServerDiscoverySettingsFactory;
import org.apereo.cas.oidc.discovery.webfinger.OidcWebFingerDiscoveryService;
import org.apereo.cas.oidc.discovery.webfinger.OidcWebFingerUserInfoRepository;
import org.apereo.cas.oidc.discovery.webfinger.userinfo.OidcEchoingWebFingerUserInfoRepository;
import org.apereo.cas.oidc.discovery.webfinger.userinfo.OidcGroovyWebFingerUserInfoRepository;
import org.apereo.cas.oidc.discovery.webfinger.userinfo.OidcRestfulWebFingerUserInfoRepository;
import org.apereo.cas.oidc.dynareg.OidcClientRegistrationRequest;
import org.apereo.cas.oidc.dynareg.OidcClientRegistrationRequestSerializer;
import org.apereo.cas.oidc.issuer.OidcDefaultIssuerService;
import org.apereo.cas.oidc.issuer.OidcIssuerService;
import org.apereo.cas.oidc.jwks.OidcDefaultJsonWebKeystoreCacheLoader;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeystoreGeneratorService;
import org.apereo.cas.oidc.jwks.OidcRegisteredServiceJsonWebKeystoreCacheLoader;
import org.apereo.cas.oidc.jwks.OidcServiceJsonWebKeystoreCacheExpirationPolicy;
import org.apereo.cas.oidc.jwks.generator.OidcDefaultJsonWebKeystoreGeneratorService;
import org.apereo.cas.oidc.jwks.generator.OidcRestfulJsonWebKeystoreGeneratorService;
import org.apereo.cas.oidc.profile.OidcProfileScopeToAttributesFilter;
import org.apereo.cas.oidc.profile.OidcUserProfileDataCreator;
import org.apereo.cas.oidc.profile.OidcUserProfileSigningAndEncryptionService;
import org.apereo.cas.oidc.profile.OidcUserProfileViewRenderer;
import org.apereo.cas.oidc.scopes.DefaultOidcAttributeReleasePolicyFactory;
import org.apereo.cas.oidc.scopes.OidcAttributeReleasePolicyFactory;
import org.apereo.cas.oidc.services.OidcServiceRegistryListener;
import org.apereo.cas.oidc.services.OidcServicesManagerRegisteredServiceLocator;
import org.apereo.cas.oidc.slo.OidcSingleLogoutMessageCreator;
import org.apereo.cas.oidc.slo.OidcSingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.oidc.slo.OidcSingleLogoutServiceMessageHandler;
import org.apereo.cas.oidc.token.OidcIdTokenGeneratorService;
import org.apereo.cas.oidc.token.OidcIdTokenSigningAndEncryptionService;
import org.apereo.cas.oidc.token.OidcJwtAccessTokenCipherExecutor;
import org.apereo.cas.oidc.token.OidcRegisteredServiceJwtAccessTokenCipherExecutor;
import org.apereo.cas.oidc.util.OidcRequestSupport;
import org.apereo.cas.oidc.web.OidcAccessTokenResponseGenerator;
import org.apereo.cas.oidc.web.OidcCallbackAuthorizeViewResolver;
import org.apereo.cas.oidc.web.OidcCasClientRedirectActionBuilder;
import org.apereo.cas.oidc.web.OidcConsentApprovalViewResolver;
import org.apereo.cas.oidc.web.OidcHandlerInterceptorAdapter;
import org.apereo.cas.oidc.web.OidcImplicitIdTokenAndTokenAuthorizationResponseBuilder;
import org.apereo.cas.oidc.web.OidcImplicitIdTokenAuthorizationResponseBuilder;
import org.apereo.cas.oidc.web.controllers.authorize.OidcAuthorizeEndpointController;
import org.apereo.cas.oidc.web.controllers.discovery.OidcWellKnownEndpointController;
import org.apereo.cas.oidc.web.controllers.dynareg.OidcClientConfigurationEndpointController;
import org.apereo.cas.oidc.web.controllers.dynareg.OidcDynamicClientRegistrationEndpointController;
import org.apereo.cas.oidc.web.controllers.introspection.OidcIntrospectionEndpointController;
import org.apereo.cas.oidc.web.controllers.jwks.OidcJwksEndpointController;
import org.apereo.cas.oidc.web.controllers.logout.OidcLogoutEndpointController;
import org.apereo.cas.oidc.web.controllers.logout.OidcPostLogoutRedirectUrlMatcher;
import org.apereo.cas.oidc.web.controllers.profile.OidcUserProfileEndpointController;
import org.apereo.cas.oidc.web.controllers.token.OidcAccessTokenEndpointController;
import org.apereo.cas.oidc.web.controllers.token.OidcRevocationEndpointController;
import org.apereo.cas.oidc.web.flow.OidcMultifactorAuthenticationTrigger;
import org.apereo.cas.oidc.web.flow.OidcRegisteredServiceUIAction;
import org.apereo.cas.oidc.web.flow.OidcWebflowConfigurer;
import org.apereo.cas.services.RegisteredServiceCipherExecutor;
import org.apereo.cas.services.ServiceRegistryListener;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.ServicesManagerRegisteredServiceLocator;
import org.apereo.cas.support.oauth.authenticator.OAuth20CasAuthenticationBuilder;
import org.apereo.cas.support.oauth.authenticator.OAuthAuthenticationClientProvider;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.profile.OAuth20UserProfileDataCreator;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20AuthorizationRequestValidator;
import org.apereo.cas.support.oauth.validator.token.OAuth20TokenRequestValidator;
import org.apereo.cas.support.oauth.web.response.OAuth20CasClientRedirectActionBuilder;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenGrantRequestExtractor;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20AccessTokenResponseGenerator;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationCodeAuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20ClientCredentialsResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20InvalidAuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20ResourceOwnerCredentialsResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20TokenAuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.views.ConsentApprovalViewResolver;
import org.apereo.cas.support.oauth.web.views.OAuth20CallbackAuthorizeViewResolver;
import org.apereo.cas.support.oauth.web.views.OAuth20UserProfileViewRenderer;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.IdTokenGeneratorService;
import org.apereo.cas.ticket.OAuth20TokenSigningAndEncryptionService;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessTokenFactory;
import org.apereo.cas.ticket.accesstoken.OAuth20JwtBuilder;
import org.apereo.cas.ticket.code.OAuth20CodeFactory;
import org.apereo.cas.ticket.device.OAuth20DeviceTokenFactory;
import org.apereo.cas.ticket.device.OAuth20DeviceUserCodeFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.gen.DefaultRandomStringGenerator;
import org.apereo.cas.util.gen.RandomStringGenerator;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.util.serialization.StringSerializer;
import org.apereo.cas.validation.CasProtocolViewFactory;
import org.apereo.cas.web.ProtocolEndpointWebSecurityConfigurer;
import org.apereo.cas.web.UrlValidator;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.CasWebflowEventResolutionConfigurationContext;
import org.apereo.cas.web.flow.resolver.impl.mfa.DefaultMultifactorAuthenticationProviderWebflowEventResolver;
import org.jose4j.jwk.PublicJsonWebKey;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.credentials.extractor.BearerAuthExtractor;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.http.adapter.JEEHttpActionAdapter;
import org.pac4j.http.client.direct.DirectFormClient;
import org.pac4j.http.client.direct.HeaderClient;
import org.pac4j.springframework.web.SecurityInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@Configuration(value="oidcConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class OidcConfiguration
implements WebMvcConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcConfiguration.class);
    @Autowired
    @Qualifier(value="oauthRegisteredServiceCipherExecutor")
    private ObjectProvider<CipherExecutor> oauthRegisteredServiceCipherExecutor;
    @Autowired
    @Qualifier(value="oauthDistributedSessionStore")
    private ObjectProvider<SessionStore> oauthDistributedSessionStore;
    @Autowired
    @Qualifier(value="accessTokenGrantAuditableRequestExtractor")
    private ObjectProvider<AuditableExecution> accessTokenGrantAuditableRequestExtractor;
    @Autowired
    @Qualifier(value="registeredServiceAccessStrategyEnforcer")
    private ObjectProvider<AuditableExecution> registeredServiceAccessStrategyEnforcer;
    @Autowired
    @Qualifier(value="oauthAuthorizationRequestValidators")
    private ObjectProvider<Set<OAuth20AuthorizationRequestValidator>> oauthRequestValidators;
    @Autowired
    @Qualifier(value="grantingTicketExpirationPolicy")
    private ObjectProvider<ExpirationPolicyBuilder> grantingTicketExpirationPolicy;
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    private ObjectProvider<ServiceFactory<WebApplicationService>> webApplicationServiceFactory;
    @Autowired
    @Qualifier(value="deviceTokenExpirationPolicy")
    private ObjectProvider<ExpirationPolicyBuilder> deviceTokenExpirationPolicy;
    @Autowired
    @Qualifier(value="requiresAuthenticationAccessTokenInterceptor")
    private ObjectProvider<HandlerInterceptor> requiresAuthenticationAccessTokenInterceptor;
    @Autowired
    @Qualifier(value="requiresAuthenticationAuthorizeInterceptor")
    private ObjectProvider<HandlerInterceptor> requiresAuthenticationAuthorizeInterceptor;
    @Autowired
    @Qualifier(value="oauthCasAuthenticationBuilder")
    private ObjectProvider<OAuth20CasAuthenticationBuilder> authenticationBuilder;
    @Autowired
    @Qualifier(value="loginFlowRegistry")
    private ObjectProvider<FlowDefinitionRegistry> loginFlowDefinitionRegistry;
    @Autowired
    @Qualifier(value="logoutFlowRegistry")
    private ObjectProvider<FlowDefinitionRegistry> logoutFlowDefinitionRegistry;
    @Autowired
    private ObjectProvider<FlowBuilderServices> flowBuilderServices;
    @Autowired
    @Qualifier(value="initialAuthenticationAttemptWebflowEventResolver")
    private ObjectProvider<CasDelegatingWebflowEventResolver> initialAuthenticationAttemptWebflowEventResolver;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private ObjectProvider<CentralAuthenticationService> centralAuthenticationService;
    @Autowired
    @Qualifier(value="oauth20AuthenticationRequestServiceSelectionStrategy")
    private ObjectProvider<AuthenticationServiceSelectionStrategy> oauth20AuthenticationServiceSelectionStrategy;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="casProtocolViewFactory")
    private ObjectProvider<CasProtocolViewFactory> casProtocolViewFactory;
    @Autowired
    @Qualifier(value="singleLogoutServiceLogoutUrlBuilder")
    private ObjectProvider<SingleLogoutServiceLogoutUrlBuilder> singleLogoutServiceLogoutUrlBuilder;
    @Autowired
    @Qualifier(value="oauthSecConfig")
    private ObjectProvider<Config> oauthSecConfig;
    @Autowired
    @Qualifier(value="ticketGrantingTicketCookieGenerator")
    private ObjectProvider<CasCookieBuilder> ticketGrantingTicketCookieGenerator;
    @Autowired
    @Qualifier(value="defaultTicketRegistrySupport")
    private ObjectProvider<TicketRegistrySupport> ticketRegistrySupport;
    @Autowired
    @Qualifier(value="defaultDeviceTokenFactory")
    private ObjectProvider<OAuth20DeviceTokenFactory> defaultDeviceTokenFactory;
    @Autowired
    @Qualifier(value="defaultDeviceUserCodeFactory")
    private ObjectProvider<OAuth20DeviceUserCodeFactory> defaultDeviceUserCodeFactory;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="ticketRegistry")
    private ObjectProvider<TicketRegistry> ticketRegistry;
    @Autowired
    @Qualifier(value="defaultOAuthCodeFactory")
    private ObjectProvider<OAuth20CodeFactory> defaultOAuthCodeFactory;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="casWebflowConfigurationContext")
    private ObjectProvider<CasWebflowEventResolutionConfigurationContext> casWebflowConfigurationContext;
    @Autowired
    @Qualifier(value="accessTokenGrantRequestExtractors")
    private ObjectProvider<Collection<AccessTokenGrantRequestExtractor>> accessTokenGrantRequestExtractors;
    @Autowired
    @Qualifier(value="oauthTokenRequestValidators")
    private ObjectProvider<Collection<OAuth20TokenRequestValidator>> oauthTokenRequestValidators;
    @Autowired
    @Qualifier(value="multifactorAuthenticationProviderResolver")
    private ObjectProvider<MultifactorAuthenticationProviderResolver> multifactorAuthenticationProviderResolver;
    @Autowired
    @Qualifier(value="noRedirectHttpClient")
    private ObjectProvider<HttpClient> httpClient;
    @Autowired
    @Qualifier(value="authenticationServiceSelectionPlan")
    private ObjectProvider<AuthenticationServiceSelectionPlan> authenticationServiceSelectionPlan;
    @Autowired
    @Qualifier(value="oauthDistributedSessionCookieGenerator")
    private ObjectProvider<CasCookieBuilder> oauthDistributedSessionCookieGenerator;
    @Autowired
    @Qualifier(value="oauthInvalidAuthorizationBuilder")
    private ObjectProvider<OAuth20InvalidAuthorizationResponseBuilder> oauthInvalidAuthorizationBuilder;
    @Autowired
    @Qualifier(value="urlValidator")
    private ObjectProvider<UrlValidator> urlValidator;
    @Autowired
    @Qualifier(value="defaultAccessTokenFactory")
    private ObjectProvider<OAuth20AccessTokenFactory> defaultAccessTokenFactory;
    @Autowired
    @Qualifier(value="oauthTokenGenerator")
    private ObjectProvider<OAuth20TokenGenerator> oauthTokenGenerator;

    public void addInterceptors(InterceptorRegistry registry) {
        String baseEndpoint = this.getOidcBaseEndpoint();
        registry.addInterceptor(this.oauthInterceptor()).order(100).addPathPatterns(new String[]{baseEndpoint.concat("/*")});
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcProtocolEndpointConfigurer"})
    @RefreshScope
    public ProtocolEndpointWebSecurityConfigurer<Void> oidcProtocolEndpointConfigurer() {
        final String baseEndpoint = this.getOidcBaseEndpoint();
        return new ProtocolEndpointWebSecurityConfigurer<Void>(){

            public List<String> getIgnoredEndpoints() {
                return List.of(baseEndpoint);
            }
        };
    }

    @Bean
    public ConsentApprovalViewResolver consentApprovalViewResolver() {
        return new OidcConsentApprovalViewResolver(this.casProperties, (SessionStore)this.oauthDistributedSessionStore.getObject());
    }

    @Bean
    public OAuth20CallbackAuthorizeViewResolver callbackAuthorizeViewResolver() {
        return new OidcCallbackAuthorizeViewResolver();
    }

    @Bean
    public OAuth20CasClientRedirectActionBuilder oauthCasClientRedirectActionBuilder() {
        return new OidcCasClientRedirectActionBuilder(this.oidcRequestSupport());
    }

    @Bean
    public HandlerInterceptor requiresAuthenticationDynamicRegistrationInterceptor() {
        String clients = String.join((CharSequence)",", "clientBasicAuth", "clientAccessTokenAuth", "clientForm", "userForm");
        SecurityInterceptor interceptor = new SecurityInterceptor((Config)this.oauthSecConfig.getObject(), clients, (HttpActionAdapter)JEEHttpActionAdapter.INSTANCE);
        interceptor.setAuthorizers("isFullyAuthenticated");
        return interceptor;
    }

    @Bean
    public HandlerInterceptor requiresAuthenticationClientConfigurationInterceptor() {
        String clients = String.join((CharSequence)",", "ClientRegistrationClient");
        SecurityInterceptor interceptor = new SecurityInterceptor((Config)this.oauthSecConfig.getObject(), clients, (HttpActionAdapter)JEEHttpActionAdapter.INSTANCE);
        interceptor.setAuthorizers("isFullyAuthenticated");
        return interceptor;
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcCasClientRedirectActionBuilder"})
    @RefreshScope
    public OAuth20CasClientRedirectActionBuilder oidcCasClientRedirectActionBuilder() {
        return new OidcCasClientRedirectActionBuilder(this.oidcRequestSupport());
    }

    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcIdTokenGenerator"})
    @Bean
    public IdTokenGeneratorService oidcIdTokenGenerator() {
        OidcConfigurationContext context = this.oidcConfigurationContext();
        context.setIdTokenSigningAndEncryptionService(this.oidcTokenSigningAndEncryptionService());
        return new OidcIdTokenGeneratorService(context);
    }

    @ConditionalOnMissingBean(name={"oidcAccessTokenResponseGenerator"})
    @Bean
    @RefreshScope
    public OAuth20AccessTokenResponseGenerator oidcAccessTokenResponseGenerator() {
        return new OidcAccessTokenResponseGenerator(this.oidcIdTokenGenerator(), this.accessTokenJwtBuilder(), this.casProperties, this.oidcIssuerService());
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcRequestSupport"})
    @RefreshScope
    public OidcRequestSupport oidcRequestSupport() {
        return new OidcRequestSupport((CasCookieBuilder)this.ticketGrantingTicketCookieGenerator.getObject(), (TicketRegistrySupport)this.ticketRegistrySupport.getObject(), this.oidcIssuerService());
    }

    @ConditionalOnMissingBean(name={"oidcPrincipalFactory"})
    @Bean
    @RefreshScope
    public PrincipalFactory oidcPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcAttributeToScopeClaimMapper"})
    public OidcAttributeToScopeClaimMapper oidcAttributeToScopeClaimMapper() {
        Map mappings = this.casProperties.getAuthn().getOidc().getCore().getClaimsMap();
        return new OidcDefaultAttributeToScopeClaimMapper(mappings);
    }

    @Bean
    @RefreshScope
    public OAuth20ProfileScopeToAttributesFilter profileScopeToAttributesFilter() {
        return new OidcProfileScopeToAttributesFilter(this.oidcPrincipalFactory(), this.casProperties, this.oidcAttributeReleasePolicyFactory());
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcServiceRegistryListener"})
    public ServiceRegistryListener oidcServiceRegistryListener() {
        return new OidcServiceRegistryListener(this.oidcAttributeReleasePolicyFactory());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcAttributeReleasePolicyFactory"})
    public OidcAttributeReleasePolicyFactory oidcAttributeReleasePolicyFactory() {
        return new DefaultOidcAttributeReleasePolicyFactory(this.casProperties);
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcServicesManagerRegisteredServiceLocator"})
    public ServicesManagerRegisteredServiceLocator oidcServicesManagerRegisteredServiceLocator() {
        return new OidcServicesManagerRegisteredServiceLocator();
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"oidcIntrospectionEndpointController"})
    public OidcIntrospectionEndpointController oidcIntrospectionEndpointController() {
        OidcConfigurationContext context = this.oidcConfigurationContext();
        return new OidcIntrospectionEndpointController(context);
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"postLogoutRedirectUrlMatcher"})
    public OidcPostLogoutRedirectUrlMatcher postLogoutRedirectUrlMatcher() {
        return String::equalsIgnoreCase;
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"oidcLogoutEndpointController"})
    public OidcLogoutEndpointController oidcLogoutEndpointController() {
        OidcConfigurationContext context = this.oidcConfigurationContext();
        return new OidcLogoutEndpointController(context, this.postLogoutRedirectUrlMatcher(), (UrlValidator)this.urlValidator.getObject());
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"oidcRevocationEndpointController"})
    public OidcRevocationEndpointController oidcRevocationEndpointController() {
        OidcConfigurationContext context = this.oidcConfigurationContext();
        return new OidcRevocationEndpointController(context);
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"oidcAccessTokenController"})
    public OidcAccessTokenEndpointController oidcAccessTokenController() {
        OidcConfigurationContext context = this.oidcConfigurationContext();
        return new OidcAccessTokenEndpointController(context, (AuditableExecution)this.accessTokenGrantAuditableRequestExtractor.getObject());
    }

    @ConditionalOnMissingBean(name={"clientRegistrationRequestSerializer"})
    @Bean
    @RefreshScope
    public StringSerializer<OidcClientRegistrationRequest> clientRegistrationRequestSerializer() {
        return new OidcClientRegistrationRequestSerializer();
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"oidcDynamicClientRegistrationEndpointController"})
    public OidcDynamicClientRegistrationEndpointController oidcDynamicClientRegistrationEndpointController() {
        OidcConfigurationContext context = this.oidcConfigurationContext();
        return new OidcDynamicClientRegistrationEndpointController(context);
    }

    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcClientConfigurationEndpointController"})
    @Bean
    public OidcClientConfigurationEndpointController oidcClientConfigurationEndpointController() {
        OidcConfigurationContext context = this.oidcConfigurationContext();
        return new OidcClientConfigurationEndpointController(context);
    }

    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcJwksController"})
    @Bean
    public OidcJwksEndpointController oidcJwksController() {
        OidcConfigurationContext context = this.oidcConfigurationContext();
        return new OidcJwksEndpointController(context, this.oidcJsonWebKeystoreGeneratorService());
    }

    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcWellKnownController"})
    @Bean
    @Autowired
    public OidcWellKnownEndpointController oidcWellKnownController(@Qualifier(value="oidcWebFingerDiscoveryService") OidcWebFingerDiscoveryService oidcWebFingerDiscoveryService) {
        OidcConfigurationContext context = this.oidcConfigurationContext();
        return new OidcWellKnownEndpointController(context, oidcWebFingerDiscoveryService);
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"oidcWebFingerDiscoveryService"})
    public OidcWebFingerDiscoveryService oidcWebFingerDiscoveryService() {
        return new OidcWebFingerDiscoveryService(this.oidcWebFingerUserInfoRepository(), (OidcServerDiscoverySettings)this.oidcServerDiscoverySettingsFactory().getObject());
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcWebFingerUserInfoRepository"})
    public OidcWebFingerUserInfoRepository oidcWebFingerUserInfoRepository() {
        OidcWebFingerProperties.UserInfoRepository userInfo = this.casProperties.getAuthn().getOidc().getWebfinger().getUserInfo();
        if (userInfo.getGroovy().getLocation() != null) {
            return new OidcGroovyWebFingerUserInfoRepository(userInfo.getGroovy().getLocation());
        }
        if (StringUtils.isNotBlank((CharSequence)userInfo.getRest().getUrl())) {
            return new OidcRestfulWebFingerUserInfoRepository((RestEndpointProperties)userInfo.getRest());
        }
        LOGGER.warn("Using [{}] to locate webfinger resources, which is NOT appropriate for production purposes, as it will always echo back the given username/email address and is only useful for testing/demo purposes. Consider choosing and configuring a different repository implementation for locating and fetching user information for webfinger resources, etc.", (Object)OidcEchoingWebFingerUserInfoRepository.class.getSimpleName());
        return new OidcEchoingWebFingerUserInfoRepository();
    }

    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcProfileController"})
    @Bean
    public OidcUserProfileEndpointController oidcProfileController() {
        OidcConfigurationContext context = this.oidcConfigurationContext();
        return new OidcUserProfileEndpointController(context);
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcUserProfileDataCreator"})
    @RefreshScope
    public OAuth20UserProfileDataCreator oidcUserProfileDataCreator() {
        return new OidcUserProfileDataCreator((ServicesManager)this.servicesManager.getObject(), this.profileScopeToAttributesFilter());
    }

    @RefreshScope
    @Bean
    public OidcAuthorizeEndpointController oidcAuthorizeController() {
        OidcConfigurationContext context = this.oidcConfigurationContext();
        return new OidcAuthorizeEndpointController(context);
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcMultifactorAuthenticationTrigger"})
    public MultifactorAuthenticationTrigger oidcMultifactorAuthenticationTrigger() {
        return new OidcMultifactorAuthenticationTrigger(this.casProperties, (MultifactorAuthenticationProviderResolver)this.multifactorAuthenticationProviderResolver.getObject(), (ApplicationContext)this.applicationContext);
    }

    @RefreshScope
    @Bean
    public CasWebflowEventResolver oidcAuthenticationContextWebflowEventResolver() {
        DefaultMultifactorAuthenticationProviderWebflowEventResolver r = new DefaultMultifactorAuthenticationProviderWebflowEventResolver((CasWebflowEventResolutionConfigurationContext)this.casWebflowConfigurationContext.getObject(), this.oidcMultifactorAuthenticationTrigger());
        Objects.requireNonNull((CasDelegatingWebflowEventResolver)this.initialAuthenticationAttemptWebflowEventResolver.getObject()).addDelegate((CasWebflowEventResolver)r);
        return r;
    }

    @ConditionalOnMissingBean(name={"oidcWebflowConfigurer"})
    @Bean
    @DependsOn(value={"defaultWebflowConfigurer"})
    public CasWebflowConfigurer oidcWebflowConfigurer() {
        OidcWebflowConfigurer cfg = new OidcWebflowConfigurer((FlowBuilderServices)this.flowBuilderServices.getObject(), (FlowDefinitionRegistry)this.loginFlowDefinitionRegistry.getObject(), this.oidcRegisteredServiceUIAction(), this.applicationContext, this.casProperties);
        cfg.setLogoutFlowDefinitionRegistry((FlowDefinitionRegistry)this.logoutFlowDefinitionRegistry.getObject());
        return cfg;
    }

    @ConditionalOnMissingBean(name={"oidcRegisteredServiceUIAction"})
    @Bean
    @RefreshScope
    public Action oidcRegisteredServiceUIAction() {
        return new OidcRegisteredServiceUIAction((ServicesManager)this.servicesManager.getObject(), (AuthenticationServiceSelectionStrategy)this.oauth20AuthenticationServiceSelectionStrategy.getObject());
    }

    @ConditionalOnMissingBean(name={"oidcSingleLogoutServiceLogoutUrlBuilderConfigurer"})
    @Bean
    @RefreshScope
    public SingleLogoutServiceLogoutUrlBuilderConfigurer oidcSingleLogoutServiceLogoutUrlBuilderConfigurer() {
        return () -> new OidcSingleLogoutServiceLogoutUrlBuilder((ServicesManager)this.servicesManager.getObject(), (UrlValidator)this.urlValidator.getObject());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcTokenSigningAndEncryptionService"})
    public OAuth20TokenSigningAndEncryptionService oidcTokenSigningAndEncryptionService() {
        return new OidcIdTokenSigningAndEncryptionService(this.oidcDefaultJsonWebKeystoreCache(), this.oidcServiceJsonWebKeystoreCache(), this.oidcIssuerService(), (OidcServerDiscoverySettings)this.oidcServerDiscoverySettingsFactory().getObject());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcUserProfileSigningAndEncryptionService"})
    public OAuth20TokenSigningAndEncryptionService oidcUserProfileSigningAndEncryptionService() {
        return new OidcUserProfileSigningAndEncryptionService(this.oidcDefaultJsonWebKeystoreCache(), this.oidcServiceJsonWebKeystoreCache(), this.oidcIssuerService(), (OidcServerDiscoverySettings)this.oidcServerDiscoverySettingsFactory().getObject());
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcServiceJsonWebKeystoreCache"})
    @RefreshScope
    public LoadingCache<OAuthRegisteredService, Optional<PublicJsonWebKey>> oidcServiceJsonWebKeystoreCache() {
        return Caffeine.newBuilder().maximumSize(1L).expireAfter((Expiry)new OidcServiceJsonWebKeystoreCacheExpirationPolicy(this.casProperties)).build(this.oidcServiceJsonWebKeystoreCacheLoader());
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcDefaultJsonWebKeystoreCache"})
    @RefreshScope
    public LoadingCache<String, Optional<PublicJsonWebKey>> oidcDefaultJsonWebKeystoreCache() {
        OidcProperties oidc = this.casProperties.getAuthn().getOidc();
        return Caffeine.newBuilder().maximumSize(1L).expireAfterWrite(Duration.ofMinutes(oidc.getJwks().getJwksCacheInMinutes())).build(this.oidcDefaultJsonWebKeystoreCacheLoader());
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcDefaultJsonWebKeystoreCacheLoader"})
    @RefreshScope
    public CacheLoader<String, Optional<PublicJsonWebKey>> oidcDefaultJsonWebKeystoreCacheLoader() {
        return new OidcDefaultJsonWebKeystoreCacheLoader(this.oidcJsonWebKeystoreGeneratorService());
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcServiceJsonWebKeystoreCacheLoader"})
    public CacheLoader<OAuthRegisteredService, Optional<PublicJsonWebKey>> oidcServiceJsonWebKeystoreCacheLoader() {
        return new OidcRegisteredServiceJsonWebKeystoreCacheLoader((ApplicationContext)this.applicationContext);
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcServerDiscoverySettingsFactory"})
    public FactoryBean<OidcServerDiscoverySettings> oidcServerDiscoverySettingsFactory() {
        return new OidcServerDiscoverySettingsFactory(this.casProperties, this.oidcIssuerService());
    }

    @Bean(initMethod="generate")
    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcJsonWebKeystoreGeneratorService"})
    public OidcJsonWebKeystoreGeneratorService oidcJsonWebKeystoreGeneratorService() {
        OidcProperties oidc = this.casProperties.getAuthn().getOidc();
        if (StringUtils.isNotBlank((CharSequence)oidc.getJwks().getRest().getUrl())) {
            return new OidcRestfulJsonWebKeystoreGeneratorService(oidc);
        }
        return new OidcDefaultJsonWebKeystoreGeneratorService(oidc);
    }

    @Bean
    public HandlerInterceptor oauthInterceptor() {
        OidcProperties oidc = this.casProperties.getAuthn().getOidc();
        OidcConstants.DynamicClientRegistrationMode mode = OidcConstants.DynamicClientRegistrationMode.valueOf((String)((String)StringUtils.defaultIfBlank((CharSequence)oidc.getCore().getDynamicClientRegistrationMode(), (CharSequence)OidcConstants.DynamicClientRegistrationMode.PROTECTED.name())));
        return new OidcHandlerInterceptorAdapter((HandlerInterceptor)this.requiresAuthenticationAccessTokenInterceptor.getObject(), (HandlerInterceptor)this.requiresAuthenticationAuthorizeInterceptor.getObject(), this.requiresAuthenticationDynamicRegistrationInterceptor(), this.requiresAuthenticationClientConfigurationInterceptor(), mode, (Collection)this.accessTokenGrantRequestExtractors.getObject(), (ServicesManager)this.servicesManager.getObject(), (SessionStore)this.oauthDistributedSessionStore.getObject(), (Set)this.oauthRequestValidators.getObject());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcImplicitIdTokenCallbackUrlBuilder"})
    public OAuth20AuthorizationResponseBuilder oidcImplicitIdTokenCallbackUrlBuilder() {
        return new OidcImplicitIdTokenAuthorizationResponseBuilder(this.oidcIdTokenGenerator(), (OAuth20TokenGenerator)this.oauthTokenGenerator.getObject(), (ExpirationPolicyBuilder)this.grantingTicketExpirationPolicy.getObject(), (ServicesManager)this.servicesManager.getObject(), this.accessTokenJwtBuilder(), this.casProperties);
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcImplicitIdTokenAndTokenCallbackUrlBuilder"})
    public OAuth20AuthorizationResponseBuilder oidcImplicitIdTokenAndTokenCallbackUrlBuilder() {
        return new OidcImplicitIdTokenAndTokenAuthorizationResponseBuilder(this.oidcIdTokenGenerator(), (OAuth20TokenGenerator)this.oauthTokenGenerator.getObject(), (ExpirationPolicyBuilder)this.grantingTicketExpirationPolicy.getObject(), (ServicesManager)this.servicesManager.getObject(), this.accessTokenJwtBuilder(), this.casProperties);
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcResourceOwnerCredentialsResponseBuilder"})
    public OAuth20AuthorizationResponseBuilder oidcResourceOwnerCredentialsResponseBuilder() {
        return new OAuth20ResourceOwnerCredentialsResponseBuilder(this.oidcAccessTokenResponseGenerator(), (OAuth20TokenGenerator)this.oauthTokenGenerator.getObject(), this.casProperties);
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcClientCredentialsResponseBuilder"})
    public OAuth20AuthorizationResponseBuilder oidcClientCredentialsResponseBuilder() {
        return new OAuth20ClientCredentialsResponseBuilder(this.oidcAccessTokenResponseGenerator(), (OAuth20TokenGenerator)this.oauthTokenGenerator.getObject(), this.casProperties);
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcTokenResponseBuilder"})
    public OAuth20AuthorizationResponseBuilder oidcTokenResponseBuilder() {
        return new OAuth20TokenAuthorizationResponseBuilder((OAuth20TokenGenerator)this.oauthTokenGenerator.getObject(), (ServicesManager)this.servicesManager.getObject(), this.accessTokenJwtBuilder(), this.casProperties);
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcAuthorizationCodeResponseBuilder"})
    public OAuth20AuthorizationResponseBuilder oidcAuthorizationCodeResponseBuilder() {
        return new OAuth20AuthorizationCodeAuthorizationResponseBuilder((TicketRegistry)this.ticketRegistry.getObject(), (OAuth20CodeFactory)this.defaultOAuthCodeFactory.getObject(), (ServicesManager)this.servicesManager.getObject());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcAuthorizationResponseBuilders"})
    public Set<OAuth20AuthorizationResponseBuilder> oidcAuthorizationResponseBuilders() {
        Map builders = this.applicationContext.getBeansOfType(OAuth20AuthorizationResponseBuilder.class, false, true);
        return builders.entrySet().stream().filter(e -> !((String)e.getKey()).startsWith("oauth")).map(Map.Entry::getValue).collect(Collectors.toSet());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcRegisteredServiceJwtAccessTokenCipherExecutor"})
    public RegisteredServiceCipherExecutor oidcRegisteredServiceJwtAccessTokenCipherExecutor() {
        return new OidcRegisteredServiceJwtAccessTokenCipherExecutor(this.oidcDefaultJsonWebKeystoreCache(), this.oidcServiceJsonWebKeystoreCache(), this.oidcIssuerService());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcAccessTokenJwtCipherExecutor"})
    public CipherExecutor<Serializable, String> oidcAccessTokenJwtCipherExecutor() {
        return new OidcJwtAccessTokenCipherExecutor(this.oidcDefaultJsonWebKeystoreCache(), this.oidcIssuerService());
    }

    @Bean
    public OAuthAuthenticationClientProvider oidcClientConfigurationAuthenticationClientProvider() {
        return () -> {
            HeaderClient accessTokenClient = new HeaderClient();
            accessTokenClient.setCredentialsExtractor((CredentialsExtractor)new BearerAuthExtractor());
            accessTokenClient.setAuthenticator((Authenticator)new OidcClientConfigurationAccessTokenAuthenticator((TicketRegistry)this.ticketRegistry.getObject(), this.accessTokenJwtBuilder()));
            accessTokenClient.setName("ClientRegistrationClient");
            accessTokenClient.init();
            return accessTokenClient;
        };
    }

    @Bean
    public OAuthAuthenticationClientProvider oidcPrivateKeyJwtClientProvider() {
        return () -> {
            DirectFormClient privateKeyJwtClient = new DirectFormClient((Authenticator)new OidcPrivateKeyJwtAuthenticator((ServicesManager)this.servicesManager.getObject(), (AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getObject(), (TicketRegistry)this.ticketRegistry.getObject(), (ServiceFactory)this.webApplicationServiceFactory.getObject(), this.casProperties, (ApplicationContext)this.applicationContext));
            privateKeyJwtClient.setName("ClientPrivateKeyJwtClient");
            privateKeyJwtClient.setUsernameParameter("client_assertion_type");
            privateKeyJwtClient.setPasswordParameter("client_assertion");
            privateKeyJwtClient.init();
            return privateKeyJwtClient;
        };
    }

    @Bean
    public OAuthAuthenticationClientProvider oidcClientSecretJwtClientProvider() {
        return () -> {
            DirectFormClient client = new DirectFormClient((Authenticator)new OidcClientSecretJwtAuthenticator((ServicesManager)this.servicesManager.getObject(), (AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getObject(), (TicketRegistry)this.ticketRegistry.getObject(), (ServiceFactory)this.webApplicationServiceFactory.getObject(), this.casProperties, (ApplicationContext)this.applicationContext));
            client.setName("ClientSecretJwtClient");
            client.setUsernameParameter("client_assertion_type");
            client.setPasswordParameter("client_assertion");
            client.init();
            return client;
        };
    }

    @Bean
    public Authenticator oAuthAccessTokenAuthenticator() {
        return new OidcAccessTokenAuthenticator((TicketRegistry)this.ticketRegistry.getObject(), this.oidcTokenSigningAndEncryptionService(), (ServicesManager)this.servicesManager.getObject(), this.accessTokenJwtBuilder());
    }

    @ConditionalOnMissingBean(name={"oidcCasWebflowExecutionPlanConfigurer"})
    @Bean
    public CasWebflowExecutionPlanConfigurer oidcCasWebflowExecutionPlanConfigurer() {
        return plan -> plan.registerWebflowConfigurer(this.oidcWebflowConfigurer());
    }

    @ConditionalOnMissingBean(name={"oidcUserProfileViewRenderer"})
    @Bean
    @RefreshScope
    public OAuth20UserProfileViewRenderer oidcUserProfileViewRenderer() {
        return new OidcUserProfileViewRenderer(this.casProperties.getAuthn().getOauth(), (ServicesManager)this.servicesManager.getObject(), this.oidcUserProfileSigningAndEncryptionService());
    }

    @Bean
    public View oidcConfirmView() {
        return ((CasProtocolViewFactory)this.casProtocolViewFactory.getObject()).create(this.applicationContext, "protocol/oidc/confirm");
    }

    @ConditionalOnMissingBean(name={"oidcSingleLogoutMessageCreator"})
    @Bean
    @RefreshScope
    public SingleLogoutMessageCreator oidcSingleLogoutMessageCreator() {
        return new OidcSingleLogoutMessageCreator(this.oidcConfigurationContext());
    }

    @ConditionalOnMissingBean(name={"oidcSingleLogoutServiceMessageHandler"})
    @Bean
    @RefreshScope
    public SingleLogoutServiceMessageHandler oidcSingleLogoutServiceMessageHandler() {
        return new OidcSingleLogoutServiceMessageHandler((HttpClient)this.httpClient.getObject(), this.oidcSingleLogoutMessageCreator(), (ServicesManager)this.servicesManager.getObject(), (SingleLogoutServiceLogoutUrlBuilder)this.singleLogoutServiceLogoutUrlBuilder.getObject(), this.casProperties.getSlo().isAsynchronous(), (AuthenticationServiceSelectionPlan)this.authenticationServiceSelectionPlan.getObject(), this.oidcIssuerService());
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcLogoutExecutionPlanConfigurer"})
    public LogoutExecutionPlanConfigurer oidcLogoutExecutionPlanConfigurer() {
        return plan -> plan.registerSingleLogoutServiceMessageHandler(this.oidcSingleLogoutServiceMessageHandler());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcAccessTokenJwtBuilder"})
    public JwtBuilder accessTokenJwtBuilder() {
        return new OAuth20JwtBuilder(this.oidcAccessTokenJwtCipherExecutor(), (ServicesManager)this.servicesManager.getObject(), this.oidcRegisteredServiceJwtAccessTokenCipherExecutor());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcIssuerService"})
    public OidcIssuerService oidcIssuerService() {
        return new OidcDefaultIssuerService(this.casProperties.getAuthn().getOidc());
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcConfigurationContext"})
    public OidcConfigurationContext oidcConfigurationContext() {
        return (OidcConfigurationContext)((OidcConfigurationContext.OidcConfigurationContextBuilder)((OidcConfigurationContext.OidcConfigurationContextBuilder)OidcConfigurationContext.builder().oidcRequestSupport(this.oidcRequestSupport()).issuerService(this.oidcIssuerService()).attributeToScopeClaimMapper(this.oidcAttributeToScopeClaimMapper()).applicationContext(this.applicationContext)).registeredServiceCipherExecutor((CipherExecutor)this.oauthRegisteredServiceCipherExecutor.getObject())).sessionStore((SessionStore)this.oauthDistributedSessionStore.getObject()).servicesManager((ServicesManager)this.servicesManager.getObject()).ticketRegistry((TicketRegistry)this.ticketRegistry.getObject()).accessTokenFactory((OAuth20AccessTokenFactory)this.defaultAccessTokenFactory.getObject()).deviceTokenFactory((OAuth20DeviceTokenFactory)this.defaultDeviceTokenFactory.getObject()).deviceUserCodeFactory((OAuth20DeviceUserCodeFactory)this.defaultDeviceUserCodeFactory.getObject()).clientRegistrationRequestSerializer(this.clientRegistrationRequestSerializer()).clientIdGenerator((RandomStringGenerator)new DefaultRandomStringGenerator()).clientSecretGenerator((RandomStringGenerator)new DefaultRandomStringGenerator()).principalFactory(this.oidcPrincipalFactory()).webApplicationServiceServiceFactory((ServiceFactory)this.webApplicationServiceFactory.getObject()).casProperties(this.casProperties).ticketGrantingTicketCookieGenerator((CasCookieBuilder)this.ticketGrantingTicketCookieGenerator.getObject()).oauthDistributedSessionCookieGenerator((CasCookieBuilder)this.oauthDistributedSessionCookieGenerator.getObject()).oauthConfig((Config)this.oauthSecConfig.getObject()).registeredServiceAccessStrategyEnforcer((AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getObject()).centralAuthenticationService((CentralAuthenticationService)this.centralAuthenticationService.getObject()).callbackAuthorizeViewResolver(this.callbackAuthorizeViewResolver()).profileScopeToAttributesFilter(this.profileScopeToAttributesFilter()).accessTokenGenerator((OAuth20TokenGenerator)this.oauthTokenGenerator.getObject()).accessTokenResponseGenerator(this.oidcAccessTokenResponseGenerator()).deviceTokenExpirationPolicy((ExpirationPolicyBuilder)this.deviceTokenExpirationPolicy.getObject()).accessTokenGrantRequestValidators((Collection)this.oauthTokenRequestValidators.getObject()).userProfileDataCreator(this.oidcUserProfileDataCreator()).userProfileViewRenderer(this.oidcUserProfileViewRenderer()).oAuthCodeFactory((OAuth20CodeFactory)this.defaultOAuthCodeFactory.getObject()).consentApprovalViewResolver(this.consentApprovalViewResolver()).authenticationBuilder((OAuth20CasAuthenticationBuilder)this.authenticationBuilder.getObject()).oauthAuthorizationResponseBuilders(this.oidcAuthorizationResponseBuilders()).oauthInvalidAuthorizationResponseBuilder((OAuth20InvalidAuthorizationResponseBuilder)this.oauthInvalidAuthorizationBuilder.getObject()).oauthRequestValidators((Set)this.oauthRequestValidators.getObject()).singleLogoutServiceLogoutUrlBuilder((SingleLogoutServiceLogoutUrlBuilder)this.singleLogoutServiceLogoutUrlBuilder.getObject()).idTokenSigningAndEncryptionService(this.oidcTokenSigningAndEncryptionService()).accessTokenJwtBuilder(this.accessTokenJwtBuilder()).build();
    }

    private String getOidcBaseEndpoint() {
        String issuer = this.oidcIssuerService().determineIssuer(Optional.empty());
        String endpoint = StringUtils.remove((String)issuer, (String)this.casProperties.getServer().getPrefix());
        return StringUtils.prependIfMissing((String)endpoint, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }
}

