/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.config;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderResolver;
import org.apereo.cas.authentication.MultifactorAuthenticationTrigger;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.oidc.discovery.webfinger.OidcWebFingerDiscoveryService;
import org.apereo.cas.oidc.issuer.OidcIssuerService;
import org.apereo.cas.oidc.jwks.OidcDefaultJsonWebKeystoreCacheLoader;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeystoreGeneratorService;
import org.apereo.cas.oidc.jwks.generator.OidcDefaultJsonWebKeystoreGeneratorService;
import org.apereo.cas.oidc.jwks.generator.OidcRestfulJsonWebKeystoreGeneratorService;
import org.apereo.cas.oidc.web.OidcHandlerInterceptorAdapter;
import org.apereo.cas.oidc.web.OidcLocaleChangeInterceptor;
import org.apereo.cas.oidc.web.controllers.authorize.OidcAuthorizeEndpointController;
import org.apereo.cas.oidc.web.controllers.discovery.OidcWellKnownEndpointController;
import org.apereo.cas.oidc.web.controllers.dynareg.OidcClientConfigurationEndpointController;
import org.apereo.cas.oidc.web.controllers.dynareg.OidcDynamicClientRegistrationEndpointController;
import org.apereo.cas.oidc.web.controllers.introspection.OidcIntrospectionEndpointController;
import org.apereo.cas.oidc.web.controllers.jwks.OidcJwksEndpointController;
import org.apereo.cas.oidc.web.controllers.logout.OidcLogoutEndpointController;
import org.apereo.cas.oidc.web.controllers.logout.OidcPostLogoutRedirectUrlMatcher;
import org.apereo.cas.oidc.web.controllers.profile.OidcUserProfileEndpointController;
import org.apereo.cas.oidc.web.controllers.token.OidcAccessTokenEndpointController;
import org.apereo.cas.oidc.web.controllers.token.OidcRevocationEndpointController;
import org.apereo.cas.oidc.web.flow.OidcCasWebflowLoginContextProvider;
import org.apereo.cas.oidc.web.flow.OidcMultifactorAuthenticationTrigger;
import org.apereo.cas.oidc.web.flow.OidcRegisteredServiceUIAction;
import org.apereo.cas.oidc.web.flow.OidcWebflowConfigurer;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20AuthorizationRequestValidator;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenGrantRequestExtractor;
import org.apereo.cas.validation.CasProtocolViewFactory;
import org.apereo.cas.web.ProtocolEndpointWebSecurityConfigurer;
import org.apereo.cas.web.UrlValidator;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.CasWebflowLoginContextProvider;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.CasWebflowEventResolutionConfigurationContext;
import org.apereo.cas.web.flow.resolver.impl.mfa.DefaultMultifactorAuthenticationProviderWebflowEventResolver;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.jose4j.jwk.PublicJsonWebKey;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.http.adapter.JEEHttpActionAdapter;
import org.pac4j.springframework.web.SecurityInterceptor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@Configuration(value="oidcEndpointsConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class OidcEndpointsConfiguration {
    @Autowired
    @Qualifier(value="oauthDistributedSessionStore")
    private ObjectProvider<SessionStore> oauthDistributedSessionStore;
    @Autowired
    @Qualifier(value="accessTokenGrantAuditableRequestExtractor")
    private ObjectProvider<AuditableExecution> accessTokenGrantAuditableRequestExtractor;
    @Autowired
    @Qualifier(value="oauthAuthorizationRequestValidators")
    private ObjectProvider<Set<OAuth20AuthorizationRequestValidator>> oauthRequestValidators;
    @Autowired
    @Qualifier(value="requiresAuthenticationAccessTokenInterceptor")
    private ObjectProvider<HandlerInterceptor> requiresAuthenticationAccessTokenInterceptor;
    @Autowired
    @Qualifier(value="requiresAuthenticationAuthorizeInterceptor")
    private ObjectProvider<HandlerInterceptor> requiresAuthenticationAuthorizeInterceptor;
    @Autowired
    @Qualifier(value="argumentExtractor")
    private ObjectProvider<ArgumentExtractor> argumentExtractor;
    @Autowired
    @Qualifier(value="loginFlowRegistry")
    private ObjectProvider<FlowDefinitionRegistry> loginFlowDefinitionRegistry;
    @Autowired
    @Qualifier(value="logoutFlowRegistry")
    private ObjectProvider<FlowDefinitionRegistry> logoutFlowDefinitionRegistry;
    @Autowired
    private ObjectProvider<FlowBuilderServices> flowBuilderServices;
    @Autowired
    @Qualifier(value="initialAuthenticationAttemptWebflowEventResolver")
    private ObjectProvider<CasDelegatingWebflowEventResolver> initialAuthenticationAttemptWebflowEventResolver;
    @Autowired
    @Qualifier(value="oauth20AuthenticationRequestServiceSelectionStrategy")
    private ObjectProvider<AuthenticationServiceSelectionStrategy> oauth20AuthenticationServiceSelectionStrategy;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="casProtocolViewFactory")
    private ObjectProvider<CasProtocolViewFactory> casProtocolViewFactory;
    @Autowired
    @Qualifier(value="oidcConfigurationContext")
    private ObjectProvider<OidcConfigurationContext> oidcConfigurationContext;
    @Autowired
    @Qualifier(value="oauthSecConfig")
    private ObjectProvider<Config> oauthSecConfig;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="casWebflowConfigurationContext")
    private ObjectProvider<CasWebflowEventResolutionConfigurationContext> casWebflowConfigurationContext;
    @Autowired
    @Qualifier(value="accessTokenGrantRequestExtractors")
    private ObjectProvider<Collection<AccessTokenGrantRequestExtractor>> accessTokenGrantRequestExtractors;
    @Autowired
    @Qualifier(value="multifactorAuthenticationProviderResolver")
    private ObjectProvider<MultifactorAuthenticationProviderResolver> multifactorAuthenticationProviderResolver;
    @Autowired
    @Qualifier(value="urlValidator")
    private ObjectProvider<UrlValidator> urlValidator;
    @Autowired
    @Qualifier(value="oidcIssuerService")
    private ObjectProvider<OidcIssuerService> oidcIssuerService;

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcMultifactorAuthenticationTrigger"})
    public MultifactorAuthenticationTrigger oidcMultifactorAuthenticationTrigger() {
        return new OidcMultifactorAuthenticationTrigger(this.casProperties, (MultifactorAuthenticationProviderResolver)this.multifactorAuthenticationProviderResolver.getObject(), (ApplicationContext)this.applicationContext);
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcDefaultJsonWebKeystoreCache"})
    @RefreshScope
    public LoadingCache<String, Optional<PublicJsonWebKey>> oidcDefaultJsonWebKeystoreCache() {
        OidcProperties oidc = this.casProperties.getAuthn().getOidc();
        return Caffeine.newBuilder().maximumSize(1L).expireAfterWrite(Duration.ofMinutes(oidc.getJwks().getJwksCacheInMinutes())).build(this.oidcDefaultJsonWebKeystoreCacheLoader());
    }

    @Bean
    public WebMvcConfigurer oidcWebMvcConfigurer() {
        return new WebMvcConfigurer(){

            public void addInterceptors(InterceptorRegistry registry) {
                String baseEndpoint = OidcEndpointsConfiguration.this.getOidcBaseEndpoint((OidcIssuerService)OidcEndpointsConfiguration.this.oidcIssuerService.getObject());
                registry.addInterceptor(OidcEndpointsConfiguration.this.oauthInterceptor()).order(100).addPathPatterns(new String[]{baseEndpoint.concat("/*")});
            }
        };
    }

    @Bean
    public HandlerInterceptor requiresAuthenticationDynamicRegistrationInterceptor() {
        String clients = String.join((CharSequence)",", "clientBasicAuth", "clientAccessTokenAuth", "clientForm", "userForm");
        SecurityInterceptor interceptor = new SecurityInterceptor((Config)this.oauthSecConfig.getObject(), clients, (HttpActionAdapter)JEEHttpActionAdapter.INSTANCE);
        interceptor.setAuthorizers("isFullyAuthenticated");
        return interceptor;
    }

    @Bean
    public HandlerInterceptor requiresAuthenticationClientConfigurationInterceptor() {
        String clients = String.join((CharSequence)",", "ClientRegistrationClient");
        SecurityInterceptor interceptor = new SecurityInterceptor((Config)this.oauthSecConfig.getObject(), clients, (HttpActionAdapter)JEEHttpActionAdapter.INSTANCE);
        interceptor.setAuthorizers("isFullyAuthenticated");
        return interceptor;
    }

    @Bean
    public HandlerInterceptor oauthInterceptor() {
        OidcProperties oidc = this.casProperties.getAuthn().getOidc();
        OidcConstants.DynamicClientRegistrationMode mode = OidcConstants.DynamicClientRegistrationMode.valueOf((String)((String)StringUtils.defaultIfBlank((CharSequence)oidc.getCore().getDynamicClientRegistrationMode(), (CharSequence)OidcConstants.DynamicClientRegistrationMode.PROTECTED.name())));
        return new OidcHandlerInterceptorAdapter((HandlerInterceptor)this.requiresAuthenticationAccessTokenInterceptor.getObject(), (HandlerInterceptor)this.requiresAuthenticationAuthorizeInterceptor.getObject(), this.requiresAuthenticationDynamicRegistrationInterceptor(), this.requiresAuthenticationClientConfigurationInterceptor(), mode, (Collection)this.accessTokenGrantRequestExtractors.getObject(), (ServicesManager)this.servicesManager.getObject(), (SessionStore)this.oauthDistributedSessionStore.getObject(), (Set)this.oauthRequestValidators.getObject());
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcProtocolEndpointConfigurer"})
    @RefreshScope
    public ProtocolEndpointWebSecurityConfigurer<Void> oidcProtocolEndpointConfigurer() {
        final String baseEndpoint = this.getOidcBaseEndpoint((OidcIssuerService)this.oidcIssuerService.getObject());
        return new ProtocolEndpointWebSecurityConfigurer<Void>(){

            public List<String> getIgnoredEndpoints() {
                return List.of(baseEndpoint);
            }
        };
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"oidcIntrospectionEndpointController"})
    public OidcIntrospectionEndpointController oidcIntrospectionEndpointController() {
        return new OidcIntrospectionEndpointController((OidcConfigurationContext)this.oidcConfigurationContext.getObject());
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"postLogoutRedirectUrlMatcher"})
    public OidcPostLogoutRedirectUrlMatcher postLogoutRedirectUrlMatcher() {
        return String::equalsIgnoreCase;
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"oidcLogoutEndpointController"})
    public OidcLogoutEndpointController oidcLogoutEndpointController() {
        return new OidcLogoutEndpointController((OidcConfigurationContext)this.oidcConfigurationContext.getObject(), this.postLogoutRedirectUrlMatcher(), (UrlValidator)this.urlValidator.getObject());
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"oidcRevocationEndpointController"})
    public OidcRevocationEndpointController oidcRevocationEndpointController() {
        return new OidcRevocationEndpointController((OidcConfigurationContext)this.oidcConfigurationContext.getObject());
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"oidcAccessTokenController"})
    public OidcAccessTokenEndpointController oidcAccessTokenController() {
        return new OidcAccessTokenEndpointController((OidcConfigurationContext)this.oidcConfigurationContext.getObject(), (AuditableExecution)this.accessTokenGrantAuditableRequestExtractor.getObject());
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"oidcDynamicClientRegistrationEndpointController"})
    public OidcDynamicClientRegistrationEndpointController oidcDynamicClientRegistrationEndpointController() {
        return new OidcDynamicClientRegistrationEndpointController((OidcConfigurationContext)this.oidcConfigurationContext.getObject());
    }

    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcClientConfigurationEndpointController"})
    @Bean
    public OidcClientConfigurationEndpointController oidcClientConfigurationEndpointController() {
        return new OidcClientConfigurationEndpointController((OidcConfigurationContext)this.oidcConfigurationContext.getObject());
    }

    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcJwksController"})
    @Bean
    public OidcJwksEndpointController oidcJwksController() {
        return new OidcJwksEndpointController((OidcConfigurationContext)this.oidcConfigurationContext.getObject(), this.oidcJsonWebKeystoreGeneratorService());
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcDefaultJsonWebKeystoreCacheLoader"})
    @RefreshScope
    public CacheLoader<String, Optional<PublicJsonWebKey>> oidcDefaultJsonWebKeystoreCacheLoader() {
        return new OidcDefaultJsonWebKeystoreCacheLoader(this.oidcJsonWebKeystoreGeneratorService());
    }

    @Bean(initMethod="generate")
    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcJsonWebKeystoreGeneratorService"})
    public OidcJsonWebKeystoreGeneratorService oidcJsonWebKeystoreGeneratorService() {
        OidcProperties oidc = this.casProperties.getAuthn().getOidc();
        if (StringUtils.isNotBlank((CharSequence)oidc.getJwks().getRest().getUrl())) {
            return new OidcRestfulJsonWebKeystoreGeneratorService(oidc);
        }
        return new OidcDefaultJsonWebKeystoreGeneratorService(oidc);
    }

    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcWellKnownController"})
    @Bean
    @Autowired
    public OidcWellKnownEndpointController oidcWellKnownController(@Qualifier(value="oidcWebFingerDiscoveryService") OidcWebFingerDiscoveryService oidcWebFingerDiscoveryService) {
        return new OidcWellKnownEndpointController((OidcConfigurationContext)this.oidcConfigurationContext.getObject(), oidcWebFingerDiscoveryService);
    }

    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcProfileController"})
    @Bean
    public OidcUserProfileEndpointController oidcProfileController() {
        return new OidcUserProfileEndpointController((OidcConfigurationContext)this.oidcConfigurationContext.getObject());
    }

    @RefreshScope
    @Bean
    public OidcAuthorizeEndpointController oidcAuthorizeController() {
        return new OidcAuthorizeEndpointController((OidcConfigurationContext)this.oidcConfigurationContext.getObject());
    }

    @RefreshScope
    @Bean
    public CasWebflowEventResolver oidcAuthenticationContextWebflowEventResolver() {
        DefaultMultifactorAuthenticationProviderWebflowEventResolver r = new DefaultMultifactorAuthenticationProviderWebflowEventResolver((CasWebflowEventResolutionConfigurationContext)this.casWebflowConfigurationContext.getObject(), this.oidcMultifactorAuthenticationTrigger());
        Objects.requireNonNull((CasDelegatingWebflowEventResolver)this.initialAuthenticationAttemptWebflowEventResolver.getObject()).addDelegate((CasWebflowEventResolver)r);
        return r;
    }

    @ConditionalOnMissingBean(name={"oidcWebflowConfigurer"})
    @Bean
    @DependsOn(value={"defaultWebflowConfigurer"})
    public CasWebflowConfigurer oidcWebflowConfigurer() {
        OidcWebflowConfigurer cfg = new OidcWebflowConfigurer((FlowBuilderServices)this.flowBuilderServices.getObject(), (FlowDefinitionRegistry)this.loginFlowDefinitionRegistry.getObject(), this.oidcRegisteredServiceUIAction(), this.applicationContext, this.casProperties);
        cfg.setLogoutFlowDefinitionRegistry((FlowDefinitionRegistry)this.logoutFlowDefinitionRegistry.getObject());
        return cfg;
    }

    @ConditionalOnMissingBean(name={"oidcRegisteredServiceUIAction"})
    @Bean
    @RefreshScope
    public Action oidcRegisteredServiceUIAction() {
        return new OidcRegisteredServiceUIAction((ServicesManager)this.servicesManager.getObject(), (AuthenticationServiceSelectionStrategy)this.oauth20AuthenticationServiceSelectionStrategy.getObject());
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcLocaleChangeInterceptor"})
    @RefreshScope
    public HandlerInterceptor oidcLocaleChangeInterceptor() {
        OidcLocaleChangeInterceptor interceptor = new OidcLocaleChangeInterceptor(this.casProperties.getLocale(), (ArgumentExtractor)this.argumentExtractor.getObject());
        interceptor.setParamName("ui_locales");
        return interceptor;
    }

    @ConditionalOnMissingBean(name={"oidcCasWebflowExecutionPlanConfigurer"})
    @Bean
    public CasWebflowExecutionPlanConfigurer oidcCasWebflowExecutionPlanConfigurer() {
        return plan -> {
            plan.registerWebflowConfigurer(this.oidcWebflowConfigurer());
            plan.registerWebflowInterceptor(this.oidcLocaleChangeInterceptor());
            plan.registerWebflowLoginContextProvider(this.oidcCasWebflowLoginContextProvider());
        };
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcConfirmView"})
    public View oidcConfirmView() {
        return ((CasProtocolViewFactory)this.casProtocolViewFactory.getObject()).create(this.applicationContext, "protocol/oidc/confirm");
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcCasWebflowLoginContextProvider"})
    @RefreshScope
    public CasWebflowLoginContextProvider oidcCasWebflowLoginContextProvider() {
        return new OidcCasWebflowLoginContextProvider((ArgumentExtractor)this.argumentExtractor.getObject());
    }

    private String getOidcBaseEndpoint(OidcIssuerService issuerService) {
        String issuer = issuerService.determineIssuer(Optional.empty());
        String endpoint = StringUtils.remove((String)issuer, (String)this.casProperties.getServer().getPrefix());
        return StringUtils.prependIfMissing((String)endpoint, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }
}

