/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.config;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.RestEndpointProperties;
import org.apereo.cas.configuration.model.support.oidc.OidcWebFingerProperties;
import org.apereo.cas.logout.slo.SingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.authn.OidcAccessTokenAuthenticator;
import org.apereo.cas.oidc.authn.OidcCasCallbackUrlResolver;
import org.apereo.cas.oidc.authn.OidcClientConfigurationAccessTokenAuthenticator;
import org.apereo.cas.oidc.authn.OidcClientSecretJwtAuthenticator;
import org.apereo.cas.oidc.authn.OidcPrivateKeyJwtAuthenticator;
import org.apereo.cas.oidc.claims.OidcIdTokenClaimCollector;
import org.apereo.cas.oidc.claims.mapping.OidcAttributeToScopeClaimMapper;
import org.apereo.cas.oidc.claims.mapping.OidcDefaultAttributeToScopeClaimMapper;
import org.apereo.cas.oidc.discovery.OidcServerDiscoverySettings;
import org.apereo.cas.oidc.discovery.OidcServerDiscoverySettingsFactory;
import org.apereo.cas.oidc.discovery.webfinger.OidcWebFingerDiscoveryService;
import org.apereo.cas.oidc.discovery.webfinger.OidcWebFingerUserInfoRepository;
import org.apereo.cas.oidc.discovery.webfinger.userinfo.OidcEchoingWebFingerUserInfoRepository;
import org.apereo.cas.oidc.discovery.webfinger.userinfo.OidcGroovyWebFingerUserInfoRepository;
import org.apereo.cas.oidc.discovery.webfinger.userinfo.OidcRestfulWebFingerUserInfoRepository;
import org.apereo.cas.oidc.dynareg.OidcClientRegistrationRequest;
import org.apereo.cas.oidc.dynareg.OidcClientRegistrationRequestSerializer;
import org.apereo.cas.oidc.issuer.OidcDefaultIssuerService;
import org.apereo.cas.oidc.issuer.OidcIssuerService;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyCacheKey;
import org.apereo.cas.oidc.jwks.OidcRegisteredServiceJsonWebKeystoreCacheLoader;
import org.apereo.cas.oidc.jwks.OidcServiceJsonWebKeystoreCacheExpirationPolicy;
import org.apereo.cas.oidc.profile.OidcProfileScopeToAttributesFilter;
import org.apereo.cas.oidc.profile.OidcUserProfileDataCreator;
import org.apereo.cas.oidc.profile.OidcUserProfileSigningAndEncryptionService;
import org.apereo.cas.oidc.profile.OidcUserProfileViewRenderer;
import org.apereo.cas.oidc.scopes.DefaultOidcAttributeReleasePolicyFactory;
import org.apereo.cas.oidc.scopes.OidcAttributeReleasePolicyFactory;
import org.apereo.cas.oidc.services.OidcServiceRegistryListener;
import org.apereo.cas.oidc.services.OidcServicesManagerRegisteredServiceLocator;
import org.apereo.cas.oidc.ticket.OidcDefaultPushedAuthorizationRequestFactory;
import org.apereo.cas.oidc.ticket.OidcPushedAuthorizationRequestExpirationPolicyBuilder;
import org.apereo.cas.oidc.ticket.OidcPushedAuthorizationRequestFactory;
import org.apereo.cas.oidc.token.OidcIdTokenSigningAndEncryptionService;
import org.apereo.cas.oidc.token.OidcJwtAccessTokenCipherExecutor;
import org.apereo.cas.oidc.token.OidcRegisteredServiceJwtAccessTokenCipherExecutor;
import org.apereo.cas.oidc.util.OidcRequestSupport;
import org.apereo.cas.oidc.web.OidcAuthenticationAuthorizeSecurityLogic;
import org.apereo.cas.oidc.web.OidcAuthorizationModelAndViewBuilder;
import org.apereo.cas.oidc.web.OidcCallbackAuthorizeViewResolver;
import org.apereo.cas.oidc.web.OidcCasClientRedirectActionBuilder;
import org.apereo.cas.oidc.web.OidcConsentApprovalViewResolver;
import org.apereo.cas.services.RegisteredServiceCipherExecutor;
import org.apereo.cas.services.ServiceRegistryListener;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.ServicesManagerRegisteredServiceLocator;
import org.apereo.cas.support.oauth.authenticator.OAuth20AuthenticationClientProvider;
import org.apereo.cas.support.oauth.authenticator.OAuth20CasAuthenticationBuilder;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.profile.OAuth20UserProfileDataCreator;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20AuthorizationRequestValidator;
import org.apereo.cas.support.oauth.validator.token.OAuth20TokenRequestValidator;
import org.apereo.cas.support.oauth.web.response.OAuth20CasClientRedirectActionBuilder;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20AccessTokenResponseGenerator;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationModelAndViewBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20InvalidAuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.views.ConsentApprovalViewResolver;
import org.apereo.cas.support.oauth.web.views.OAuth20CallbackAuthorizeViewResolver;
import org.apereo.cas.support.oauth.web.views.OAuth20UserProfileViewRenderer;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.IdTokenGeneratorService;
import org.apereo.cas.ticket.OAuth20TokenSigningAndEncryptionService;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TicketFactoryExecutionPlanConfigurer;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessTokenFactory;
import org.apereo.cas.ticket.accesstoken.OAuth20JwtBuilder;
import org.apereo.cas.ticket.code.OAuth20CodeFactory;
import org.apereo.cas.ticket.device.OAuth20DeviceTokenFactory;
import org.apereo.cas.ticket.device.OAuth20DeviceUserCodeFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.util.DefaultUniqueTicketIdGenerator;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.gen.DefaultRandomStringGenerator;
import org.apereo.cas.util.gen.RandomStringGenerator;
import org.apereo.cas.util.serialization.StringSerializer;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.jose4j.jwk.JsonWebKeySet;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.credentials.extractor.BearerAuthExtractor;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.engine.SecurityLogic;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.http.adapter.JEEHttpActionAdapter;
import org.pac4j.core.http.url.UrlResolver;
import org.pac4j.http.client.direct.DirectFormClient;
import org.pac4j.http.client.direct.HeaderClient;
import org.pac4j.springframework.web.SecurityInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.web.servlet.HandlerInterceptor;

@Configuration(value="OidcConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class OidcConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcConfiguration.class);

    @Configuration(value="OidcTicketFactoryPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class OidcTicketFactoryPlanConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"pushedAuthorizationUriExpirationPolicy"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ExpirationPolicyBuilder pushedAuthorizationUriExpirationPolicy(CasConfigurationProperties casProperties) {
            return new OidcPushedAuthorizationRequestExpirationPolicyBuilder(casProperties);
        }

        @ConditionalOnMissingBean(name={"pushedAuthorizationIdGenerator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public UniqueTicketIdGenerator pushedAuthorizationIdGenerator() {
            return new DefaultUniqueTicketIdGenerator();
        }

        @ConditionalOnMissingBean(name={"oidcPushedAuthorizationUriFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OidcPushedAuthorizationRequestFactory oidcPushedAuthorizationUriFactory(@Qualifier(value="pushedAuthorizationUriExpirationPolicy") ExpirationPolicyBuilder pushedAuthorizationUriExpirationPolicy, @Qualifier(value="pushedAuthorizationIdGenerator") UniqueTicketIdGenerator pushedAuthorizationIdGenerator) {
            return new OidcDefaultPushedAuthorizationRequestFactory(pushedAuthorizationIdGenerator, pushedAuthorizationUriExpirationPolicy);
        }

        @ConditionalOnMissingBean(name={"oidcPushedAuthorizationUriFactoryConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TicketFactoryExecutionPlanConfigurer oidcPushedAuthorizationUriFactoryConfigurer(@Qualifier(value="oidcPushedAuthorizationUriFactory") OidcPushedAuthorizationRequestFactory oidcPushedAuthorizationRequestFactory) {
            return () -> oidcPushedAuthorizationRequestFactory;
        }
    }

    @Configuration(value="OidcCoreConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @AutoConfigureOrder(value=-2147483648)
    public static class OidcCoreConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcWebFingerUserInfoRepository"})
        public OidcWebFingerUserInfoRepository oidcWebFingerUserInfoRepository(CasConfigurationProperties casProperties) {
            OidcWebFingerProperties.UserInfoRepository userInfo = casProperties.getAuthn().getOidc().getWebfinger().getUserInfo();
            if (userInfo.getGroovy().getLocation() != null) {
                return new OidcGroovyWebFingerUserInfoRepository(userInfo.getGroovy().getLocation());
            }
            if (StringUtils.isNotBlank((CharSequence)userInfo.getRest().getUrl())) {
                return new OidcRestfulWebFingerUserInfoRepository((RestEndpointProperties)userInfo.getRest());
            }
            LOGGER.info("Using [{}] to locate webfinger resources, which is NOT appropriate for production purposes, as it will always echo back the given username/email address and is only useful for testing/demo purposes. Consider choosing and configuring a different repository implementation for locating and fetching user information for webfinger resources, etc.", (Object)OidcEchoingWebFingerUserInfoRepository.class.getSimpleName());
            return new OidcEchoingWebFingerUserInfoRepository();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcCasCallbackUrlResolver"})
        public UrlResolver casCallbackUrlResolver(CasConfigurationProperties casProperties) {
            return new OidcCasCallbackUrlResolver(casProperties);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcIdTokenClaimCollector"})
        public OidcIdTokenClaimCollector oidcIdTokenClaimCollector() {
            return OidcIdTokenClaimCollector.defaultCollector();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcIssuerService"})
        public OidcIssuerService oidcIssuerService(CasConfigurationProperties casProperties) {
            return new OidcDefaultIssuerService(casProperties.getAuthn().getOidc());
        }

        @ConditionalOnMissingBean(name={"oidcPrincipalFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PrincipalFactory oidcPrincipalFactory() {
            return PrincipalFactoryUtils.newPrincipalFactory();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcAttributeToScopeClaimMapper"})
        public OidcAttributeToScopeClaimMapper oidcAttributeToScopeClaimMapper(CasConfigurationProperties casProperties) {
            Map mappings = casProperties.getAuthn().getOidc().getCore().getClaimsMap();
            return new OidcDefaultAttributeToScopeClaimMapper(mappings);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcAttributeReleasePolicyFactory"})
        public OidcAttributeReleasePolicyFactory oidcAttributeReleasePolicyFactory(CasConfigurationProperties casProperties) {
            return new DefaultOidcAttributeReleasePolicyFactory(casProperties);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcServicesManagerRegisteredServiceLocator"})
        public ServicesManagerRegisteredServiceLocator oidcServicesManagerRegisteredServiceLocator(CasConfigurationProperties casProperties) {
            return new OidcServicesManagerRegisteredServiceLocator(casProperties);
        }

        @ConditionalOnMissingBean(name={"clientRegistrationRequestSerializer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public StringSerializer<OidcClientRegistrationRequest> clientRegistrationRequestSerializer() {
            return new OidcClientRegistrationRequestSerializer();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20AuthorizationModelAndViewBuilder oauthAuthorizationModelAndViewBuilder(CasConfigurationProperties casProperties, @Qualifier(value="oidcIssuerService") OidcIssuerService oidcIssuerService) {
            return new OidcAuthorizationModelAndViewBuilder(oidcIssuerService, casProperties);
        }

        @Bean
        @ConditionalOnMissingBean(name={"oidcServerDiscoverySettingsFactory"})
        public FactoryBean<OidcServerDiscoverySettings> oidcServerDiscoverySettingsFactory(@Qualifier(value="oidcIssuerService") OidcIssuerService oidcIssuerService, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return new OidcServerDiscoverySettingsFactory(casProperties, oidcIssuerService, applicationContext);
        }
    }

    @Configuration(value="OidcContextConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class OidcContextConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"oidcConfigurationContext"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OidcConfigurationContext oidcConfigurationContext(@Qualifier(value="oidcIdTokenGenerator") IdTokenGeneratorService oidcIdTokenGenerator, @Qualifier(value="grantingTicketExpirationPolicy") ExpirationPolicyBuilder grantingTicketExpirationPolicy, @Qualifier(value="oidcUserProfileViewRenderer") OAuth20UserProfileViewRenderer oidcUserProfileViewRenderer, @Qualifier(value="oidcIdTokenClaimCollector") OidcIdTokenClaimCollector oidcIdTokenClaimCollector, @Qualifier(value="callbackAuthorizeViewResolver") OAuth20CallbackAuthorizeViewResolver callbackAuthorizeViewResolver, @Qualifier(value="oauthInvalidAuthorizationBuilder") OAuth20InvalidAuthorizationResponseBuilder oauthInvalidAuthorizationBuilder, @Qualifier(value="oidcUserProfileDataCreator") OAuth20UserProfileDataCreator oidcUserProfileDataCreator, @Qualifier(value="oidcTokenSigningAndEncryptionService") OAuth20TokenSigningAndEncryptionService oidcTokenSigningAndEncryptionService, @Qualifier(value="singleLogoutServiceLogoutUrlBuilder") SingleLogoutServiceLogoutUrlBuilder singleLogoutServiceLogoutUrlBuilder, @Qualifier(value="oauthTokenGenerator") OAuth20TokenGenerator oauthTokenGenerator, @Qualifier(value="oauthCasAuthenticationBuilder") OAuth20CasAuthenticationBuilder authenticationBuilder, @Qualifier(value="profileScopeToAttributesFilter") OAuth20ProfileScopeToAttributesFilter profileScopeToAttributesFilter, @Qualifier(value="oidcRequestSupport") OidcRequestSupport oidcRequestSupport, ObjectProvider<List<OAuth20AuthorizationRequestValidator>> oauthRequestValidators, @Qualifier(value="oauthRegisteredServiceCipherExecutor") CipherExecutor oauthRegisteredServiceCipherExecutor, @Qualifier(value="defaultDeviceTokenFactory") OAuth20DeviceTokenFactory defaultDeviceTokenFactory, @Qualifier(value="consentApprovalViewResolver") ConsentApprovalViewResolver consentApprovalViewResolver, @Qualifier(value="oidcAttributeToScopeClaimMapper") OidcAttributeToScopeClaimMapper oidcAttributeToScopeClaimMapper, @Qualifier(value="defaultAccessTokenFactory") OAuth20AccessTokenFactory defaultAccessTokenFactory, @Qualifier(value="defaultOAuthCodeFactory") OAuth20CodeFactory defaultOAuthCodeFactory, @Qualifier(value="accessTokenJwtBuilder") JwtBuilder accessTokenJwtBuilder, @Qualifier(value="deviceTokenExpirationPolicy") ExpirationPolicyBuilder deviceTokenExpirationPolicy, @Qualifier(value="oidcIssuerService") OidcIssuerService oidcIssuerService, @Qualifier(value="defaultDeviceUserCodeFactory") OAuth20DeviceUserCodeFactory defaultDeviceUserCodeFactory, ObjectProvider<List<OAuth20AuthorizationResponseBuilder>> oidcAuthorizationResponseBuilders, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, @Qualifier(value="oauthDistributedSessionCookieGenerator") CasCookieBuilder oauthDistributedSessionCookieGenerator, @Qualifier(value="oauthDistributedSessionStore") SessionStore oauthDistributedSessionStore, @Qualifier(value="clientRegistrationRequestSerializer") StringSerializer<OidcClientRegistrationRequest> clientRegistrationRequestSerializer, @Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, ObjectProvider<List<OAuth20TokenRequestValidator>> oauthTokenRequestValidators, @Qualifier(value="oauthSecConfig") Config oauthSecConfig, @Qualifier(value="oidcAccessTokenResponseGenerator") OAuth20AccessTokenResponseGenerator oidcAccessTokenResponseGenerator, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="defaultTicketFactory") TicketFactory ticketFactory, @Qualifier(value="oidcPrincipalFactory") PrincipalFactory oidcPrincipalFactory, CasConfigurationProperties casProperties, @Qualifier(value="oidcServerDiscoverySettingsFactory") OidcServerDiscoverySettings oidcServerDiscoverySettings, ConfigurableApplicationContext applicationContext, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer) throws Exception {
            return (OidcConfigurationContext)((OidcConfigurationContext.OidcConfigurationContextBuilder)((OidcConfigurationContext.OidcConfigurationContextBuilder)((OidcConfigurationContext.OidcConfigurationContextBuilder)OidcConfigurationContext.builder().discoverySettings(oidcServerDiscoverySettings).issuerService(oidcIssuerService).ticketFactory(ticketFactory)).idTokenClaimCollector(oidcIdTokenClaimCollector).idTokenGeneratorService(oidcIdTokenGenerator).idTokenExpirationPolicy(grantingTicketExpirationPolicy).oidcRequestSupport(oidcRequestSupport).attributeToScopeClaimMapper(oidcAttributeToScopeClaimMapper).applicationContext(applicationContext)).registeredServiceCipherExecutor(oauthRegisteredServiceCipherExecutor)).sessionStore(oauthDistributedSessionStore).servicesManager(servicesManager).ticketRegistry(ticketRegistry).clientRegistrationRequestSerializer(clientRegistrationRequestSerializer).clientIdGenerator((RandomStringGenerator)new DefaultRandomStringGenerator()).clientSecretGenerator((RandomStringGenerator)new DefaultRandomStringGenerator()).principalFactory(oidcPrincipalFactory).webApplicationServiceServiceFactory(webApplicationServiceFactory).casProperties(casProperties).ticketGrantingTicketCookieGenerator(ticketGrantingTicketCookieGenerator).oauthDistributedSessionCookieGenerator(oauthDistributedSessionCookieGenerator).oauthConfig(oauthSecConfig).registeredServiceAccessStrategyEnforcer(registeredServiceAccessStrategyEnforcer).centralAuthenticationService(centralAuthenticationService).callbackAuthorizeViewResolver(callbackAuthorizeViewResolver).profileScopeToAttributesFilter(profileScopeToAttributesFilter).accessTokenGenerator(oauthTokenGenerator).accessTokenResponseGenerator(oidcAccessTokenResponseGenerator).deviceTokenExpirationPolicy(deviceTokenExpirationPolicy).accessTokenGrantRequestValidators(oauthTokenRequestValidators).userProfileDataCreator(oidcUserProfileDataCreator).userProfileViewRenderer(oidcUserProfileViewRenderer).consentApprovalViewResolver(consentApprovalViewResolver).authenticationBuilder(authenticationBuilder).oauthAuthorizationResponseBuilders(oidcAuthorizationResponseBuilders).oauthInvalidAuthorizationResponseBuilder(oauthInvalidAuthorizationBuilder).oauthRequestValidators(oauthRequestValidators).singleLogoutServiceLogoutUrlBuilder(singleLogoutServiceLogoutUrlBuilder).idTokenSigningAndEncryptionService(oidcTokenSigningAndEncryptionService).accessTokenJwtBuilder(accessTokenJwtBuilder).build();
        }
    }

    @Configuration(value="OidcJwtConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class OidcJwtConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcAccessTokenJwtBuilder"})
        public JwtBuilder accessTokenJwtBuilder(@Qualifier(value="oidcAccessTokenJwtCipherExecutor") CipherExecutor<Serializable, String> oidcAccessTokenJwtCipherExecutor, @Qualifier(value="oidcRegisteredServiceJwtAccessTokenCipherExecutor") RegisteredServiceCipherExecutor oidcRegisteredServiceJwtAccessTokenCipherExecutor, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new OAuth20JwtBuilder(oidcAccessTokenJwtCipherExecutor, servicesManager, oidcRegisteredServiceJwtAccessTokenCipherExecutor);
        }
    }

    @Configuration(value="OidcClientConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class OidcClientConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20AuthenticationClientProvider oidcClientConfigurationAuthenticationClientProvider(@Qualifier(value="accessTokenJwtBuilder") JwtBuilder accessTokenJwtBuilder, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry) {
            return () -> {
                HeaderClient accessTokenClient = new HeaderClient();
                accessTokenClient.setCredentialsExtractor((CredentialsExtractor)new BearerAuthExtractor());
                accessTokenClient.setAuthenticator((Authenticator)new OidcClientConfigurationAccessTokenAuthenticator(ticketRegistry, accessTokenJwtBuilder));
                accessTokenClient.setName("ClientRegistrationClient");
                accessTokenClient.init();
                return accessTokenClient;
            };
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20AuthenticationClientProvider oidcPrivateKeyJwtClientProvider(@Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="servicesManager") ServicesManager servicesManager, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer) {
            return () -> {
                DirectFormClient privateKeyJwtClient = new DirectFormClient((Authenticator)new OidcPrivateKeyJwtAuthenticator(servicesManager, registeredServiceAccessStrategyEnforcer, ticketRegistry, webApplicationServiceFactory, casProperties, (ApplicationContext)applicationContext));
                privateKeyJwtClient.setName("ClientPrivateKeyJwtClient");
                privateKeyJwtClient.setUsernameParameter("client_assertion_type");
                privateKeyJwtClient.setPasswordParameter("client_assertion");
                privateKeyJwtClient.init();
                return privateKeyJwtClient;
            };
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20AuthenticationClientProvider oidcClientSecretJwtClientProvider(@Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="servicesManager") ServicesManager servicesManager, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer) {
            return () -> {
                DirectFormClient client = new DirectFormClient((Authenticator)new OidcClientSecretJwtAuthenticator(servicesManager, registeredServiceAccessStrategyEnforcer, ticketRegistry, webApplicationServiceFactory, casProperties, (ApplicationContext)applicationContext));
                client.setName("ClientSecretJwtClient");
                client.setUsernameParameter("client_assertion_type");
                client.setPasswordParameter("client_assertion");
                client.init();
                return client;
            };
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Authenticator oAuthAccessTokenAuthenticator(@Qualifier(value="oidcTokenSigningAndEncryptionService") OAuth20TokenSigningAndEncryptionService oidcTokenSigningAndEncryptionService, @Qualifier(value="accessTokenJwtBuilder") JwtBuilder accessTokenJwtBuilder, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="servicesManager") ServicesManager servicesManager) throws Exception {
            return new OidcAccessTokenAuthenticator(ticketRegistry, oidcTokenSigningAndEncryptionService, servicesManager, accessTokenJwtBuilder);
        }
    }

    @Configuration(value="OidcCryptoConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class OidcCryptoConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcRegisteredServiceJwtAccessTokenCipherExecutor"})
        public RegisteredServiceCipherExecutor oidcRegisteredServiceJwtAccessTokenCipherExecutor(@Qualifier(value="oidcServiceJsonWebKeystoreCache") LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> oidcServiceJsonWebKeystoreCache, @Qualifier(value="oidcIssuerService") OidcIssuerService oidcIssuerService, @Qualifier(value="oidcDefaultJsonWebKeystoreCache") LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> oidcDefaultJsonWebKeystoreCache) {
            return new OidcRegisteredServiceJwtAccessTokenCipherExecutor(oidcDefaultJsonWebKeystoreCache, oidcServiceJsonWebKeystoreCache, oidcIssuerService);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcAccessTokenJwtCipherExecutor"})
        public CipherExecutor<Serializable, String> oidcAccessTokenJwtCipherExecutor(@Qualifier(value="oidcIssuerService") OidcIssuerService oidcIssuerService, @Qualifier(value="oidcDefaultJsonWebKeystoreCache") LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> oidcDefaultJsonWebKeystoreCache) {
            return new OidcJwtAccessTokenCipherExecutor(oidcDefaultJsonWebKeystoreCache, oidcIssuerService);
        }
    }

    @Configuration(value="OidcTokenServiceConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class OidcTokenServiceConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcTokenSigningAndEncryptionService"})
        public OAuth20TokenSigningAndEncryptionService oidcTokenSigningAndEncryptionService(@Qualifier(value="oidcServerDiscoverySettingsFactory") FactoryBean<OidcServerDiscoverySettings> oidcServerDiscoverySettingsFactory, @Qualifier(value="oidcServiceJsonWebKeystoreCache") LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> oidcServiceJsonWebKeystoreCache, @Qualifier(value="oidcIssuerService") OidcIssuerService oidcIssuerService, @Qualifier(value="oidcDefaultJsonWebKeystoreCache") LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> oidcDefaultJsonWebKeystoreCache) throws Exception {
            return new OidcIdTokenSigningAndEncryptionService(oidcDefaultJsonWebKeystoreCache, oidcServiceJsonWebKeystoreCache, oidcIssuerService, (OidcServerDiscoverySettings)oidcServerDiscoverySettingsFactory.getObject());
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcUserProfileSigningAndEncryptionService"})
        public OAuth20TokenSigningAndEncryptionService oidcUserProfileSigningAndEncryptionService(@Qualifier(value="oidcServerDiscoverySettingsFactory") FactoryBean<OidcServerDiscoverySettings> oidcServerDiscoverySettingsFactory, @Qualifier(value="oidcServiceJsonWebKeystoreCache") LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> oidcServiceJsonWebKeystoreCache, @Qualifier(value="oidcIssuerService") OidcIssuerService oidcIssuerService, @Qualifier(value="oidcDefaultJsonWebKeystoreCache") LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> oidcDefaultJsonWebKeystoreCache) throws Exception {
            return new OidcUserProfileSigningAndEncryptionService(oidcDefaultJsonWebKeystoreCache, oidcServiceJsonWebKeystoreCache, oidcIssuerService, (OidcServerDiscoverySettings)oidcServerDiscoverySettingsFactory.getObject());
        }
    }

    @Configuration(value="OidcConsentConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class OidcConsentConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ConsentApprovalViewResolver consentApprovalViewResolver(@Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, @Qualifier(value="oauthDistributedSessionStore") SessionStore oauthDistributedSessionStore, CasConfigurationProperties casProperties) {
            return new OidcConsentApprovalViewResolver(casProperties, oauthDistributedSessionStore, centralAuthenticationService);
        }
    }

    @Configuration(value="OidcRedirectConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class OidcRedirectConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"oidcRequestSupport"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OidcRequestSupport oidcRequestSupport(CasConfigurationProperties casProperties, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="oidcIssuerService") OidcIssuerService oidcIssuerService, @Qualifier(value="defaultTicketRegistrySupport") TicketRegistrySupport ticketRegistrySupport) {
            return new OidcRequestSupport(ticketGrantingTicketCookieGenerator, ticketRegistrySupport, oidcIssuerService, casProperties);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20CallbackAuthorizeViewResolver callbackAuthorizeViewResolver(@Qualifier(value="oauthAuthorizationModelAndViewBuilder") OAuth20AuthorizationModelAndViewBuilder oauthAuthorizationModelAndViewBuilder, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new OidcCallbackAuthorizeViewResolver(servicesManager, oauthAuthorizationModelAndViewBuilder);
        }

        @Bean
        @ConditionalOnMissingBean(name={"oidcCasClientRedirectActionBuilder"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20CasClientRedirectActionBuilder oidcCasClientRedirectActionBuilder(@Qualifier(value="oidcRequestSupport") OidcRequestSupport oidcRequestSupport) {
            return new OidcCasClientRedirectActionBuilder(oidcRequestSupport);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20CasClientRedirectActionBuilder oauthCasClientRedirectActionBuilder(@Qualifier(value="oidcRequestSupport") OidcRequestSupport oidcRequestSupport) {
            return new OidcCasClientRedirectActionBuilder(oidcRequestSupport);
        }
    }

    @Configuration(value="OidcCacheConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class OidcCacheConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"oidcServiceJsonWebKeystoreCache"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> oidcServiceJsonWebKeystoreCache(@Qualifier(value="oidcServiceJsonWebKeystoreCacheLoader") CacheLoader<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> oidcServiceJsonWebKeystoreCacheLoader, CasConfigurationProperties casProperties) {
            return Caffeine.newBuilder().maximumSize(100L).expireAfter((Expiry)new OidcServiceJsonWebKeystoreCacheExpirationPolicy(casProperties)).build(oidcServiceJsonWebKeystoreCacheLoader);
        }

        @Bean
        @ConditionalOnMissingBean(name={"oidcServiceJsonWebKeystoreCacheLoader"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CacheLoader<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> oidcServiceJsonWebKeystoreCacheLoader(ConfigurableApplicationContext applicationContext) {
            return new OidcRegisteredServiceJsonWebKeystoreCacheLoader((ApplicationContext)applicationContext);
        }
    }

    @Configuration(value="OidcClaimsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class OidcClaimsConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20ProfileScopeToAttributesFilter profileScopeToAttributesFilter(@Qualifier(value="oidcPrincipalFactory") PrincipalFactory oidcPrincipalFactory, @Qualifier(value="oidcAttributeReleasePolicyFactory") OidcAttributeReleasePolicyFactory oidcAttributeReleasePolicyFactory, CasConfigurationProperties casProperties) {
            return new OidcProfileScopeToAttributesFilter(oidcPrincipalFactory, casProperties, oidcAttributeReleasePolicyFactory);
        }
    }

    @Configuration(value="OidcUserProfileConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class OidcUserProfileConfiguration {
        @ConditionalOnMissingBean(name={"oidcUserProfileViewRenderer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20UserProfileViewRenderer oidcUserProfileViewRenderer(@Qualifier(value="oidcUserProfileSigningAndEncryptionService") OAuth20TokenSigningAndEncryptionService oidcUserProfileSigningAndEncryptionService, @Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties, @Qualifier(value="oidcIssuerService") OidcIssuerService oidcIssuerService) throws Exception {
            return new OidcUserProfileViewRenderer(casProperties.getAuthn().getOauth(), servicesManager, oidcUserProfileSigningAndEncryptionService, oidcIssuerService);
        }

        @Bean
        @ConditionalOnMissingBean(name={"oidcUserProfileDataCreator"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20UserProfileDataCreator oidcUserProfileDataCreator(@Qualifier(value="profileScopeToAttributesFilter") OAuth20ProfileScopeToAttributesFilter profileScopeToAttributesFilter, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new OidcUserProfileDataCreator(servicesManager, profileScopeToAttributesFilter);
        }
    }

    @Configuration(value="OidcWebFingerConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class OidcWebFingerConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"oidcWebFingerDiscoveryService"})
        public OidcWebFingerDiscoveryService oidcWebFingerDiscoveryService(@Qualifier(value="oidcWebFingerUserInfoRepository") OidcWebFingerUserInfoRepository oidcWebFingerUserInfoRepository, @Qualifier(value="oidcServerDiscoverySettingsFactory") FactoryBean<OidcServerDiscoverySettings> oidcServerDiscoverySettingsFactory) throws Exception {
            return new OidcWebFingerDiscoveryService(oidcWebFingerUserInfoRepository, (OidcServerDiscoverySettings)oidcServerDiscoverySettingsFactory.getObject());
        }
    }

    @Configuration(value="OidcWebConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class OidcWebConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SecurityLogic oidcAuthorizationSecurityLogic(@Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService) {
            return new OidcAuthenticationAuthorizeSecurityLogic(ticketGrantingTicketCookieGenerator, ticketRegistry, centralAuthenticationService);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public HandlerInterceptor requiresAuthenticationAuthorizeInterceptor(@Qualifier(value="oidcAuthorizationSecurityLogic") SecurityLogic oidcAuthorizationSecurityLogic, @Qualifier(value="oauthSecConfig") Config oauthSecConfig) {
            SecurityInterceptor interceptor = new SecurityInterceptor(oauthSecConfig, "CasOAuthClient", (HttpActionAdapter)JEEHttpActionAdapter.INSTANCE);
            interceptor.setMatchers("securityheaders");
            interceptor.setAuthorizers("isFullyAuthenticated");
            interceptor.setSecurityLogic(oidcAuthorizationSecurityLogic);
            return interceptor;
        }
    }

    @Configuration(value="OidcServicesConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class OidcServicesConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"oidcServiceRegistryListener"})
        public ServiceRegistryListener oidcServiceRegistryListener(@Qualifier(value="oidcAttributeReleasePolicyFactory") OidcAttributeReleasePolicyFactory oidcAttributeReleasePolicyFactory) {
            return new OidcServiceRegistryListener(oidcAttributeReleasePolicyFactory);
        }
    }
}

