/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.config;

import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import lombok.Generated;
import org.apereo.cas.authentication.PseudoPlatformTransactionManager;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.jpa.JpaConfigurationContext;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.apereo.cas.configuration.support.JpaBeans;
import org.apereo.cas.jpa.JpaBeanFactory;
import org.apereo.cas.oidc.jwks.generator.OidcJsonWebKeystoreEntity;
import org.apereo.cas.oidc.jwks.generator.OidcJsonWebKeystoreGeneratorService;
import org.apereo.cas.oidc.jwks.generator.jpa.OidcJpaJsonWebKeystoreGeneratorService;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanContainer;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionOperations;
import org.springframework.transaction.support.TransactionTemplate;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnClass(value={JpaBeanFactory.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.OpenIDConnect, module="jpa")
@AutoConfiguration
public class OidcJwksJpaConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcJwksJpaConfiguration.class);
    private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.oidc.jwks.jpa.url");

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"transactionManagerOidcJwks"})
    public PlatformTransactionManager transactionManagerOidcJwks(ConfigurableApplicationContext applicationContext, @Qualifier(value="oidcJwksEntityManagerFactory") ObjectProvider<EntityManagerFactory> emf) {
        return (PlatformTransactionManager)BeanSupplier.of(PlatformTransactionManager.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).and(() -> Objects.nonNull(emf.getIfAvailable())).supply(() -> {
            JpaTransactionManager mgmr = new JpaTransactionManager();
            mgmr.setEntityManagerFactory((EntityManagerFactory)emf.getObject());
            return mgmr;
        }).otherwise(PseudoPlatformTransactionManager::new).get();
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"oidcJwksEntityManagerFactory"})
    public FactoryBean<EntityManagerFactory> oidcJwksEntityManagerFactory(ConfigurableApplicationContext applicationContext, @Qualifier(value="jpaOidcJwksVendorAdapter") JpaVendorAdapter jpaOidcJwksVendorAdapter, @Qualifier(value="dataSourceOidcJwks") DataSource dataSourceOidcJwks, @Qualifier(value="jpaOidcJwksPackagesToScan") BeanContainer<String> jpaOidcJwksPackagesToScan, @Qualifier(value="jpaBeanFactory") JpaBeanFactory jpaBeanFactory, CasConfigurationProperties casProperties) {
        return (FactoryBean)BeanSupplier.of(FactoryBean.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(Unchecked.supplier(() -> {
            JpaConfigurationContext ctx = JpaConfigurationContext.builder().jpaVendorAdapter(jpaOidcJwksVendorAdapter).persistenceUnitName("jpaOidcJwksContext").dataSource(dataSourceOidcJwks).packagesToScan(jpaOidcJwksPackagesToScan.toSet()).build();
            return jpaBeanFactory.newEntityManagerFactoryBean(ctx, (AbstractJpaProperties)casProperties.getAuthn().getOidc().getJwks().getJpa());
        })).otherwiseProxy().get();
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    @ConditionalOnMissingBean(name={"jpaOidcJwksVendorAdapter"})
    public JpaVendorAdapter jpaOidcJwksVendorAdapter(ConfigurableApplicationContext applicationContext, @Qualifier(value="jpaBeanFactory") JpaBeanFactory jpaBeanFactory, CasConfigurationProperties casProperties) {
        return (JpaVendorAdapter)BeanSupplier.of(JpaVendorAdapter.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> jpaBeanFactory.newJpaVendorAdapter(casProperties.getJdbc())).otherwiseProxy().get();
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public BeanContainer<String> jpaOidcJwksPackagesToScan(ConfigurableApplicationContext applicationContext) {
        return (BeanContainer)BeanSupplier.of(BeanContainer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> BeanContainer.of((Set)CollectionUtils.wrapSet((Object)OidcJsonWebKeystoreEntity.class.getPackage().getName()))).otherwise(BeanContainer::empty).get();
    }

    @Bean
    @ConditionalOnMissingBean(name={"dataSourceOidcJwks"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public DataSource dataSourceOidcJwks(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        return (DataSource)BeanSupplier.of(DataSource.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> JpaBeans.newDataSource((AbstractJpaProperties)casProperties.getAuthn().getOidc().getJwks().getJpa())).otherwiseProxy().get();
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public Supplier<OidcJsonWebKeystoreGeneratorService> jpaJsonWebKeystoreGeneratorService(ConfigurableApplicationContext applicationContext, @Qualifier(value="transactionManagerOidcJwks") PlatformTransactionManager transactionManagerOidcJwks, CasConfigurationProperties casProperties) {
        return (Supplier)BeanSupplier.of(Supplier.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            OidcProperties oidc = casProperties.getAuthn().getOidc();
            LOGGER.info("Managing JWKS via a relational database at [{}]", (Object)oidc.getJwks().getJpa().getUrl());
            TransactionTemplate transactionTemplate = new TransactionTemplate(transactionManagerOidcJwks);
            return () -> new OidcJpaJsonWebKeystoreGeneratorService(oidc, (TransactionOperations)transactionTemplate);
        }).otherwiseProxy().get();
    }
}

