/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.attribute.AttributeDefinitionStore;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.RestEndpointProperties;
import org.apereo.cas.configuration.model.core.util.EncryptionOptionalSigningOptionalJwkCryptographyProperties;
import org.apereo.cas.configuration.model.core.util.EncryptionOptionalSigningOptionalJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.oidc.OidcWebFingerProperties;
import org.apereo.cas.logout.slo.SingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.assurance.AssuranceVerificationJsonSource;
import org.apereo.cas.oidc.assurance.AssuranceVerificationSource;
import org.apereo.cas.oidc.assurance.AssuranceVerifiedClaimsProducer;
import org.apereo.cas.oidc.assurance.DefaultAssuranceVerifiedClaimsProducer;
import org.apereo.cas.oidc.authn.OidcAccessTokenAuthenticator;
import org.apereo.cas.oidc.authn.OidcCasCallbackUrlResolver;
import org.apereo.cas.oidc.authn.OidcClientConfigurationAccessTokenAuthenticator;
import org.apereo.cas.oidc.authn.OidcClientIdClientSecretAuthenticator;
import org.apereo.cas.oidc.authn.OidcDPoPAuthenticator;
import org.apereo.cas.oidc.authn.OidcJwtAuthenticator;
import org.apereo.cas.oidc.authn.OidcX509Authenticator;
import org.apereo.cas.oidc.claims.OidcAttributeToScopeClaimMapper;
import org.apereo.cas.oidc.claims.OidcDefaultAttributeToScopeClaimMapper;
import org.apereo.cas.oidc.claims.OidcIdTokenClaimCollector;
import org.apereo.cas.oidc.claims.OidcSimpleIdTokenClaimCollector;
import org.apereo.cas.oidc.discovery.OidcServerDiscoverySettings;
import org.apereo.cas.oidc.discovery.OidcServerDiscoverySettingsFactory;
import org.apereo.cas.oidc.discovery.webfinger.OidcDefaultWebFingerDiscoveryService;
import org.apereo.cas.oidc.discovery.webfinger.OidcWebFingerDiscoveryService;
import org.apereo.cas.oidc.discovery.webfinger.OidcWebFingerUserInfoRepository;
import org.apereo.cas.oidc.discovery.webfinger.userinfo.OidcEchoingWebFingerUserInfoRepository;
import org.apereo.cas.oidc.discovery.webfinger.userinfo.OidcGroovyWebFingerUserInfoRepository;
import org.apereo.cas.oidc.discovery.webfinger.userinfo.OidcRestfulWebFingerUserInfoRepository;
import org.apereo.cas.oidc.dynareg.OidcClientRegistrationRequest;
import org.apereo.cas.oidc.dynareg.OidcClientRegistrationRequestSerializer;
import org.apereo.cas.oidc.issuer.OidcDefaultIssuerService;
import org.apereo.cas.oidc.issuer.OidcIssuerService;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyCacheKey;
import org.apereo.cas.oidc.jwks.OidcRegisteredServiceJsonWebKeystoreCacheLoader;
import org.apereo.cas.oidc.jwks.OidcServiceJsonWebKeystoreCacheExpirationPolicy;
import org.apereo.cas.oidc.profile.OidcProfileScopeToAttributesFilter;
import org.apereo.cas.oidc.profile.OidcTokenIntrospectionSigningAndEncryptionService;
import org.apereo.cas.oidc.profile.OidcUserProfileDataCreator;
import org.apereo.cas.oidc.profile.OidcUserProfileSigningAndEncryptionService;
import org.apereo.cas.oidc.profile.OidcUserProfileViewRenderer;
import org.apereo.cas.oidc.scopes.DefaultOidcAttributeReleasePolicyFactory;
import org.apereo.cas.oidc.scopes.OidcAttributeReleasePolicyFactory;
import org.apereo.cas.oidc.services.OidcServiceRegistryListener;
import org.apereo.cas.oidc.services.OidcServicesManagerRegisteredServiceLocator;
import org.apereo.cas.oidc.ticket.OidcCibaRequestExpirationPolicyBuilder;
import org.apereo.cas.oidc.ticket.OidcCibaRequestFactory;
import org.apereo.cas.oidc.ticket.OidcDefaultCibaRequestFactory;
import org.apereo.cas.oidc.ticket.OidcDefaultPushedAuthorizationRequestFactory;
import org.apereo.cas.oidc.ticket.OidcPushedAuthorizationRequestExpirationPolicyBuilder;
import org.apereo.cas.oidc.ticket.OidcPushedAuthorizationRequestFactory;
import org.apereo.cas.oidc.token.OidcIdTokenSigningAndEncryptionService;
import org.apereo.cas.oidc.token.OidcJwtAccessTokenCipherExecutor;
import org.apereo.cas.oidc.token.OidcRegisteredServiceJwtAccessTokenCipherExecutor;
import org.apereo.cas.oidc.util.OidcRequestSupport;
import org.apereo.cas.oidc.web.OidcAuthenticationAuthorizeSecurityLogic;
import org.apereo.cas.oidc.web.OidcAuthorizationModelAndViewBuilder;
import org.apereo.cas.oidc.web.OidcCallbackAuthorizeViewResolver;
import org.apereo.cas.oidc.web.OidcCasClientRedirectActionBuilder;
import org.apereo.cas.oidc.web.OidcClientSecretValidator;
import org.apereo.cas.oidc.web.OidcConsentApprovalViewResolver;
import org.apereo.cas.oidc.web.controllers.dynareg.OidcClientRegistrationRequestTranslator;
import org.apereo.cas.oidc.web.controllers.dynareg.OidcDefaultClientRegistrationRequestTranslator;
import org.apereo.cas.oidc.web.response.OidcJwtResponseModeCipherExecutor;
import org.apereo.cas.oidc.web.response.OidcRegisteredServiceJwtResponseModeCipherExecutor;
import org.apereo.cas.oidc.web.response.OidcResponseModeFormPostJwtBuilder;
import org.apereo.cas.oidc.web.response.OidcResponseModeFragmentJwtBuilder;
import org.apereo.cas.oidc.web.response.OidcResponseModeQueryJwtBuilder;
import org.apereo.cas.services.RegisteredServiceCipherExecutor;
import org.apereo.cas.services.ServiceRegistryListener;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.ServicesManagerRegisteredServiceLocator;
import org.apereo.cas.support.oauth.authenticator.OAuth20AuthenticationClientProvider;
import org.apereo.cas.support.oauth.authenticator.OAuth20CasAuthenticationBuilder;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.profile.OAuth20UserProfileDataCreator;
import org.apereo.cas.support.oauth.validator.OAuth20ClientSecretValidator;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20AuthorizationRequestValidator;
import org.apereo.cas.support.oauth.validator.token.OAuth20TokenRequestValidator;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.support.oauth.web.response.OAuth20CasClientRedirectActionBuilder;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20AccessTokenResponseGenerator;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationModelAndViewBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20InvalidAuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20ResponseModeBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20ResponseModeFactory;
import org.apereo.cas.support.oauth.web.response.introspection.OAuth20IntrospectionResponseGenerator;
import org.apereo.cas.support.oauth.web.views.ConsentApprovalViewResolver;
import org.apereo.cas.support.oauth.web.views.OAuth20CallbackAuthorizeViewResolver;
import org.apereo.cas.support.oauth.web.views.OAuth20UserProfileViewRenderer;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.IdTokenGeneratorService;
import org.apereo.cas.ticket.OAuth20TokenSigningAndEncryptionService;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TicketFactoryExecutionPlanConfigurer;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.accesstoken.OAuth20JwtBuilder;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.util.DefaultUniqueTicketIdGenerator;
import org.apereo.cas.util.cipher.BaseStringCipherExecutor;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.gen.DefaultRandomStringGenerator;
import org.apereo.cas.util.gen.RandomStringGenerator;
import org.apereo.cas.util.nativex.CasRuntimeHintsRegistrar;
import org.apereo.cas.util.serialization.JacksonObjectMapperCustomizer;
import org.apereo.cas.util.serialization.StringSerializer;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.validation.AuthenticationAttributeReleasePolicy;
import org.apereo.cas.web.SecurityLogicInterceptor;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.jooq.lambda.Unchecked;
import org.jose4j.jwk.JsonWebKeySet;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.credentials.extractor.BearerAuthExtractor;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.engine.SecurityLogic;
import org.pac4j.core.http.url.UrlResolver;
import org.pac4j.http.client.direct.DirectFormClient;
import org.pac4j.http.client.direct.HeaderClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.io.Resource;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.web.servlet.HandlerInterceptor;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.OpenIDConnect})
@Configuration(value="OidcConfiguration", proxyBeanMethods=false)
class OidcConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcConfiguration.class);

    OidcConfiguration() {
    }

    @Configuration(value="OidcAssuranceConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class OidcAssuranceConfiguration {
        OidcAssuranceConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"assuranceVerificationSource"})
        public AssuranceVerificationSource assuranceVerificationSource(CasConfigurationProperties casProperties) {
            Resource source = casProperties.getAuthn().getOidc().getIdentityAssurance().getVerificationSource().getLocation();
            return (AssuranceVerificationSource)FunctionUtils.doIfNotNull((Object)source, () -> new AssuranceVerificationJsonSource(source), AssuranceVerificationSource::empty).get();
        }
    }

    @Configuration(value="OidcResponseModesConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class OidcResponseModesConfiguration {
        OidcResponseModesConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oauthQueryJwtResponseModeBuilder"})
        public OAuth20ResponseModeBuilder oauthQueryJwtResponseModeBuilder(@Qualifier(value="oidcConfigurationContext") ObjectProvider<OidcConfigurationContext> oidcConfigurationContext) {
            return new OidcResponseModeQueryJwtBuilder(oidcConfigurationContext);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oauthFragmentJwtResponseModeBuilder"})
        public OAuth20ResponseModeBuilder oauthFragmentJwtResponseModeBuilder(@Qualifier(value="oidcConfigurationContext") ObjectProvider<OidcConfigurationContext> oidcConfigurationContext) {
            return new OidcResponseModeFragmentJwtBuilder(oidcConfigurationContext);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oauthFormPostJwtResponseModeBuilder"})
        public OAuth20ResponseModeBuilder oauthFormPostJwtResponseModeBuilder(@Qualifier(value="oidcConfigurationContext") ObjectProvider<OidcConfigurationContext> oidcConfigurationContext) {
            return new OidcResponseModeFormPostJwtBuilder(oidcConfigurationContext);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcResponseModeJwtCipherExecutor"})
        public CipherExecutor<Serializable, String> oidcResponseModeJwtCipherExecutor(CasConfigurationProperties casProperties, @Qualifier(value="oidcIssuerService") OidcIssuerService oidcIssuerService, @Qualifier(value="oidcDefaultJsonWebKeystoreCache") LoadingCache<OidcJsonWebKeyCacheKey, JsonWebKeySet> oidcDefaultJsonWebKeystoreCache) {
            EncryptionOptionalSigningOptionalJwkCryptographyProperties crypto = casProperties.getAuthn().getOidc().getResponse().getCrypto();
            return (CipherExecutor)FunctionUtils.doIf((boolean)crypto.isEnabled(), () -> {
                OidcJwtResponseModeCipherExecutor cipher = new OidcJwtResponseModeCipherExecutor(oidcDefaultJsonWebKeystoreCache, oidcIssuerService);
                cipher.setStrategyType(BaseStringCipherExecutor.CipherOperationsStrategyType.valueOf((String)crypto.getStrategyType()));
                cipher.setSigningEnabled(crypto.isSigningEnabled());
                cipher.setEncryptionEnabled(crypto.isEncryptionEnabled());
                return cipher;
            }, CipherExecutor::noOpOfSerializableToString).get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcRegisteredServiceResponseModeJwtCipherExecutor"})
        public RegisteredServiceCipherExecutor oidcRegisteredServiceResponseModeJwtCipherExecutor(CasConfigurationProperties casProperties, @Qualifier(value="oidcServiceJsonWebKeystoreCache") LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> oidcServiceJsonWebKeystoreCache, @Qualifier(value="oidcIssuerService") OidcIssuerService oidcIssuerService, @Qualifier(value="oidcDefaultJsonWebKeystoreCache") LoadingCache<OidcJsonWebKeyCacheKey, JsonWebKeySet> oidcDefaultJsonWebKeystoreCache) {
            EncryptionOptionalSigningOptionalJwkCryptographyProperties crypto = casProperties.getAuthn().getOidc().getResponse().getCrypto();
            return (RegisteredServiceCipherExecutor)FunctionUtils.doIf((boolean)crypto.isEnabled(), () -> new OidcRegisteredServiceJwtResponseModeCipherExecutor(oidcDefaultJsonWebKeystoreCache, oidcServiceJsonWebKeystoreCache, oidcIssuerService), RegisteredServiceCipherExecutor::noOp).get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcResponseModeJwtBuilder"})
        public JwtBuilder oidcResponseModeJwtBuilder(ConfigurableApplicationContext applicationContext, @Qualifier(value="oidcRegisteredServiceResponseModeJwtCipherExecutor") RegisteredServiceCipherExecutor oidcRegisteredServiceResponseModeJwtCipherExecutor, CasConfigurationProperties casProperties, @Qualifier(value="oidcResponseModeJwtCipherExecutor") CipherExecutor<Serializable, String> oidcResponseModeJwtCipherExecutor, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="defaultPrincipalResolver") PrincipalResolver principalResolver) {
            return new OAuth20JwtBuilder(oidcResponseModeJwtCipherExecutor, applicationContext, servicesManager, oidcRegisteredServiceResponseModeJwtCipherExecutor, casProperties, principalResolver);
        }
    }

    @Configuration(value="OidcTicketFactoryPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class OidcTicketFactoryPlanConfiguration {
        OidcTicketFactoryPlanConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"pushedAuthorizationUriExpirationPolicy"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ExpirationPolicyBuilder pushedAuthorizationUriExpirationPolicy(CasConfigurationProperties casProperties) {
            return new OidcPushedAuthorizationRequestExpirationPolicyBuilder(casProperties);
        }

        @ConditionalOnMissingBean(name={"pushedAuthorizationIdGenerator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public UniqueTicketIdGenerator pushedAuthorizationIdGenerator() {
            return new DefaultUniqueTicketIdGenerator();
        }

        @ConditionalOnMissingBean(name={"oidcPushedAuthorizationUriFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OidcPushedAuthorizationRequestFactory oidcPushedAuthorizationUriFactory(@Qualifier(value="pushedAuthorizationUriExpirationPolicy") ExpirationPolicyBuilder pushedAuthorizationUriExpirationPolicy, @Qualifier(value="pushedAuthorizationIdGenerator") UniqueTicketIdGenerator pushedAuthorizationIdGenerator) {
            return new OidcDefaultPushedAuthorizationRequestFactory(pushedAuthorizationIdGenerator, pushedAuthorizationUriExpirationPolicy);
        }

        @ConditionalOnMissingBean(name={"oidcPushedAuthorizationUriFactoryConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TicketFactoryExecutionPlanConfigurer oidcPushedAuthorizationUriFactoryConfigurer(@Qualifier(value="oidcPushedAuthorizationUriFactory") OidcPushedAuthorizationRequestFactory oidcPushedAuthorizationRequestFactory) {
            return () -> oidcPushedAuthorizationRequestFactory;
        }

        @Bean
        @ConditionalOnMissingBean(name={"cibaRequestExpirationPolicy"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ExpirationPolicyBuilder cibaRequestExpirationPolicy(CasConfigurationProperties casProperties) {
            return new OidcCibaRequestExpirationPolicyBuilder(casProperties);
        }

        @ConditionalOnMissingBean(name={"oidcCibaRequestFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OidcCibaRequestFactory oidcCibaRequestFactory(@Qualifier(value="cibaRequestExpirationPolicy") ExpirationPolicyBuilder cibaRequestExpirationPolicy, @Qualifier(value="cibaRequestIdGenerator") UniqueTicketIdGenerator cibaRequestIdGenerator) {
            return new OidcDefaultCibaRequestFactory(cibaRequestIdGenerator, cibaRequestExpirationPolicy);
        }

        @ConditionalOnMissingBean(name={"cibaRequestIdGenerator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public UniqueTicketIdGenerator cibaRequestIdGenerator() {
            return new DefaultUniqueTicketIdGenerator();
        }

        @ConditionalOnMissingBean(name={"oidcCibaRequestFactoryConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TicketFactoryExecutionPlanConfigurer oidcCibaRequestFactoryConfigurer(@Qualifier(value="oidcCibaRequestFactory") OidcCibaRequestFactory oidcCibaRequestFactory) {
            return () -> oidcCibaRequestFactory;
        }
    }

    @Configuration(value="OidcCoreConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @AutoConfigureOrder(value=-2147483648)
    static class OidcCoreConfiguration {
        OidcCoreConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcCasCallbackUrlResolver"})
        public UrlResolver casCallbackUrlResolver(@Qualifier(value="oauthRequestParameterResolver") OAuth20RequestParameterResolver oauthRequestParameterResolver, CasConfigurationProperties casProperties) {
            return new OidcCasCallbackUrlResolver(casProperties, oauthRequestParameterResolver);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"assuranceVerifiedClaimsProducer"})
        public AssuranceVerifiedClaimsProducer assuranceVerifiedClaimsProducer(@Qualifier(value="oidcServerDiscoverySettingsFactory") OidcServerDiscoverySettings oidcServerDiscoverySettings, @Qualifier(value="assuranceVerificationSource") AssuranceVerificationSource assuranceVerificationSource) {
            return new DefaultAssuranceVerifiedClaimsProducer(assuranceVerificationSource, oidcServerDiscoverySettings);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcIdTokenClaimCollector"})
        public OidcIdTokenClaimCollector oidcIdTokenClaimCollector(@Qualifier(value="assuranceVerifiedClaimsProducer") AssuranceVerifiedClaimsProducer assuranceVerifiedClaimsProducer, @Qualifier(value="attributeDefinitionStore") AttributeDefinitionStore attributeDefinitionStore) {
            return new OidcSimpleIdTokenClaimCollector(attributeDefinitionStore, assuranceVerifiedClaimsProducer);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcIssuerService"})
        public OidcIssuerService oidcIssuerService(CasConfigurationProperties casProperties) {
            return new OidcDefaultIssuerService(casProperties.getAuthn().getOidc());
        }

        @ConditionalOnMissingBean(name={"oidcPrincipalFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PrincipalFactory oidcPrincipalFactory() {
            return PrincipalFactoryUtils.newPrincipalFactory();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcAttributeToScopeClaimMapper"})
        public OidcAttributeToScopeClaimMapper oidcAttributeToScopeClaimMapper(CasConfigurationProperties casProperties) {
            Map mappings = casProperties.getAuthn().getOidc().getCore().getClaimsMap();
            return new OidcDefaultAttributeToScopeClaimMapper(mappings);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcAttributeReleasePolicyFactory"})
        public OidcAttributeReleasePolicyFactory oidcAttributeReleasePolicyFactory(CasConfigurationProperties casProperties) {
            return new DefaultOidcAttributeReleasePolicyFactory(casProperties);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcServicesManagerRegisteredServiceLocator"})
        public ServicesManagerRegisteredServiceLocator oidcServicesManagerRegisteredServiceLocator(CasConfigurationProperties casProperties) {
            return new OidcServicesManagerRegisteredServiceLocator(casProperties);
        }

        @ConditionalOnMissingBean(name={"clientRegistrationRequestSerializer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public StringSerializer<OidcClientRegistrationRequest> clientRegistrationRequestSerializer() {
            return new OidcClientRegistrationRequestSerializer();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcClientRegistrationRequestTranslator"})
        public OidcClientRegistrationRequestTranslator oidcClientRegistrationRequestTranslator(@Qualifier(value="oidcConfigurationContext") ObjectProvider<OidcConfigurationContext> oidcConfigurationContext) {
            return new OidcDefaultClientRegistrationRequestTranslator(oidcConfigurationContext);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20AuthorizationModelAndViewBuilder oauthAuthorizationModelAndViewBuilder(@Qualifier(value="oauthResponseModeFactory") OAuth20ResponseModeFactory oauthResponseModeFactory, CasConfigurationProperties casProperties, @Qualifier(value="oidcIssuerService") OidcIssuerService oidcIssuerService) {
            return new OidcAuthorizationModelAndViewBuilder(oauthResponseModeFactory, oidcIssuerService, casProperties);
        }

        @Bean
        @ConditionalOnMissingBean(name={"oidcServerDiscoverySettingsFactory"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public FactoryBean<OidcServerDiscoverySettings> oidcServerDiscoverySettingsFactory(@Qualifier(value="oidcIssuerService") OidcIssuerService oidcIssuerService, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return new OidcServerDiscoverySettingsFactory(casProperties, oidcIssuerService, applicationContext);
        }

        @ConditionalOnMissingBean(name={"oidcClientAuthenticator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Authenticator oauthClientAuthenticator(@Qualifier(value="oidcServerDiscoverySettingsFactory") OidcServerDiscoverySettings oidcServerDiscoverySettings, ConfigurableApplicationContext applicationContext, @Qualifier(value="defaultTicketFactory") TicketFactory ticketFactory, @Qualifier(value="profileScopeToAttributesFilter") OAuth20ProfileScopeToAttributesFilter profileScopeToAttributesFilter, @Qualifier(value="oauthRequestParameterResolver") OAuth20RequestParameterResolver oauthRequestParameterResolver, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer, @Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="defaultPrincipalResolver") PrincipalResolver defaultPrincipalResolver, @Qualifier(value="oauth20ClientSecretValidator") OAuth20ClientSecretValidator oauth20ClientSecretValidator) {
            return new OidcClientIdClientSecretAuthenticator(servicesManager, webApplicationServiceFactory, registeredServiceAccessStrategyEnforcer, ticketRegistry, defaultPrincipalResolver, oauthRequestParameterResolver, oauth20ClientSecretValidator, profileScopeToAttributesFilter, ticketFactory, applicationContext, oidcServerDiscoverySettings);
        }

        @ConditionalOnMissingBean(name={"oidcX509CertificateAuthenticator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Authenticator oauthX509CertificateAuthenticator(@Qualifier(value="oidcServerDiscoverySettingsFactory") OidcServerDiscoverySettings oidcServerDiscoverySettings, @Qualifier(value="oauthRequestParameterResolver") OAuth20RequestParameterResolver oauthRequestParameterResolver, @Qualifier(value="defaultAuthenticationSystemSupport") AuthenticationSystemSupport authenticationSystemSupport, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new OidcX509Authenticator(servicesManager, oauthRequestParameterResolver, oidcServerDiscoverySettings);
        }
    }

    @Configuration(value="OidcContextConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class OidcContextConfiguration {
        OidcContextConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"oidcConfigurationContext"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OidcConfigurationContext oidcConfigurationContext(@Qualifier(value="attributeDefinitionStore") AttributeDefinitionStore attributeDefinitionStore, @Qualifier(value="oidcTokenIntrospectionSigningAndEncryptionService") OAuth20TokenSigningAndEncryptionService oidcTokenIntrospectionSigningAndEncryptionService, @Qualifier(value="oidcClientRegistrationRequestTranslator") OidcClientRegistrationRequestTranslator oidcClientRegistrationRequestTranslator, @Qualifier(value="oidcResponseModeJwtBuilder") JwtBuilder oidcResponseModeJwtBuilder, @Qualifier(value="oauth20ClientSecretValidator") OAuth20ClientSecretValidator oauth20ClientSecretValidator, @Qualifier(value="oidcIdTokenGenerator") IdTokenGeneratorService oidcIdTokenGenerator, @Qualifier(value="oidcIdTokenExpirationPolicy") ExpirationPolicyBuilder oidcIdTokenExpirationPolicy, @Qualifier(value="oidcUserProfileViewRenderer") OAuth20UserProfileViewRenderer oidcUserProfileViewRenderer, List<OidcIdTokenClaimCollector> oidcIdTokenClaimCollectors, @Qualifier(value="callbackAuthorizeViewResolver") OAuth20CallbackAuthorizeViewResolver callbackAuthorizeViewResolver, @Qualifier(value="oauthInvalidAuthorizationBuilder") OAuth20InvalidAuthorizationResponseBuilder oauthInvalidAuthorizationBuilder, @Qualifier(value="oidcUserProfileDataCreator") OAuth20UserProfileDataCreator oidcUserProfileDataCreator, @Qualifier(value="oidcTokenSigningAndEncryptionService") OAuth20TokenSigningAndEncryptionService oidcTokenSigningAndEncryptionService, @Qualifier(value="singleLogoutServiceLogoutUrlBuilder") SingleLogoutServiceLogoutUrlBuilder singleLogoutServiceLogoutUrlBuilder, @Qualifier(value="oauthTokenGenerator") OAuth20TokenGenerator oauthTokenGenerator, @Qualifier(value="oauthCasAuthenticationBuilder") OAuth20CasAuthenticationBuilder authenticationBuilder, @Qualifier(value="profileScopeToAttributesFilter") OAuth20ProfileScopeToAttributesFilter profileScopeToAttributesFilter, @Qualifier(value="oidcRequestSupport") OidcRequestSupport oidcRequestSupport, ObjectProvider<List<OAuth20AuthorizationRequestValidator>> oauthRequestValidators, @Qualifier(value="oauthRegisteredServiceCipherExecutor") CipherExecutor oauthRegisteredServiceCipherExecutor, @Qualifier(value="consentApprovalViewResolver") ConsentApprovalViewResolver consentApprovalViewResolver, @Qualifier(value="oidcAttributeToScopeClaimMapper") OidcAttributeToScopeClaimMapper oidcAttributeToScopeClaimMapper, @Qualifier(value="accessTokenJwtBuilder") JwtBuilder accessTokenJwtBuilder, @Qualifier(value="deviceTokenExpirationPolicy") ExpirationPolicyBuilder deviceTokenExpirationPolicy, @Qualifier(value="oidcIssuerService") OidcIssuerService oidcIssuerService, ObjectProvider<List<OAuth20AuthorizationResponseBuilder>> oidcAuthorizationResponseBuilders, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, @Qualifier(value="oauthDistributedSessionCookieGenerator") CasCookieBuilder oauthDistributedSessionCookieGenerator, @Qualifier(value="oauthDistributedSessionStore") SessionStore oauthDistributedSessionStore, @Qualifier(value="clientRegistrationRequestSerializer") StringSerializer<OidcClientRegistrationRequest> clientRegistrationRequestSerializer, @Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, ObjectProvider<List<OAuth20TokenRequestValidator>> oauthTokenRequestValidators, @Qualifier(value="oauthSecConfig") Config oauthSecConfig, @Qualifier(value="oidcAccessTokenResponseGenerator") OAuth20AccessTokenResponseGenerator oidcAccessTokenResponseGenerator, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="defaultTicketFactory") TicketFactory ticketFactory, @Qualifier(value="oidcPrincipalFactory") PrincipalFactory oidcPrincipalFactory, CasConfigurationProperties casProperties, @Qualifier(value="oidcServerDiscoverySettingsFactory") OidcServerDiscoverySettings oidcServerDiscoverySettings, @Qualifier(value="oauthRequestParameterResolver") OAuth20RequestParameterResolver oauthRequestParameterResolver, ConfigurableApplicationContext applicationContext, @Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor, @Qualifier(value="authenticationAttributeReleasePolicy") AuthenticationAttributeReleasePolicy authenticationAttributeReleasePolicy, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer, List<OAuth20IntrospectionResponseGenerator> oauthIntrospectionResponseGenerator, @Qualifier(value="defaultPrincipalResolver") PrincipalResolver principalResolver, @Qualifier(value="taskScheduler") TaskScheduler taskScheduler, @Qualifier(value="communicationsManager") CommunicationsManager communicationManager, @Qualifier(value="webflowCipherExecutor") CipherExecutor webflowCipherExecutor) {
            ArrayList<OidcIdTokenClaimCollector> sortedIdClaimCollectors = new ArrayList<OidcIdTokenClaimCollector>(oidcIdTokenClaimCollectors);
            AnnotationAwareOrderComparator.sortIfNecessary(sortedIdClaimCollectors);
            return (OidcConfigurationContext)((OidcConfigurationContext.OidcConfigurationContextBuilder)((OidcConfigurationContext.OidcConfigurationContextBuilder)((OidcConfigurationContext.OidcConfigurationContextBuilder)((OidcConfigurationContext.OidcConfigurationContextBuilder)((OidcConfigurationContext.OidcConfigurationContextBuilder)((OidcConfigurationContext.OidcConfigurationContextBuilder)((OidcConfigurationContext.OidcConfigurationContextBuilder)OidcConfigurationContext.builder().introspectionSigningAndEncryptionService(oidcTokenIntrospectionSigningAndEncryptionService).introspectionResponseGenerator(oauthIntrospectionResponseGenerator)).argumentExtractor(argumentExtractor)).responseModeJwtBuilder(oidcResponseModeJwtBuilder).authenticationAttributeReleasePolicy(authenticationAttributeReleasePolicy)).discoverySettings(oidcServerDiscoverySettings).requestParameterResolver(oauthRequestParameterResolver)).issuerService(oidcIssuerService).clientRegistrationRequestTranslator(oidcClientRegistrationRequestTranslator).ticketFactory(ticketFactory)).idTokenClaimCollectors(sortedIdClaimCollectors).idTokenGeneratorService(oidcIdTokenGenerator).idTokenExpirationPolicy(oidcIdTokenExpirationPolicy).oidcRequestSupport(oidcRequestSupport).attributeToScopeClaimMapper(oidcAttributeToScopeClaimMapper).applicationContext(applicationContext)).registeredServiceCipherExecutor(oauthRegisteredServiceCipherExecutor)).sessionStore(oauthDistributedSessionStore).servicesManager(servicesManager).ticketRegistry(ticketRegistry).clientRegistrationRequestSerializer(clientRegistrationRequestSerializer).clientIdGenerator((RandomStringGenerator)new DefaultRandomStringGenerator()).clientSecretGenerator((RandomStringGenerator)new DefaultRandomStringGenerator()).principalFactory(oidcPrincipalFactory).webApplicationServiceServiceFactory(webApplicationServiceFactory).casProperties(casProperties).ticketGrantingTicketCookieGenerator(ticketGrantingTicketCookieGenerator).oauthDistributedSessionCookieGenerator(oauthDistributedSessionCookieGenerator).oauthConfig(oauthSecConfig).registeredServiceAccessStrategyEnforcer(registeredServiceAccessStrategyEnforcer).centralAuthenticationService(centralAuthenticationService).callbackAuthorizeViewResolver(callbackAuthorizeViewResolver).profileScopeToAttributesFilter(profileScopeToAttributesFilter).accessTokenGenerator(oauthTokenGenerator).accessTokenResponseGenerator(oidcAccessTokenResponseGenerator).deviceTokenExpirationPolicy(deviceTokenExpirationPolicy).accessTokenGrantRequestValidators(oauthTokenRequestValidators).userProfileDataCreator(oidcUserProfileDataCreator).userProfileViewRenderer(oidcUserProfileViewRenderer).consentApprovalViewResolver(consentApprovalViewResolver).authenticationBuilder(authenticationBuilder).oauthAuthorizationResponseBuilders(oidcAuthorizationResponseBuilders).oauthInvalidAuthorizationResponseBuilder(oauthInvalidAuthorizationBuilder).oauthRequestValidators(oauthRequestValidators).singleLogoutServiceLogoutUrlBuilder(singleLogoutServiceLogoutUrlBuilder).idTokenSigningAndEncryptionService(oidcTokenSigningAndEncryptionService).accessTokenJwtBuilder(accessTokenJwtBuilder).clientSecretValidator(oauth20ClientSecretValidator).attributeDefinitionStore(attributeDefinitionStore).principalResolver(principalResolver).taskScheduler(taskScheduler).communicationsManager(communicationManager).webflowCipherExecutor(webflowCipherExecutor).build();
        }
    }

    @Configuration(value="OidcJwtConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class OidcJwtConfiguration {
        OidcJwtConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcAccessTokenJwtBuilder"})
        public JwtBuilder accessTokenJwtBuilder(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="oidcAccessTokenJwtCipherExecutor") CipherExecutor<Serializable, String> oidcAccessTokenJwtCipherExecutor, @Qualifier(value="oidcRegisteredServiceJwtAccessTokenCipherExecutor") RegisteredServiceCipherExecutor oidcRegisteredServiceJwtAccessTokenCipherExecutor, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="defaultPrincipalResolver") PrincipalResolver principalResolver) {
            return new OAuth20JwtBuilder(oidcAccessTokenJwtCipherExecutor, applicationContext, servicesManager, oidcRegisteredServiceJwtAccessTokenCipherExecutor, casProperties, principalResolver);
        }
    }

    @Configuration(value="OidcClientConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class OidcClientConfiguration {
        OidcClientConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20AuthenticationClientProvider oidcClientConfigurationAuthenticationClientProvider(@Qualifier(value="accessTokenJwtBuilder") JwtBuilder accessTokenJwtBuilder, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry) {
            return () -> {
                HeaderClient accessTokenClient = new HeaderClient();
                accessTokenClient.setCredentialsExtractor((CredentialsExtractor)new BearerAuthExtractor());
                accessTokenClient.setAuthenticator((Authenticator)new OidcClientConfigurationAccessTokenAuthenticator(ticketRegistry, accessTokenJwtBuilder));
                accessTokenClient.setName("ClientRegistrationClient");
                accessTokenClient.init();
                return accessTokenClient;
            };
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20AuthenticationClientProvider oidcDynamicRegistrationAuthenticationClientProvider(@Qualifier(value="oidcDynamicRegistrationAuthenticator") Authenticator oidcDynamicRegistrationAuthenticator) {
            return () -> {
                HeaderClient registrationClient = new HeaderClient();
                registrationClient.setCredentialsExtractor((CredentialsExtractor)new BearerAuthExtractor());
                registrationClient.setAuthenticator(oidcDynamicRegistrationAuthenticator);
                registrationClient.setName("clientDynamicRegistrationAuth");
                registrationClient.init();
                return registrationClient;
            };
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcDPoPClientProvider"})
        public OAuth20AuthenticationClientProvider oidcDPoPClientProvider(CasConfigurationProperties casProperties, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer, @Qualifier(value="oidcServerDiscoverySettingsFactory") OidcServerDiscoverySettings oidcServerDiscoverySettings) {
            return () -> {
                HeaderClient client = new HeaderClient("DPoP", (Authenticator)new OidcDPoPAuthenticator(oidcServerDiscoverySettings, servicesManager, registeredServiceAccessStrategyEnforcer, casProperties));
                client.setName("proofOfPossessionAuth");
                client.init();
                return client;
            };
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcJwtClientProvider"})
        public OAuth20AuthenticationClientProvider oidcJwtClientProvider(@Qualifier(value="oidcIssuerService") OidcIssuerService oidcIssuerService, @Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="servicesManager") ServicesManager servicesManager, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer, @Qualifier(value="oidcServerDiscoverySettingsFactory") OidcServerDiscoverySettings oidcServerDiscoverySettings) {
            return () -> {
                OidcJwtAuthenticator authenticator = new OidcJwtAuthenticator(oidcIssuerService, servicesManager, registeredServiceAccessStrategyEnforcer, ticketRegistry, webApplicationServiceFactory, casProperties, (ApplicationContext)applicationContext, oidcServerDiscoverySettings);
                DirectFormClient privateKeyJwtClient = new DirectFormClient((Authenticator)authenticator);
                privateKeyJwtClient.setName("ClientPrivateKeyJwtClient");
                privateKeyJwtClient.setUsernameParameter("client_assertion_type");
                privateKeyJwtClient.setPasswordParameter("client_assertion");
                privateKeyJwtClient.init();
                return privateKeyJwtClient;
            };
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oauthAccessTokenAuthenticator"})
        public Authenticator oauthAccessTokenAuthenticator(@Qualifier(value="oidcTokenSigningAndEncryptionService") OAuth20TokenSigningAndEncryptionService oidcTokenSigningAndEncryptionService, @Qualifier(value="accessTokenJwtBuilder") JwtBuilder accessTokenJwtBuilder, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="servicesManager") ServicesManager servicesManager) throws Exception {
            return new OidcAccessTokenAuthenticator(ticketRegistry, oidcTokenSigningAndEncryptionService, servicesManager, accessTokenJwtBuilder);
        }

        @ConditionalOnMissingBean(name={"oidcDynamicRegistrationAuthenticator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Authenticator oidcDynamicRegistrationAuthenticator(@Qualifier(value="oidcTokenSigningAndEncryptionService") OAuth20TokenSigningAndEncryptionService oidcTokenSigningAndEncryptionService, @Qualifier(value="accessTokenJwtBuilder") JwtBuilder accessTokenJwtBuilder, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="servicesManager") ServicesManager servicesManager) throws Exception {
            OidcAccessTokenAuthenticator authenticator = new OidcAccessTokenAuthenticator(ticketRegistry, oidcTokenSigningAndEncryptionService, servicesManager, accessTokenJwtBuilder);
            authenticator.setRequiredScopes(Set.of("client_registration_scope"));
            return authenticator;
        }
    }

    @Configuration(value="OidcCryptoConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class OidcCryptoConfiguration {
        OidcCryptoConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcRegisteredServiceJwtAccessTokenCipherExecutor"})
        public RegisteredServiceCipherExecutor oidcRegisteredServiceJwtAccessTokenCipherExecutor(@Qualifier(value="oidcServiceJsonWebKeystoreCache") LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> oidcServiceJsonWebKeystoreCache, @Qualifier(value="oidcIssuerService") OidcIssuerService oidcIssuerService, @Qualifier(value="oidcDefaultJsonWebKeystoreCache") LoadingCache<OidcJsonWebKeyCacheKey, JsonWebKeySet> oidcDefaultJsonWebKeystoreCache) {
            return new OidcRegisteredServiceJwtAccessTokenCipherExecutor(oidcDefaultJsonWebKeystoreCache, oidcServiceJsonWebKeystoreCache, oidcIssuerService);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcAccessTokenJwtCipherExecutor"})
        public CipherExecutor<Serializable, String> oidcAccessTokenJwtCipherExecutor(CasConfigurationProperties casProperties, @Qualifier(value="oidcIssuerService") OidcIssuerService oidcIssuerService, @Qualifier(value="oidcDefaultJsonWebKeystoreCache") LoadingCache<OidcJsonWebKeyCacheKey, JsonWebKeySet> oidcDefaultJsonWebKeystoreCache) {
            EncryptionOptionalSigningOptionalJwtCryptographyProperties crypto = casProperties.getAuthn().getOauth().getAccessToken().getCrypto();
            return (CipherExecutor)FunctionUtils.doIf((boolean)crypto.isEnabled(), () -> {
                OidcJwtAccessTokenCipherExecutor cipher = new OidcJwtAccessTokenCipherExecutor(oidcDefaultJsonWebKeystoreCache, oidcIssuerService);
                cipher.setStrategyType(BaseStringCipherExecutor.CipherOperationsStrategyType.valueOf((String)crypto.getStrategyType()));
                cipher.setSigningEnabled(crypto.isSigningEnabled());
                cipher.setEncryptionEnabled(crypto.isEncryptionEnabled());
                return cipher;
            }, CipherExecutor::noOpOfSerializableToString).get();
        }
    }

    @Configuration(value="OidcTokenServiceConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class OidcTokenServiceConfiguration {
        OidcTokenServiceConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcTokenSigningAndEncryptionService"})
        public OAuth20TokenSigningAndEncryptionService oidcTokenSigningAndEncryptionService(CasConfigurationProperties casProperties, @Qualifier(value="oidcServerDiscoverySettingsFactory") FactoryBean<OidcServerDiscoverySettings> oidcServerDiscoverySettingsFactory, @Qualifier(value="oidcServiceJsonWebKeystoreCache") LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> oidcServiceJsonWebKeystoreCache, @Qualifier(value="oidcIssuerService") OidcIssuerService oidcIssuerService, @Qualifier(value="oidcDefaultJsonWebKeystoreCache") LoadingCache<OidcJsonWebKeyCacheKey, JsonWebKeySet> oidcDefaultJsonWebKeystoreCache) throws Exception {
            return new OidcIdTokenSigningAndEncryptionService(oidcDefaultJsonWebKeystoreCache, oidcServiceJsonWebKeystoreCache, oidcIssuerService, (OidcServerDiscoverySettings)oidcServerDiscoverySettingsFactory.getObject(), casProperties);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcUserProfileSigningAndEncryptionService"})
        public OAuth20TokenSigningAndEncryptionService oidcUserProfileSigningAndEncryptionService(CasConfigurationProperties casProperties, @Qualifier(value="oidcServerDiscoverySettingsFactory") FactoryBean<OidcServerDiscoverySettings> oidcServerDiscoverySettingsFactory, @Qualifier(value="oidcServiceJsonWebKeystoreCache") LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> oidcServiceJsonWebKeystoreCache, @Qualifier(value="oidcIssuerService") OidcIssuerService oidcIssuerService, @Qualifier(value="oidcDefaultJsonWebKeystoreCache") LoadingCache<OidcJsonWebKeyCacheKey, JsonWebKeySet> oidcDefaultJsonWebKeystoreCache) throws Exception {
            return new OidcUserProfileSigningAndEncryptionService(oidcDefaultJsonWebKeystoreCache, oidcServiceJsonWebKeystoreCache, oidcIssuerService, (OidcServerDiscoverySettings)oidcServerDiscoverySettingsFactory.getObject(), casProperties);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcTokenIntrospectionSigningAndEncryptionService"})
        public OAuth20TokenSigningAndEncryptionService oidcTokenIntrospectionSigningAndEncryptionService(CasConfigurationProperties casProperties, @Qualifier(value="oidcServerDiscoverySettingsFactory") FactoryBean<OidcServerDiscoverySettings> oidcServerDiscoverySettingsFactory, @Qualifier(value="oidcServiceJsonWebKeystoreCache") LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> oidcServiceJsonWebKeystoreCache, @Qualifier(value="oidcIssuerService") OidcIssuerService oidcIssuerService, @Qualifier(value="oidcDefaultJsonWebKeystoreCache") LoadingCache<OidcJsonWebKeyCacheKey, JsonWebKeySet> oidcDefaultJsonWebKeystoreCache) throws Exception {
            return new OidcTokenIntrospectionSigningAndEncryptionService(oidcDefaultJsonWebKeystoreCache, oidcServiceJsonWebKeystoreCache, oidcIssuerService, (OidcServerDiscoverySettings)oidcServerDiscoverySettingsFactory.getObject(), casProperties);
        }
    }

    @Configuration(value="OidcConsentConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class OidcConsentConfiguration {
        OidcConsentConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ConsentApprovalViewResolver consentApprovalViewResolver(@Qualifier(value="oauthRequestParameterResolver") OAuth20RequestParameterResolver oauthRequestParameterResolver, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="defaultTicketFactory") TicketFactory ticketFactory, @Qualifier(value="oauthDistributedSessionStore") SessionStore oauthDistributedSessionStore, CasConfigurationProperties casProperties) {
            return new OidcConsentApprovalViewResolver(casProperties, oauthDistributedSessionStore, ticketRegistry, ticketFactory, oauthRequestParameterResolver);
        }
    }

    @Configuration(value="OidcRedirectConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class OidcRedirectConfiguration {
        OidcRedirectConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"oidcRequestSupport"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OidcRequestSupport oidcRequestSupport(@Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="defaultTicketRegistrySupport") TicketRegistrySupport ticketRegistrySupport) {
            return new OidcRequestSupport(ticketGrantingTicketCookieGenerator, ticketRegistrySupport);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20CallbackAuthorizeViewResolver callbackAuthorizeViewResolver(@Qualifier(value="oauthRequestParameterResolver") OAuth20RequestParameterResolver oauthRequestParameterResolver, @Qualifier(value="oauthAuthorizationModelAndViewBuilder") OAuth20AuthorizationModelAndViewBuilder oauthAuthorizationModelAndViewBuilder, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new OidcCallbackAuthorizeViewResolver(servicesManager, oauthAuthorizationModelAndViewBuilder, oauthRequestParameterResolver);
        }

        @Bean
        @ConditionalOnMissingBean(name={"oidcCasClientRedirectActionBuilder"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20CasClientRedirectActionBuilder oidcCasClientRedirectActionBuilder(@Qualifier(value="oauthRequestParameterResolver") OAuth20RequestParameterResolver oauthRequestParameterResolver, @Qualifier(value="oidcRequestSupport") OidcRequestSupport oidcRequestSupport) {
            return new OidcCasClientRedirectActionBuilder(oidcRequestSupport, oauthRequestParameterResolver);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20CasClientRedirectActionBuilder oauthCasClientRedirectActionBuilder(@Qualifier(value="oauthRequestParameterResolver") OAuth20RequestParameterResolver oauthRequestParameterResolver, @Qualifier(value="oidcRequestSupport") OidcRequestSupport oidcRequestSupport) {
            return new OidcCasClientRedirectActionBuilder(oidcRequestSupport, oauthRequestParameterResolver);
        }
    }

    @Configuration(value="OidcCacheConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class OidcCacheConfiguration {
        OidcCacheConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"oidcServiceJsonWebKeystoreCache"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> oidcServiceJsonWebKeystoreCache(@Qualifier(value="oidcServiceJsonWebKeystoreCacheLoader") CacheLoader<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> oidcServiceJsonWebKeystoreCacheLoader, CasConfigurationProperties casProperties) {
            return Caffeine.newBuilder().maximumSize(100L).expireAfter((Expiry)new OidcServiceJsonWebKeystoreCacheExpirationPolicy(casProperties)).build(oidcServiceJsonWebKeystoreCacheLoader);
        }

        @Bean
        @ConditionalOnMissingBean(name={"oidcServiceJsonWebKeystoreCacheLoader"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CacheLoader<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> oidcServiceJsonWebKeystoreCacheLoader(ConfigurableApplicationContext applicationContext) {
            return new OidcRegisteredServiceJsonWebKeystoreCacheLoader((ApplicationContext)applicationContext);
        }
    }

    @Configuration(value="OidcClaimsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class OidcClaimsConfiguration {
        OidcClaimsConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20ProfileScopeToAttributesFilter profileScopeToAttributesFilter(ConfigurableApplicationContext applicationContext, @Qualifier(value="oidcPrincipalFactory") PrincipalFactory oidcPrincipalFactory, @Qualifier(value="oidcAttributeReleasePolicyFactory") OidcAttributeReleasePolicyFactory oidcAttributeReleasePolicyFactory, CasConfigurationProperties casProperties) {
            return new OidcProfileScopeToAttributesFilter(oidcPrincipalFactory, casProperties, oidcAttributeReleasePolicyFactory, applicationContext);
        }
    }

    @Configuration(value="OidcUserProfileConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class OidcUserProfileConfiguration {
        OidcUserProfileConfiguration() {
        }

        @ConditionalOnMissingBean(name={"oidcUserProfileViewRenderer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20UserProfileViewRenderer oidcUserProfileViewRenderer(@Qualifier(value="attributeDefinitionStore") AttributeDefinitionStore attributeDefinitionStore, @Qualifier(value="oidcUserProfileSigningAndEncryptionService") OAuth20TokenSigningAndEncryptionService oidcUserProfileSigningAndEncryptionService, @Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties) throws Exception {
            return new OidcUserProfileViewRenderer(casProperties.getAuthn().getOauth(), servicesManager, oidcUserProfileSigningAndEncryptionService, attributeDefinitionStore);
        }

        @Bean
        @ConditionalOnMissingBean(name={"oidcUserProfileDataCreator"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20UserProfileDataCreator oidcUserProfileDataCreator(@Qualifier(value="oidcConfigurationContext") ObjectProvider<OidcConfigurationContext> oidcConfigurationContext) {
            return new OidcUserProfileDataCreator(oidcConfigurationContext);
        }
    }

    @Configuration(value="OidcWebFingerConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class OidcWebFingerConfiguration {
        private static final BeanCondition CONDITION_WEBFINGER = BeanCondition.on((String)"cas.authn.oidc.web-finger.enabled").isTrue().evenIfMissing();

        OidcWebFingerConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcWebFingerUserInfoRepository"})
        public OidcWebFingerUserInfoRepository oidcWebFingerUserInfoRepository(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (OidcWebFingerUserInfoRepository)BeanSupplier.of(OidcWebFingerUserInfoRepository.class).when(CONDITION_WEBFINGER.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                OidcWebFingerProperties.UserInfoRepository userInfo = casProperties.getAuthn().getOidc().getWebfinger().getUserInfo();
                if (userInfo.getGroovy().getLocation() != null && CasRuntimeHintsRegistrar.notInNativeImage()) {
                    return new OidcGroovyWebFingerUserInfoRepository(userInfo.getGroovy().getLocation());
                }
                if (StringUtils.isNotBlank((CharSequence)userInfo.getRest().getUrl())) {
                    return new OidcRestfulWebFingerUserInfoRepository((RestEndpointProperties)userInfo.getRest());
                }
                LOGGER.info("Using [{}] to locate webfinger resources, which is NOT appropriate for production purposes, as it will always echo back the given username/email address and is only useful for testing/demo purposes. Consider choosing and configuring a different repository implementation for locating and fetching user information for webfinger resources, etc.", (Object)OidcEchoingWebFingerUserInfoRepository.class.getSimpleName());
                return new OidcEchoingWebFingerUserInfoRepository();
            }).otherwiseProxy().get();
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"oidcWebFingerDiscoveryService"})
        public OidcWebFingerDiscoveryService oidcWebFingerDiscoveryService(ConfigurableApplicationContext applicationContext, @Qualifier(value="oidcWebFingerUserInfoRepository") OidcWebFingerUserInfoRepository oidcWebFingerUserInfoRepository, @Qualifier(value="oidcServerDiscoverySettingsFactory") FactoryBean<OidcServerDiscoverySettings> oidcServerDiscoverySettingsFactory) {
            return (OidcWebFingerDiscoveryService)BeanSupplier.of(OidcWebFingerDiscoveryService.class).when(CONDITION_WEBFINGER.given((PropertyResolver)applicationContext.getEnvironment())).supply(Unchecked.supplier(() -> new OidcDefaultWebFingerDiscoveryService(oidcWebFingerUserInfoRepository, (OidcServerDiscoverySettings)oidcServerDiscoverySettingsFactory.getObject()))).otherwiseProxy().get();
        }
    }

    @Configuration(value="OidcWebConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class OidcWebConfiguration {
        OidcWebConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20ClientSecretValidator oauth20ClientSecretValidator(@Qualifier(value="oauthRegisteredServiceCipherExecutor") CipherExecutor oauthRegisteredServiceCipherExecutor) {
            return new OidcClientSecretValidator(oauthRegisteredServiceCipherExecutor);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcAuthorizationSecurityLogic"})
        public SecurityLogic oidcAuthorizationSecurityLogic(@Qualifier(value="oauthRequestParameterResolver") OAuth20RequestParameterResolver oauthRequestParameterResolver, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry) {
            return new OidcAuthenticationAuthorizeSecurityLogic(ticketGrantingTicketCookieGenerator, ticketRegistry, oauthRequestParameterResolver);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public HandlerInterceptor requiresAuthenticationAuthorizeInterceptor(@Qualifier(value="oidcAuthorizationSecurityLogic") SecurityLogic oidcAuthorizationSecurityLogic, @Qualifier(value="oauthSecConfig") Config oauthSecConfig) {
            Config authzConfig = oauthSecConfig.withSecurityLogic(oidcAuthorizationSecurityLogic);
            return new SecurityLogicInterceptor(authzConfig, "CasOAuthClient");
        }
    }

    @Configuration(value="OidcServicesConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class OidcServicesConfiguration {
        OidcServicesConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcRegisteredServiceSerializationCustomizer"})
        public JacksonObjectMapperCustomizer oidcRegisteredServiceSerializationCustomizer(CasConfigurationProperties casProperties) {
            return JacksonObjectMapperCustomizer.mappedInjectableValues((Map)casProperties.getAuthn().getOidc().getServices().getDefaults());
        }

        @Bean
        @ConditionalOnMissingBean(name={"oidcServiceRegistryListener"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Lazy(value=false)
        public ServiceRegistryListener oidcServiceRegistryListener(@Qualifier(value="oidcAttributeReleasePolicyFactory") OidcAttributeReleasePolicyFactory oidcAttributeReleasePolicyFactory) {
            return new OidcServiceRegistryListener(oidcAttributeReleasePolicyFactory);
        }
    }
}

