/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.openid.authentication.principal;

import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.authentication.principal.AbstractServiceFactory;
import org.apereo.cas.support.openid.authentication.principal.OpenIdService;
import org.springframework.util.StringUtils;

public class OpenIdServiceFactory
extends AbstractServiceFactory<OpenIdService> {
    private final String openIdPrefixUrl;

    public OpenIdService createService(HttpServletRequest request) {
        String service = request.getParameter("openid.return_to");
        String openIdIdentity = request.getParameter("openid.identity");
        if (openIdIdentity == null || !StringUtils.hasText((String)service)) {
            return null;
        }
        String id = OpenIdServiceFactory.cleanupUrl((String)service);
        String artifactId = request.getParameter("openid.assoc_handle");
        OpenIdService s = new OpenIdService(id, service, artifactId, openIdIdentity);
        s.setLoggedOutAlready(true);
        s.setSource("openid.return_to");
        return s;
    }

    public OpenIdService createService(String id) {
        return new OpenIdService(id, id, null, this.openIdPrefixUrl);
    }

    @Generated
    public OpenIdServiceFactory(String openIdPrefixUrl) {
        this.openIdPrefixUrl = openIdPrefixUrl;
    }

    @Generated
    public OpenIdServiceFactory() {
        this.openIdPrefixUrl = null;
    }
}

