/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.otp.repository.credentials;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.otp.repository.credentials.BaseOneTimeTokenCredentialRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseInMemoryOneTimeTokenCredentialRepository
extends BaseOneTimeTokenCredentialRepository {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseInMemoryOneTimeTokenCredentialRepository.class);
    private final Map<String, OneTimeTokenAccount> accounts = new ConcurrentHashMap<String, OneTimeTokenAccount>();

    public BaseInMemoryOneTimeTokenCredentialRepository(CipherExecutor<String, String> tokenCredentialCipher) {
        super(tokenCredentialCipher);
    }

    @Override
    public OneTimeTokenAccount get(String userName) {
        if (this.contains(userName)) {
            OneTimeTokenAccount account = this.accounts.get(userName);
            return this.decode(account);
        }
        return null;
    }

    @Override
    public void save(String userName, String secretKey, int validationCode, List<Integer> scratchCodes) {
        OneTimeTokenAccount account = new OneTimeTokenAccount(userName, secretKey, validationCode, scratchCodes);
        this.update(account);
    }

    @Override
    public OneTimeTokenAccount update(OneTimeTokenAccount account) {
        OneTimeTokenAccount encoded = this.encode(account);
        this.accounts.put(account.getUsername(), encoded);
        return encoded;
    }

    private boolean contains(String username) {
        return this.accounts.containsKey(username);
    }

    @Override
    public void deleteAll() {
        this.accounts.clear();
    }
}

