/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.otp.repository.credentials;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.otp.repository.credentials.BaseOneTimeTokenCredentialRepository;
import org.apereo.cas.util.serialization.AbstractJacksonBackedStringSerializer;
import org.apereo.cas.util.serialization.StringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public abstract class BaseJsonOneTimeTokenCredentialRepository
extends BaseOneTimeTokenCredentialRepository {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseJsonOneTimeTokenCredentialRepository.class);
    private final Resource location;
    private final StringSerializer<TreeSet<OneTimeTokenAccount>> serializer = new OneTimeAccountSerializer();

    public BaseJsonOneTimeTokenCredentialRepository(Resource location, CipherExecutor<String, String> tokenCredentialCipher) {
        super(tokenCredentialCipher);
        this.location = location;
    }

    @Override
    public OneTimeTokenAccount get(String username) {
        try {
            if (!this.location.getFile().exists()) {
                LOGGER.warn("JSON account repository file [{}] is not found.", (Object)this.location.getFile());
                return null;
            }
            if (this.location.getFile().length() <= 0L) {
                LOGGER.warn("JSON account repository file [{}] is empty.", (Object)this.location.getFile());
                return null;
            }
            Collection c = (Collection)this.serializer.from(this.location.getFile());
            OneTimeTokenAccount account = c.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getUsername()) && a.getUsername().equals(username)).findAny().orElse(null);
            if (account != null) {
                return this.decode(account);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public void save(String userName, String secretKey, int validationCode, List<Integer> scratchCodes) {
        try {
            LOGGER.debug("Storing google authenticator account for [{}]", (Object)userName);
            OneTimeTokenAccount account = new OneTimeTokenAccount(userName, secretKey, validationCode, scratchCodes);
            this.update(account);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public OneTimeTokenAccount update(OneTimeTokenAccount account) {
        try {
            TreeSet<OneTimeTokenAccount> accounts = this.readAccountsFromJsonRepository();
            LOGGER.debug("Found [{}] account(s) and added google authenticator account for [{}]", (Object)accounts.size(), (Object)account.getUsername());
            OneTimeTokenAccount encoded = this.encode(account);
            accounts.add(encoded);
            this.writeAccountsToJsonRepository(accounts);
            return encoded;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public void deleteAll() {
        this.writeAccountsToJsonRepository(new TreeSet<OneTimeTokenAccount>());
    }

    private void writeAccountsToJsonRepository(TreeSet<OneTimeTokenAccount> accounts) {
        LOGGER.debug("Saving google authenticator accounts back to the JSON file at [{}]", (Object)this.location.getFile());
        this.serializer.to(this.location.getFile(), accounts);
    }

    private TreeSet<OneTimeTokenAccount> readAccountsFromJsonRepository() throws IOException {
        TreeSet accounts;
        LOGGER.debug("Ensuring JSON repository file exists at [{}]", (Object)this.location.getFile());
        boolean result = this.location.getFile().createNewFile();
        if (result) {
            LOGGER.debug("Created JSON repository file at [{}]", (Object)this.location.getFile());
        }
        if (this.location.getFile().length() > 0L) {
            LOGGER.debug("Reading JSON repository file at [{}]", (Object)this.location.getFile());
            accounts = (TreeSet)this.serializer.from(this.location.getFile());
        } else {
            accounts = new TreeSet();
        }
        return accounts;
    }

    private static class OneTimeAccountSerializer
    extends AbstractJacksonBackedStringSerializer<TreeSet<OneTimeTokenAccount>> {
        private static final long serialVersionUID = 1466569521275630254L;

        private OneTimeAccountSerializer() {
        }

        protected Class getTypeToSerialize() {
            return TreeSet.class;
        }
    }
}

