/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.otp.repository.token;

import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Collection;
import lombok.Generated;
import org.apereo.cas.authentication.OneTimeToken;
import org.apereo.cas.otp.repository.token.BaseOneTimeTokenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingOneTimeTokenRepository
extends BaseOneTimeTokenRepository {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CachingOneTimeTokenRepository.class);
    private final LoadingCache<String, Collection<OneTimeToken>> storage;

    @Override
    public void cleanInternal() {
        LOGGER.debug("Beginning to clean up the cache storage to remove expiring tokens");
        this.storage.cleanUp();
        LOGGER.debug("Estimated total of [{}] token(s) remain in the cache and may be removed in future iterations", (Object)this.storage.estimatedSize());
    }

    @Override
    public void store(OneTimeToken token) {
        if (this.exists(token.getUserId(), token.getToken())) {
            try {
                Collection tokens = (Collection)this.storage.get((Object)token.getUserId());
                tokens.add(token);
                LOGGER.debug("Storing previously used tokens [{}] for user [{}]", (Object)tokens, (Object)token.getUserId());
                this.storage.put((Object)token.getUserId(), (Object)tokens);
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        } else {
            ArrayList<OneTimeToken> tokens = new ArrayList<OneTimeToken>();
            tokens.add(token);
            LOGGER.debug("Storing previously used token [{}] for user [{}]", (Object)token, (Object)token.getUserId());
            this.storage.put((Object)token.getUserId(), tokens);
        }
    }

    @Override
    public OneTimeToken get(String uid, Integer otp) {
        try {
            Collection tokens = (Collection)this.storage.getIfPresent((Object)uid);
            LOGGER.debug("Found used tokens [{}]", (Object)tokens);
            if (tokens != null) {
                return tokens.stream().filter(t -> t.getToken().equals(otp)).findFirst().orElse(null);
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Generated
    public CachingOneTimeTokenRepository(LoadingCache<String, Collection<OneTimeToken>> storage) {
        this.storage = storage;
    }
}

