/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.otp.web.flow;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialRepository;
import org.apereo.cas.util.QRUtils;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class OneTimeTokenAccountCheckRegistrationAction
extends AbstractAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OneTimeTokenAccountCheckRegistrationAction.class);
    private final OneTimeTokenCredentialRepository repository;
    private final String label;
    private final String issuer;

    protected Event doExecute(RequestContext requestContext) {
        String uid = WebUtils.getAuthentication((RequestContext)requestContext).getPrincipal().getId();
        OneTimeTokenAccount acct = this.repository.get(uid);
        if (acct == null || StringUtils.isBlank((CharSequence)acct.getSecretKey())) {
            OneTimeTokenAccount keyAccount = this.repository.create(uid);
            String keyUri = "otpauth://totp/" + this.label + ':' + uid + "?secret=" + keyAccount.getSecretKey() + "&issuer=" + this.issuer;
            requestContext.getFlowScope().put("key", (Object)keyAccount);
            String qrCodeBase64 = QRUtils.generateQRCode((String)keyUri, (int)250, (int)250);
            requestContext.getFlowScope().put("QRcode", (Object)qrCodeBase64);
            LOGGER.debug("Registration key URI is [{}]", (Object)keyUri);
            return new EventFactorySupport().event((Object)this, "register");
        }
        return this.success();
    }

    @Generated
    public OneTimeTokenAccountCheckRegistrationAction(OneTimeTokenCredentialRepository repository, String label, String issuer) {
        this.repository = repository;
        this.label = label;
        this.issuer = issuer;
    }
}

