/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pac4j;

import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpSession;
import lombok.Generated;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.serialization.SerializationUtils;
import org.apereo.cas.web.DefaultBrowserSessionStorage;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.JEESessionStore;
import org.pac4j.core.context.session.SessionStore;

public class BrowserWebStorageSessionStore
extends JEESessionStore {
    private final CipherExecutor webflowCipherExecutor;

    public Optional<Object> getTrackableSession(WebContext context) {
        Optional currentSession = super.getTrackableSession(context);
        LinkedHashMap attributes = new LinkedHashMap();
        currentSession.map(HttpSession.class::cast).map(session -> {
            Enumeration names = session.getAttributeNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                Object value = session.getAttribute(name);
                if (value == null) continue;
                attributes.put(name, value);
            }
            return attributes;
        });
        byte[] encoded = SerializationUtils.serializeAndEncodeObject((CipherExecutor)this.webflowCipherExecutor, attributes);
        String trackableSession = new String(encoded, StandardCharsets.UTF_8);
        return Optional.of(DefaultBrowserSessionStorage.builder().payload(trackableSession).build());
    }

    public Optional<SessionStore> buildFromTrackableSession(WebContext context, Object trackableSession) {
        byte[] encoded = trackableSession.toString().getBytes(StandardCharsets.UTF_8);
        Map attributes = (Map)((Object)SerializationUtils.decodeAndDeserializeObject((byte[])encoded, (CipherExecutor)this.webflowCipherExecutor, LinkedHashMap.class));
        attributes.forEach((key, value) -> this.set(context, (String)key, value));
        return Optional.of(this);
    }

    @Generated
    public BrowserWebStorageSessionStore(CipherExecutor webflowCipherExecutor) {
        this.webflowCipherExecutor = webflowCipherExecutor;
    }
}

