/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.integration.pac4j.authentication.handler.support;

import java.security.GeneralSecurityException;
import java.util.Optional;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import lombok.NonNull;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.principal.ClientCredential;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.integration.pac4j.authentication.handler.support.AbstractPac4jAuthenticationHandler;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.HttpRequestUtils;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.JEESessionStore;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.creator.AuthenticatorProfileCreator;
import org.pac4j.core.profile.creator.ProfileCreator;
import org.pac4j.core.util.InitializableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWrapperAuthenticationHandler<I extends Credential, C extends Credentials>
extends AbstractPac4jAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractWrapperAuthenticationHandler.class);
    @NonNull
    protected ProfileCreator<C> profileCreator = AuthenticatorProfileCreator.INSTANCE;

    public AbstractWrapperAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, Integer order) {
        super(name, servicesManager, principalFactory, order);
    }

    protected static WebContext getWebContext() {
        return new JEEContext(HttpRequestUtils.getHttpServletRequestFromRequestAttributes(), HttpRequestUtils.getHttpServletResponseFromRequestAttributes(), (SessionStore)new JEESessionStore());
    }

    public boolean supports(Credential credential) {
        return credential != null && this.getCasCredentialsType().isAssignableFrom(credential.getClass());
    }

    protected AuthenticationHandlerExecutionResult doAuthentication(Credential credential) throws GeneralSecurityException {
        C credentials = this.convertToPac4jCredentials(credential);
        LOGGER.trace("Credentials converted to [{}]", credentials);
        try {
            Authenticator<C> authenticator = this.getAuthenticator(credential);
            if (authenticator instanceof InitializableObject) {
                LOGGER.trace("Initializing authenticator [{}]", authenticator);
                ((InitializableObject)authenticator).init();
            }
            WebContext webContext = AbstractWrapperAuthenticationHandler.getWebContext();
            LOGGER.trace("Validating credentials [{}] using authenticator [{}]", credentials, authenticator);
            authenticator.validate(credentials, webContext);
            LOGGER.trace("Creating user profile result for [{}]", credentials);
            Optional profileResult = this.profileCreator.create(credentials, webContext);
            if (profileResult.isEmpty()) {
                throw new FailedLoginException("Unable to create common profile instance for credential " + credential);
            }
            CommonProfile profile = (CommonProfile)CommonProfile.class.cast(profileResult.get());
            LOGGER.debug("Authenticated profile: [{}]", (Object)profile);
            ClientCredential clientCredential = new ClientCredential(credentials, authenticator.getClass().getSimpleName());
            return this.createResult(clientCredential, profile, null);
        }
        catch (Exception e) {
            LOGGER.error("Failed to validate credentials", (Throwable)e);
            throw new FailedLoginException("Failed to validate credentials: " + e.getMessage());
        }
    }

    protected abstract C convertToPac4jCredentials(I var1) throws GeneralSecurityException;

    protected abstract Class<I> getCasCredentialsType();

    protected abstract Authenticator<C> getAuthenticator(Credential var1);

    @Generated
    public void setProfileCreator(@NonNull ProfileCreator<C> profileCreator) {
        if (profileCreator == null) {
            throw new NullPointerException("profileCreator is marked non-null but is null");
        }
        this.profileCreator = profileCreator;
    }
}

