/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.integration.pac4j.authentication.handler.support;

import java.security.GeneralSecurityException;
import java.util.Objects;
import javax.security.auth.login.AccountNotFoundException;
import lombok.Generated;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.BasicIdentifiableCredential;
import org.apereo.cas.authentication.handler.PrincipalNameTransformer;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.integration.pac4j.authentication.handler.support.AbstractWrapperAuthenticationHandler;
import org.apereo.cas.services.ServicesManager;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.TokenCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTokenWrapperAuthenticationHandler
extends AbstractWrapperAuthenticationHandler<BasicIdentifiableCredential, TokenCredentials> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTokenWrapperAuthenticationHandler.class);
    private final PrincipalNameTransformer principalNameTransformer;

    protected AbstractTokenWrapperAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, Integer order, PrincipalNameTransformer principalNameTransformer, SessionStore sessionStore) {
        super(name, servicesManager, principalFactory, order, sessionStore);
        this.principalNameTransformer = Objects.requireNonNullElseGet(principalNameTransformer, () -> formUserId -> formUserId);
    }

    @Override
    protected TokenCredentials convertToCredentials(BasicIdentifiableCredential casCredential) throws GeneralSecurityException {
        LOGGER.debug("CAS credentials: [{}]", (Object)casCredential);
        String id = this.principalNameTransformer.transform(casCredential.getId());
        if (id == null) {
            throw new AccountNotFoundException("Id is null.");
        }
        TokenCredentials credentials = new TokenCredentials(id);
        LOGGER.debug("pac4j credentials: [{}]", (Object)credentials);
        return credentials;
    }

    public boolean supports(Class<? extends Credential> clazz) {
        return BasicIdentifiableCredential.class.isAssignableFrom(clazz);
    }

    @Override
    protected Class<BasicIdentifiableCredential> getCasCredentialsType() {
        return BasicIdentifiableCredential.class;
    }
}

