/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pac4j.web.flow;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apereo.cas.authentication.principal.ClientCredential;
import org.apereo.cas.logout.slo.SingleLogoutRequestExecutor;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.SessionKeyCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DelegatedClientOidcLogoutAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedClientOidcLogoutAction.class);
    private final TicketRegistry ticketRegistry;
    private final SingleLogoutRequestExecutor singleLogoutRequestExecutor;

    private void removeSsoSessionsForSessionIndexes(HttpServletRequest request, HttpServletResponse response, SessionKeyCredentials sessionKeyCredentials) {
        String sessionKey = sessionKeyCredentials.getSessionKey();
        LOGGER.debug("Destroying SSO session for OIDC authn delegation for session key: [{}]", (Object)sessionKey);
        this.ticketRegistry.getSessionsWithAttributes(Map.of("sid", List.of(Objects.requireNonNull(sessionKey)))).filter(ticket -> !ticket.isExpired()).map(TicketGrantingTicket.class::cast).findFirst().ifPresent(ticket -> this.singleLogoutRequestExecutor.execute(ticket.getId(), request, response));
    }

    protected Event doExecuteInternal(RequestContext requestContext) throws Throwable {
        Credentials credentials;
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        ClientCredential clientCredential = (ClientCredential)WebUtils.getCredential((RequestContext)requestContext, ClientCredential.class);
        if (clientCredential != null && (credentials = clientCredential.getCredentials()) instanceof SessionKeyCredentials) {
            SessionKeyCredentials sessionKeyCredentials = (SessionKeyCredentials)credentials;
            HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
            this.removeSsoSessionsForSessionIndexes(request, response, sessionKeyCredentials);
        }
        return this.success();
    }

    @Generated
    public DelegatedClientOidcLogoutAction(TicketRegistry ticketRegistry, SingleLogoutRequestExecutor singleLogoutRequestExecutor) {
        this.ticketRegistry = ticketRegistry;
        this.singleLogoutRequestExecutor = singleLogoutRequestExecutor;
    }
}

