/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.actions.logout;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apereo.cas.authentication.principal.ClientCredential;
import org.apereo.cas.logout.slo.SingleLogoutRequestExecutor;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.pac4j.saml.credentials.SAML2Credentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DelegatedSaml2ClientLogoutAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedSaml2ClientLogoutAction.class);
    private final TicketRegistry ticketRegistry;
    private final SingleLogoutRequestExecutor singleLogoutRequestExecutor;

    private void removeSsoSessionsForSessionIndexes(HttpServletRequest request, HttpServletResponse response, LogoutRequest logoutRequest) {
        logoutRequest.getSessionIndexes().forEach(sessionIndex -> this.ticketRegistry.getSessionsWithAttributes(Map.of("sessionindex", List.of(Objects.requireNonNull(sessionIndex.getValue())))).filter(ticket -> !ticket.isExpired()).map(TicketGrantingTicket.class::cast).findFirst().ifPresent(ticket -> this.singleLogoutRequestExecutor.execute(ticket.getId(), request, response)));
    }

    protected Event doExecuteInternal(RequestContext requestContext) throws Throwable {
        SAML2Credentials saml2Credentials;
        Object object;
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        ClientCredential clientCredential = (ClientCredential)WebUtils.getCredential((RequestContext)requestContext, ClientCredential.class);
        if (clientCredential != null && (object = clientCredential.getCredentials()) instanceof SAML2Credentials && (object = (saml2Credentials = (SAML2Credentials)object).getContext().getMessageContext().getMessage()) instanceof LogoutRequest) {
            LogoutRequest logoutRequest = (LogoutRequest)object;
            if (HttpMethod.POST.matches(request.getMethod())) {
                HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
                this.removeSsoSessionsForSessionIndexes(request, response, logoutRequest);
            }
        }
        return this.success();
    }

    @Generated
    public DelegatedSaml2ClientLogoutAction(TicketRegistry ticketRegistry, SingleLogoutRequestExecutor singleLogoutRequestExecutor) {
        this.ticketRegistry = ticketRegistry;
        this.singleLogoutRequestExecutor = singleLogoutRequestExecutor;
    }
}

