/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.actions.logout;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.pac4j.client.DelegatedIdentityProviders;
import org.apereo.cas.web.flow.DelegationWebflowUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.pac4j.core.client.Client;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DelegatedSaml2ClientTerminateSessionAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedSaml2ClientTerminateSessionAction.class);
    private final DelegatedIdentityProviders identityProviders;
    private final SessionStore sessionStore;

    protected Event doExecuteInternal(RequestContext requestContext) throws Throwable {
        HttpServletResponse response;
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        JEEContext context = new JEEContext(request, response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext));
        UserProfile currentProfile = this.findCurrentProfile(context);
        Optional<Client> clientResult = this.findCurrentClient(currentProfile);
        if (clientResult.isPresent()) {
            Client client = clientResult.get();
            DelegationWebflowUtils.putDelegatedAuthenticationClientName((RequestContext)requestContext, (String)client.getName());
            LOGGER.debug("Starting logout SAML2 relay state attribute for delegated authentication client [{}]", (Object)client);
            this.sessionStore.set((WebContext)context, "samlRelayState", (Object)client.getName());
        }
        return null;
    }

    protected Optional<Client> findCurrentClient(UserProfile currentProfile) {
        return currentProfile == null ? Optional.empty() : this.identityProviders.findClient(currentProfile.getClientName());
    }

    protected UserProfile findCurrentProfile(JEEContext webContext) {
        ProfileManager pm = new ProfileManager((WebContext)webContext, this.sessionStore);
        Optional profile = pm.getProfile();
        return profile.orElse(null);
    }

    @Generated
    public DelegatedSaml2ClientTerminateSessionAction(DelegatedIdentityProviders identityProviders, SessionStore sessionStore) {
        this.identityProviders = identityProviders;
        this.sessionStore = sessionStore;
    }
}

