/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

public class DelegatedAuthenticationSaml2WebflowConfigurer
extends AbstractCasWebflowConfigurer {
    public DelegatedAuthenticationSaml2WebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry loginFlowDefinitionRegistry, FlowDefinitionRegistry logoutFlowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
        this.setLogoutFlowDefinitionRegistry(logoutFlowDefinitionRegistry);
        this.setOrder(casProperties.getAuthn().getPac4j().getWebflow().getOrder() + 10);
    }

    protected void doInitialize() {
        Flow flow = this.getLoginFlow();
        if (flow != null) {
            ActionState state = (ActionState)this.getState(flow, "delegatedAuthenticationIdPLogout", ActionState.class);
            state.getEntryActionList().add((Action)this.createEvaluateAction("delegatedSaml2ClientLogoutAction"));
        }
        this.createDelegatedClientLogoutAction();
    }

    protected void createDelegatedClientLogoutAction() {
        Flow logoutFlow = this.getLogoutFlow();
        if (logoutFlow != null) {
            ActionState finishLogout = (ActionState)this.getState(logoutFlow, "finishLogout", ActionState.class);
            finishLogout.getExitActionList().add((Action)this.createEvaluateAction("delegatedAuthenticationSaml2ClientFinishLogoutAction"));
            TransitionableState terminateSessionState = this.getState(logoutFlow, "terminateSession");
            terminateSessionState.getEntryActionList().add((Action)this.createEvaluateAction("delegatedAuthenticationSaml2ClientFinishLogoutAction"));
            terminateSessionState.getEntryActionList().add((Action)this.createEvaluateAction("delegatedSaml2ClientTerminateSessionAction"));
        }
    }
}

