/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.config;

import java.util.ArrayList;
import java.util.Collection;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.ServiceFactoryConfigurer;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.DelegatedAuthenticationWebApplicationServiceFactory;
import org.apereo.cas.web.DelegatedClientNavigationController;
import org.apereo.cas.web.DelegatedClientWebflowManager;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlan;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.DelegatedAuthenticationErrorViewResolver;
import org.apereo.cas.web.flow.DelegatedAuthenticationSAML2ClientLogoutAction;
import org.apereo.cas.web.flow.DelegatedAuthenticationWebflowConfigurer;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationAction;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.pac4j.DelegatedSessionCookieManager;
import org.apereo.cas.web.saml2.Saml2ClientMetadataController;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.pac4j.core.client.Clients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.ErrorViewResolver;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@Configuration(value="delegatedAuthenticationWebflowConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class DelegatedAuthenticationWebflowConfiguration
implements CasWebflowExecutionPlanConfigurer,
ServiceFactoryConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedAuthenticationWebflowConfiguration.class);
    @Autowired
    @Qualifier(value="defaultTicketFactory")
    private ObjectProvider<TicketFactory> ticketFactory;
    @Autowired
    @Qualifier(value="authenticationServiceSelectionPlan")
    private ObjectProvider<AuthenticationServiceSelectionPlan> authenticationRequestServiceSelectionStrategies;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private ObjectProvider<CentralAuthenticationService> centralAuthenticationService;
    @Autowired
    @Qualifier(value="registeredServiceDelegatedAuthenticationPolicyAuditableEnforcer")
    private ObjectProvider<AuditableExecution> registeredServiceDelegatedAuthenticationPolicyAuditableEnforcer;
    @Autowired
    @Qualifier(value="builtClients")
    private ObjectProvider<Clients> builtClients;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="ticketRegistry")
    private ObjectProvider<TicketRegistry> ticketRegistry;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private ObjectProvider<AuthenticationSystemSupport> authenticationSystemSupport;
    @Autowired
    @Qualifier(value="shibboleth.OpenSAMLConfig")
    private ObjectProvider<OpenSamlConfigBean> configBean;
    @Autowired
    @Qualifier(value="loginFlowRegistry")
    private ObjectProvider<FlowDefinitionRegistry> loginFlowDefinitionRegistry;
    @Autowired
    private ObjectProvider<FlowBuilderServices> flowBuilderServices;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="pac4jDelegatedSessionCookieManager")
    private ObjectProvider<DelegatedSessionCookieManager> delegatedSessionCookieManager;
    @Autowired
    @Qualifier(value="argumentExtractor")
    private ObjectProvider<ArgumentExtractor> argumentExtractor;
    @Autowired
    @Qualifier(value="saml2ClientLogoutAction")
    private ObjectProvider<Action> saml2ClientLogoutAction;
    @Autowired
    @Qualifier(value="adaptiveAuthenticationPolicy")
    private ObjectProvider<AdaptiveAuthenticationPolicy> adaptiveAuthenticationPolicy;
    @Autowired
    @Qualifier(value="serviceTicketRequestWebflowEventResolver")
    private ObjectProvider<CasWebflowEventResolver> serviceTicketRequestWebflowEventResolver;
    @Autowired
    @Qualifier(value="initialAuthenticationAttemptWebflowEventResolver")
    private ObjectProvider<CasDelegatingWebflowEventResolver> initialAuthenticationAttemptWebflowEventResolver;
    @Autowired
    @Qualifier(value="logoutFlowRegistry")
    private ObjectProvider<FlowDefinitionRegistry> logoutFlowDefinitionRegistry;

    @Bean
    @ConditionalOnMissingBean(name={"pac4jErrorViewResolver"})
    @RefreshScope
    public static ErrorViewResolver pac4jErrorViewResolver() {
        return new DelegatedAuthenticationErrorViewResolver();
    }

    @ConditionalOnMissingBean(name={"saml2ClientLogoutAction"})
    @Bean
    @Lazy
    @RefreshScope
    public Action saml2ClientLogoutAction() {
        return new DelegatedAuthenticationSAML2ClientLogoutAction((Clients)this.builtClients.getIfAvailable());
    }

    @RefreshScope
    @ConditionalOnMissingBean(name={"clientAction"})
    @Bean
    @Lazy
    public Action clientAction() {
        return new DelegatedClientAuthenticationAction((CasDelegatingWebflowEventResolver)this.initialAuthenticationAttemptWebflowEventResolver.getIfAvailable(), (CasWebflowEventResolver)this.serviceTicketRequestWebflowEventResolver.getIfAvailable(), (AdaptiveAuthenticationPolicy)this.adaptiveAuthenticationPolicy.getIfAvailable(), (Clients)this.builtClients.getIfAvailable(), (ServicesManager)this.servicesManager.getIfAvailable(), (AuditableExecution)this.registeredServiceDelegatedAuthenticationPolicyAuditableEnforcer.getIfAvailable(), this.delegatedClientWebflowManager(), (DelegatedSessionCookieManager)this.delegatedSessionCookieManager.getIfAvailable(), (AuthenticationSystemSupport)this.authenticationSystemSupport.getIfAvailable(), this.casProperties.getLocale().getParamName(), this.casProperties.getTheme().getParamName(), (AuthenticationServiceSelectionPlan)this.authenticationRequestServiceSelectionStrategies.getIfAvailable(), (CentralAuthenticationService)this.centralAuthenticationService.getIfAvailable());
    }

    @ConditionalOnMissingBean(name={"delegatedAuthenticationWebflowConfigurer"})
    @Bean
    @DependsOn(value={"defaultWebflowConfigurer"})
    public CasWebflowConfigurer delegatedAuthenticationWebflowConfigurer() {
        return new DelegatedAuthenticationWebflowConfigurer((FlowBuilderServices)this.flowBuilderServices.getIfAvailable(), (FlowDefinitionRegistry)this.loginFlowDefinitionRegistry.getIfAvailable(), (FlowDefinitionRegistry)this.logoutFlowDefinitionRegistry.getIfAvailable(), this.applicationContext, this.casProperties);
    }

    @ConditionalOnMissingBean(name={"delegatedClientWebflowManager"})
    @RefreshScope
    @Bean
    public DelegatedClientWebflowManager delegatedClientWebflowManager() {
        return new DelegatedClientWebflowManager((TicketRegistry)this.ticketRegistry.getIfAvailable(), (TicketFactory)this.ticketFactory.getIfAvailable(), this.casProperties.getTheme().getParamName(), this.casProperties.getLocale().getParamName(), (AuthenticationServiceSelectionPlan)this.authenticationRequestServiceSelectionStrategies.getIfAvailable(), (ArgumentExtractor)this.argumentExtractor.getIfAvailable());
    }

    @Bean
    public Saml2ClientMetadataController saml2ClientMetadataController() {
        return new Saml2ClientMetadataController((Clients)this.builtClients.getIfAvailable(), (OpenSamlConfigBean)this.configBean.getIfAvailable());
    }

    @ConditionalOnMissingBean(name={"delegatedClientNavigationController"})
    @Bean
    public DelegatedClientNavigationController delegatedClientNavigationController() {
        return new DelegatedClientNavigationController((Clients)this.builtClients.getIfAvailable(), this.delegatedClientWebflowManager(), (DelegatedSessionCookieManager)this.delegatedSessionCookieManager.getIfAvailable());
    }

    public void configureWebflowExecutionPlan(CasWebflowExecutionPlan plan) {
        plan.registerWebflowConfigurer(this.delegatedAuthenticationWebflowConfigurer());
    }

    public Collection<ServiceFactory<? extends WebApplicationService>> buildServiceFactories() {
        if (!this.casProperties.getSso().isAllowMissingServiceParameter()) {
            return CollectionUtils.wrap((Object)((Object)new DelegatedAuthenticationWebApplicationServiceFactory((Clients)this.builtClients.getIfAvailable(), this.delegatedClientWebflowManager())));
        }
        return new ArrayList<ServiceFactory<? extends WebApplicationService>>();
    }
}

