/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.util.Pac4jUtils;
import org.apereo.cas.web.DelegatedClientWebflowManager;
import org.apereo.cas.web.pac4j.DelegatedSessionCookieManager;
import org.apereo.cas.web.view.DynamicHtmlView;
import org.jasig.cas.client.util.URIBuilder;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.client.Clients;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.redirect.RedirectAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller(value="delegatedClientNavigationController")
@RequestMapping
public class DelegatedClientNavigationController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedClientNavigationController.class);
    public static final String ENDPOINT_REDIRECT = "clientredirect";
    public static final String ENDPOINT_RESPONSE = "login/{clientName}";
    private final Clients clients;
    private final DelegatedClientWebflowManager delegatedClientWebflowManager;
    private final DelegatedSessionCookieManager delegatedSessionCookieManager;

    @GetMapping(value={"clientredirect"})
    public View redirectToProvider(HttpServletRequest request, HttpServletResponse response) {
        String clientName = request.getParameter("client_name");
        if (StringUtils.isBlank((CharSequence)clientName)) {
            clientName = (String)request.getAttribute("client_name");
        }
        try {
            DynamicHtmlView result;
            if (StringUtils.isBlank((CharSequence)clientName)) {
                throw new UnauthorizedServiceException("No client name parameter is provided in the incoming request");
            }
            IndirectClient client = (IndirectClient)this.clients.findClient(clientName);
            J2EContext webContext = Pac4jUtils.getPac4jJ2EContext((HttpServletRequest)request, (HttpServletResponse)response);
            Ticket ticket = this.delegatedClientWebflowManager.store(webContext, (BaseClient)client);
            RedirectAction action = client.getRedirectAction((WebContext)webContext);
            if (RedirectAction.RedirectType.SUCCESS.equals((Object)action.getType())) {
                result = new DynamicHtmlView(action.getContent());
            } else {
                URIBuilder builder = new URIBuilder(action.getLocation());
                String url = builder.toString();
                LOGGER.debug("Redirecting client [{}] to [{}] based on identifier [{}]", new Object[]{client.getName(), url, ticket.getId()});
                result = new RedirectView(url);
            }
            this.delegatedSessionCookieManager.store(webContext);
            return result;
        }
        catch (HttpAction e) {
            if (e.getCode() == HttpStatus.UNAUTHORIZED.value()) {
                LOGGER.debug("Authentication request was denied from the provider [{}]", (Object)clientName, (Object)e);
            } else {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
            throw new UnauthorizedServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @GetMapping(value={"login/{clientName}"})
    public View redirectResponseToFlow(@PathVariable(value="clientName") String clientName, HttpServletRequest request, HttpServletResponse response) {
        URIBuilder builder = new URIBuilder(request.getRequestURL().append('?').append(request.getQueryString()).toString());
        builder.setPath(builder.getPath().replace('/' + clientName, ""));
        builder.addParameter("client_name", clientName);
        String url = builder.toString();
        LOGGER.debug("Received a response for {}, redirecting the login flow ({})", (Object)clientName, (Object)url);
        RedirectView result = new RedirectView(url);
        return result;
    }

    @Generated
    public DelegatedClientNavigationController(Clients clients, DelegatedClientWebflowManager delegatedClientWebflowManager, DelegatedSessionCookieManager delegatedSessionCookieManager) {
        this.clients = clients;
        this.delegatedClientWebflowManager = delegatedClientWebflowManager;
        this.delegatedSessionCookieManager = delegatedSessionCookieManager;
    }
}

