/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.ticket.TransientSessionTicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.support.WebUtils;
import org.pac4j.cas.client.CasClient;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.oauth.client.OAuth10Client;
import org.pac4j.oauth.client.OAuth20Client;
import org.pac4j.oauth.config.OAuth20Configuration;
import org.pac4j.oidc.client.OidcClient;
import org.pac4j.saml.client.SAML2Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.webflow.execution.RequestContext;

@Transactional(transactionManager="ticketTransactionManager")
public class DelegatedClientWebflowManager {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedClientWebflowManager.class);
    public static final String PARAMETER_CLIENT_ID = "delegatedclientid";
    private static final String OAUTH10_CLIENT_ID_SESSION_KEY = "OAUTH10_CLIENT_ID";
    private final TicketRegistry ticketRegistry;
    private final TicketFactory ticketFactory;
    private final String themeParamName;
    private final String localParamName;
    private final AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies;
    private final ArgumentExtractor argumentExtractor;

    public Ticket store(J2EContext webContext, BaseClient client) {
        OAuth20Configuration config;
        Map<String, Serializable> properties = this.buildTicketProperties(webContext);
        WebApplicationService originalService = this.argumentExtractor.extractService(webContext.getRequest());
        Service service = this.authenticationRequestServiceSelectionStrategies.resolveService((Service)originalService);
        properties.put("service", (Serializable)originalService);
        properties.put("targetService", (Serializable)service);
        TransientSessionTicketFactory transientFactory = (TransientSessionTicketFactory)this.ticketFactory.get(TransientSessionTicket.class);
        TransientSessionTicket ticket = transientFactory.create((Service)originalService, properties);
        String ticketId = ticket.getId();
        LOGGER.debug("Storing delegated authentication request ticket [{}] for service [{}] with properties [{}]", new Object[]{ticketId, ticket.getService(), ticket.getProperties()});
        this.ticketRegistry.addTicket((Ticket)ticket);
        webContext.setRequestAttribute(PARAMETER_CLIENT_ID, (Object)ticketId);
        if (client instanceof SAML2Client) {
            webContext.getSessionStore().set((WebContext)webContext, "samlRelayState", (Object)ticketId);
        }
        if (client instanceof OAuth20Client) {
            OAuth20Client oauthClient = (OAuth20Client)client;
            config = oauthClient.getConfiguration();
            config.setWithState(true);
            config.setStateData(ticketId);
        }
        if (client instanceof OidcClient) {
            OidcClient oidcClient = (OidcClient)client;
            config = oidcClient.getConfiguration();
            config.setWithState(true);
            config.setStateData(ticketId);
        }
        if (client instanceof CasClient) {
            CasClient casClient = (CasClient)client;
            casClient.getConfiguration().addCustomParam(PARAMETER_CLIENT_ID, ticketId);
        }
        if (client instanceof OAuth10Client) {
            webContext.getSessionStore().set((WebContext)webContext, OAUTH10_CLIENT_ID_SESSION_KEY, (Object)ticket.getId());
        }
        return ticket;
    }

    protected Map<String, Serializable> buildTicketProperties(J2EContext webContext) {
        LinkedHashMap<String, Serializable> properties = new LinkedHashMap<String, Serializable>();
        properties.put(this.themeParamName, (Serializable)((Object)StringUtils.defaultString((String)webContext.getRequestParameter(this.themeParamName))));
        properties.put(this.localParamName, (Serializable)((Object)StringUtils.defaultString((String)webContext.getRequestParameter(this.localParamName))));
        properties.put("method", (Serializable)((Object)StringUtils.defaultString((String)webContext.getRequestParameter("method"))));
        return properties;
    }

    public Service retrieve(RequestContext requestContext, WebContext webContext, BaseClient client) {
        String clientId = this.getDelegatedClientId(webContext, client);
        TransientSessionTicket ticket = this.retrieveSessionTicketViaClientId(webContext, clientId);
        this.restoreDelegatedAuthenticationRequest(requestContext, webContext, ticket);
        LOGGER.debug("Removing delegated client identifier [{}} from registry", (Object)ticket.getId());
        this.ticketRegistry.deleteTicket(ticket.getId());
        return ticket.getService();
    }

    protected TransientSessionTicket retrieveSessionTicketViaClientId(WebContext webContext, String clientId) {
        TransientSessionTicket ticket = (TransientSessionTicket)this.ticketRegistry.getTicket(clientId, TransientSessionTicket.class);
        if (ticket == null) {
            LOGGER.error("Delegated client identifier cannot be located in the authentication request [{}]", (Object)webContext.getFullRequestURL());
            throw new UnauthorizedServiceException("screen.service.error.message", "");
        }
        if (ticket.isExpired()) {
            LOGGER.error("Delegated client identifier [{}] has expired in the authentication request", (Object)ticket.getId());
            this.ticketRegistry.deleteTicket(ticket.getId());
            throw new UnauthorizedServiceException("screen.service.error.message", "");
        }
        LOGGER.debug("Located delegated client identifier as [{}]", (Object)ticket.getId());
        return ticket;
    }

    protected Service restoreDelegatedAuthenticationRequest(RequestContext requestContext, WebContext webContext, TransientSessionTicket ticket) {
        Service service = ticket.getService();
        LOGGER.debug("Restoring requested service [{}] back in the authentication flow", (Object)service);
        WebUtils.putService((RequestContext)requestContext, (Service)service);
        webContext.setRequestAttribute("service", (Object)service);
        webContext.setRequestAttribute(this.themeParamName, ticket.getProperties().get(this.themeParamName));
        webContext.setRequestAttribute(this.localParamName, ticket.getProperties().get(this.localParamName));
        webContext.setRequestAttribute("method", ticket.getProperties().get("method"));
        return service;
    }

    protected String getDelegatedClientId(WebContext webContext, BaseClient client) {
        String clientId = webContext.getRequestParameter(PARAMETER_CLIENT_ID);
        if (StringUtils.isBlank((CharSequence)clientId)) {
            if (client instanceof SAML2Client) {
                LOGGER.debug("Client identifier could not found as part of the request parameters. Looking at relay-state for the SAML2 client");
                clientId = webContext.getRequestParameter("RelayState");
            }
            if (client instanceof OAuth20Client || client instanceof OidcClient) {
                LOGGER.debug("Client identifier could not found as part of the request parameters. Looking at state for the OAuth2/Oidc client");
                clientId = webContext.getRequestParameter("state");
            }
            if (client instanceof OAuth10Client) {
                LOGGER.debug("Client identifier could not be found as part of request parameters.  Looking at state for the OAuth1 client");
                SessionStore sessionStore = webContext.getSessionStore();
                clientId = (String)sessionStore.get(webContext, OAUTH10_CLIENT_ID_SESSION_KEY);
                sessionStore.set(webContext, OAUTH10_CLIENT_ID_SESSION_KEY, null);
            }
        }
        LOGGER.debug("Located delegated client identifier for this request as [{}]", (Object)clientId);
        return clientId;
    }

    @Generated
    public DelegatedClientWebflowManager(TicketRegistry ticketRegistry, TicketFactory ticketFactory, String themeParamName, String localParamName, AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies, ArgumentExtractor argumentExtractor) {
        this.ticketRegistry = ticketRegistry;
        this.ticketFactory = ticketFactory;
        this.themeParamName = themeParamName;
        this.localParamName = localParamName;
        this.authenticationRequestServiceSelectionStrategies = authenticationRequestServiceSelectionStrategies;
        this.argumentExtractor = argumentExtractor;
    }
}

