/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.web.BaseDelegatedAuthenticationController;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationConfigurationContext;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.servlet.View;

public class DefaultDelegatedAuthenticationNavigationController
extends BaseDelegatedAuthenticationController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDelegatedAuthenticationNavigationController.class);

    public DefaultDelegatedAuthenticationNavigationController(DelegatedClientAuthenticationConfigurationContext context) {
        super(context);
    }

    @GetMapping(value={"clientredirect"})
    public View redirectToProvider(HttpServletRequest request, HttpServletResponse response) {
        String clientName = request.getParameter("client_name");
        if (StringUtils.isBlank((CharSequence)clientName)) {
            clientName = (String)request.getAttribute("client_name");
        }
        try {
            if (StringUtils.isBlank((CharSequence)clientName)) {
                throw new UnauthorizedServiceException("No client name parameter is provided in the incoming request");
            }
            Optional clientResult = this.getConfigurationContext().getClients().findClient(clientName);
            if (clientResult.isEmpty()) {
                throw new UnauthorizedServiceException("Unable to locate client " + clientName);
            }
            IndirectClient client = (IndirectClient)IndirectClient.class.cast(clientResult.get());
            client.init();
            JEEContext webContext = new JEEContext(request, response);
            TransientSessionTicket ticket = this.getConfigurationContext().getDelegatedClientAuthenticationWebflowManager().store(webContext, (Client)client);
            return this.getResultingView(client, (WebContext)webContext, ticket);
        }
        catch (Exception e) {
            String message = String.format("Authentication request was denied from the provider %s", clientName);
            LoggingUtils.warn((Logger)LOGGER, (String)message, (Throwable)e);
            throw new UnauthorizedServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @GetMapping(value={"login/{clientName}"})
    public View redirectResponseToFlow(@PathVariable(value="clientName") String clientName, HttpServletRequest request, HttpServletResponse response) {
        return this.buildRedirectViewBackToFlow(clientName, request);
    }

    @PostMapping(value={"login/{clientName}"})
    public View postResponseToFlow(@PathVariable(value="clientName") String clientName, HttpServletRequest request, HttpServletResponse response) {
        return this.buildRedirectViewBackToFlow(clientName, request);
    }
}

