/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.web.support.WebUtils;
import org.pac4j.core.client.Clients;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.http.adapter.JEEHttpActionAdapter;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.logout.impl.SAML2LogoutValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DelegatedAuthenticationClientFinishLogoutAction
extends AbstractAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedAuthenticationClientFinishLogoutAction.class);
    private final Clients clients;
    private final SessionStore sessionStore;

    protected Event doExecute(RequestContext requestContext) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
        JEEContext context = new JEEContext(request, response);
        String clientName = WebUtils.getDelegatedAuthenticationClientName((RequestContext)requestContext);
        if (clientName == null) {
            clientName = requestContext.getRequestParameters().get("RelayState");
            if (StringUtils.isNotBlank((CharSequence)clientName)) {
                this.clients.findClient(clientName).filter(client -> client instanceof SAML2Client).map(SAML2Client.class::cast).ifPresent(client -> {
                    try {
                        LOGGER.debug("Located client from relay-state: [{}]", client);
                        SAML2MessageContext samlContext = client.getContextProvider().buildContext(client, (WebContext)context, this.sessionStore);
                        client.getLogoutProfileHandler().receive(samlContext);
                    }
                    catch (HttpAction action) {
                        LOGGER.debug("Adapting logout response via [{}]", (Object)action.toString());
                        JEEHttpActionAdapter.INSTANCE.adapt(action, (WebContext)context);
                    }
                    catch (Exception e) {
                        LoggingUtils.error((Logger)LOGGER, (Throwable)e);
                    }
                });
            }
        } else {
            this.clients.findClient(clientName).filter(client -> client instanceof SAML2Client).map(SAML2Client.class::cast).ifPresent(client -> {
                LOGGER.debug("Located client from webflow state: [{}]", client);
                String logoutRedirect = (String)WebUtils.getLogoutRedirectUrl((RequestContext)requestContext, String.class);
                SAML2LogoutValidator validator = client.getLogoutValidator();
                validator.setPostLogoutURL(logoutRedirect);
                LOGGER.debug("Captured post logout url: [{}]", (Object)logoutRedirect);
                WebUtils.putLogoutRedirectUrl((RequestContext)requestContext, null);
            });
        }
        return null;
    }

    @Generated
    public DelegatedAuthenticationClientFinishLogoutAction(Clients clients, SessionStore sessionStore) {
        this.clients = clients;
        this.sessionStore = sessionStore;
    }
}

