/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationAction;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.EndState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.TransitionSet;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DelegatedAuthenticationWebflowConfigurer
extends AbstractCasWebflowConfigurer {
    private static final String DECISION_STATE_CHECK_DELEGATED_AUTHN_FAILURE = "checkDelegatedAuthnFailureDecision";

    public DelegatedAuthenticationWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry loginFlowDefinitionRegistry, FlowDefinitionRegistry logoutFlowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
        this.setLogoutFlowDefinitionRegistry(logoutFlowDefinitionRegistry);
    }

    protected void doInitialize() {
        Flow flow = this.getLoginFlow();
        if (flow != null) {
            this.createClientActionState(flow);
            this.createStopWebflowViewState(flow);
            this.createDelegatedClientLogoutAction();
        }
    }

    protected void createDelegatedClientLogoutAction() {
        Flow logoutFlow = this.getLogoutFlow();
        TransitionableState terminateSessionState = this.getState(logoutFlow, "terminateSession");
        terminateSessionState.getEntryActionList().add((Action)this.createEvaluateAction("delegatedAuthenticationClientLogoutAction"));
        ActionState finishLogout = (ActionState)this.getState(logoutFlow, "finishLogout", ActionState.class);
        finishLogout.getExitActionList().add((Action)this.createEvaluateAction("delegatedAuthenticationClientFinishLogoutAction"));
    }

    protected void createClientActionState(Flow flow) {
        ActionState actionState = this.createActionState(flow, "delegatedAuthentication", (Action)this.createEvaluateAction("delegatedAuthenticationAction"));
        TransitionSet transitionSet = actionState.getTransitionSet();
        transitionSet.add(this.createTransition("success", "createTicketGrantingTicket"));
        String currentStartState = this.getStartState(flow).getId();
        transitionSet.add(this.createTransition("error", currentStartState));
        transitionSet.add(this.createTransition("successWithWarnings", "showAuthenticationWarningMessages"));
        transitionSet.add(this.createTransition("resume", "createTicketGrantingTicket"));
        transitionSet.add(this.createTransition("authenticationFailure", DECISION_STATE_CHECK_DELEGATED_AUTHN_FAILURE));
        transitionSet.add(this.createTransition("stop", "stopWebflow"));
        transitionSet.add(this.createTransition("warn", "warn"));
        transitionSet.add(this.createTransition("generateServiceTicket", "generateServiceTicket"));
        this.setStartState(flow, (TransitionableState)actionState);
    }

    protected void createStopWebflowViewState(Flow flow) {
        this.createDecisionState(flow, DECISION_STATE_CHECK_DELEGATED_AUTHN_FAILURE, "flowScope.unauthorizedRedirectUrl != null", "serviceUnauthorizedCheck", "stopWebflow");
        ViewState stopWebflowState = this.createViewState(flow, "stopWebflow", "delegated-authn/casDelegatedAuthnStopWebflow");
        stopWebflowState.getEntryActionList().add((Action)new AbstractAction(){

            protected Event doExecute(RequestContext requestContext) {
                HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
                HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
                Optional<ModelAndView> mv = DelegatedClientAuthenticationAction.hasDelegationRequestFailed(request, response.getStatus());
                mv.ifPresent(modelAndView -> modelAndView.getModel().forEach((k, v) -> requestContext.getFlowScope().put(k, v)));
                return null;
            }
        });
        this.createTransitionForState((TransitionableState)stopWebflowState, "retry", "delegatedAuthenticationClientRetry");
        EndState retryState = this.createEndState(flow, "delegatedAuthenticationClientRetry");
        retryState.setFinalResponseAction((Action)this.createEvaluateAction("delegatedAuthenticationClientRetryAction"));
    }
}

