/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.cookie.CookieProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationCookieProperties;
import org.apereo.cas.pac4j.client.DelegatedClientAuthenticationRequestCustomizer;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.validation.DelegatedAuthenticationAccessStrategyHelper;
import org.apereo.cas.web.DefaultDelegatedAuthenticationNavigationController;
import org.apereo.cas.web.DefaultDelegatedClientAuthenticationWebflowManager;
import org.apereo.cas.web.DelegatedAuthenticationCookieGenerator;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.DefaultDelegatedClientIdentityProviderConfigurationProducer;
import org.apereo.cas.web.flow.DelegatedAuthenticationClientFinishLogoutAction;
import org.apereo.cas.web.flow.DelegatedAuthenticationClientLogoutAction;
import org.apereo.cas.web.flow.DelegatedAuthenticationClientRetryAction;
import org.apereo.cas.web.flow.DelegatedAuthenticationErrorViewResolver;
import org.apereo.cas.web.flow.DelegatedAuthenticationWebflowConfigurer;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationAction;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationConfigurationContext;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationWebflowManager;
import org.apereo.cas.web.flow.DelegatedClientIdentityProviderConfigurationProducer;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.configurer.CasMultifactorWebflowCustomizer;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.saml2.DelegatedSaml2ClientMetadataController;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.support.CookieUtils;
import org.pac4j.core.client.Clients;
import org.pac4j.core.context.session.SessionStore;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorViewResolver;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@Configuration(value="delegatedAuthenticationWebflowConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class DelegatedAuthenticationWebflowConfiguration {
    @Autowired
    @Qualifier(value="singleSignOnParticipationStrategy")
    private ObjectProvider<SingleSignOnParticipationStrategy> webflowSingleSignOnParticipationStrategy;
    @Autowired
    @Qualifier(value="defaultTicketFactory")
    private ObjectProvider<TicketFactory> ticketFactory;
    @Autowired
    @Qualifier(value="registeredServiceAccessStrategyEnforcer")
    private ObjectProvider<AuditableExecution> registeredServiceAccessStrategyEnforcer;
    @Autowired
    @Qualifier(value="authenticationServiceSelectionPlan")
    private ObjectProvider<AuthenticationServiceSelectionPlan> authenticationRequestServiceSelectionStrategies;
    @Autowired
    @Qualifier(value="registeredServiceDelegatedAuthenticationPolicyAuditableEnforcer")
    private ObjectProvider<AuditableExecution> delegatedAuthenticationPolicyAuditableEnforcer;
    @Autowired
    @Qualifier(value="builtClients")
    private ObjectProvider<Clients> builtClients;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private ObjectProvider<CentralAuthenticationService> centralAuthenticationService;
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private ObjectProvider<AuthenticationSystemSupport> authenticationSystemSupport;
    @Autowired
    @Qualifier(value="shibboleth.OpenSAMLConfig")
    private ObjectProvider<OpenSamlConfigBean> configBean;
    @Autowired
    @Qualifier(value="loginFlowRegistry")
    private ObjectProvider<FlowDefinitionRegistry> loginFlowDefinitionRegistry;
    @Autowired
    private ObjectProvider<FlowBuilderServices> flowBuilderServices;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="delegatedClientDistributedSessionCookieGenerator")
    private ObjectProvider<CasCookieBuilder> delegatedClientDistributedSessionCookieGenerator;
    @Autowired
    @Qualifier(value="delegatedClientDistributedSessionStore")
    private ObjectProvider<SessionStore> delegatedClientDistributedSessionStore;
    @Autowired
    @Qualifier(value="argumentExtractor")
    private ObjectProvider<ArgumentExtractor> argumentExtractor;
    @Autowired
    @Qualifier(value="adaptiveAuthenticationPolicy")
    private ObjectProvider<AdaptiveAuthenticationPolicy> adaptiveAuthenticationPolicy;
    @Autowired
    @Qualifier(value="serviceTicketRequestWebflowEventResolver")
    private ObjectProvider<CasWebflowEventResolver> serviceTicketRequestWebflowEventResolver;
    @Autowired
    @Qualifier(value="initialAuthenticationAttemptWebflowEventResolver")
    private ObjectProvider<CasDelegatingWebflowEventResolver> initialAuthenticationAttemptWebflowEventResolver;
    @Autowired
    @Qualifier(value="logoutFlowRegistry")
    private ObjectProvider<FlowDefinitionRegistry> logoutFlowDefinitionRegistry;
    @Autowired
    @Qualifier(value="conventionErrorViewResolver")
    private ObjectProvider<ErrorViewResolver> conventionErrorViewResolver;

    @Bean
    @ConditionalOnMissingBean(name={"pac4jErrorViewResolver"})
    @RefreshScope
    public ErrorViewResolver pac4jErrorViewResolver() {
        return new DelegatedAuthenticationErrorViewResolver((ErrorViewResolver)this.conventionErrorViewResolver.getObject());
    }

    @ConditionalOnMissingBean(name={"delegatedAuthenticationClientLogoutAction"})
    @Bean
    @RefreshScope
    public Action delegatedAuthenticationClientLogoutAction() {
        return new DelegatedAuthenticationClientLogoutAction((Clients)this.builtClients.getObject(), (SessionStore)this.delegatedClientDistributedSessionStore.getObject());
    }

    @ConditionalOnMissingBean(name={"delegatedAuthenticationClientFinishLogoutAction"})
    @Bean
    @RefreshScope
    public Action delegatedAuthenticationClientFinishLogoutAction() {
        return new DelegatedAuthenticationClientFinishLogoutAction((Clients)this.builtClients.getObject(), (SessionStore)this.delegatedClientDistributedSessionStore.getObject());
    }

    @ConditionalOnMissingBean(name={"delegatedAuthenticationClientRetryAction"})
    @Bean
    @RefreshScope
    public Action delegatedAuthenticationClientRetryAction() {
        return new DelegatedAuthenticationClientRetryAction((Clients)this.builtClients.getObject(), this.delegatedClientIdentityProviderConfigurationProducer());
    }

    @RefreshScope
    @ConditionalOnMissingBean(name={"delegatedAuthenticationAction"})
    @Bean
    public Action delegatedAuthenticationAction() {
        return new DelegatedClientAuthenticationAction(this.delegatedClientAuthenticationConfigurationContext());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"delegatedClientAuthenticationConfigurationContext"})
    public DelegatedClientAuthenticationConfigurationContext delegatedClientAuthenticationConfigurationContext() {
        return ((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)DelegatedClientAuthenticationConfigurationContext.builder().initialAuthenticationAttemptWebflowEventResolver((CasDelegatingWebflowEventResolver)this.initialAuthenticationAttemptWebflowEventResolver.getObject())).serviceTicketRequestWebflowEventResolver((CasWebflowEventResolver)this.serviceTicketRequestWebflowEventResolver.getObject())).adaptiveAuthenticationPolicy((AdaptiveAuthenticationPolicy)this.adaptiveAuthenticationPolicy.getObject())).clients((Clients)this.builtClients.getObject())).servicesManager((ServicesManager)this.servicesManager.getObject())).delegatedAuthenticationPolicyEnforcer((AuditableExecution)this.delegatedAuthenticationPolicyAuditableEnforcer.getObject())).delegatedClientAuthenticationWebflowManager(this.delegatedClientWebflowManager())).authenticationSystemSupport((AuthenticationSystemSupport)this.authenticationSystemSupport.getObject())).casProperties(this.casProperties)).centralAuthenticationService((CentralAuthenticationService)this.centralAuthenticationService.getObject())).authenticationRequestServiceSelectionStrategies((AuthenticationServiceSelectionPlan)this.authenticationRequestServiceSelectionStrategies.getObject())).singleSignOnParticipationStrategy((SingleSignOnParticipationStrategy)this.webflowSingleSignOnParticipationStrategy.getObject())).sessionStore((SessionStore)this.delegatedClientDistributedSessionStore.getObject())).argumentExtractor((ArgumentExtractor)this.argumentExtractor.getObject())).ticketFactory((TicketFactory)this.ticketFactory.getObject())).delegatedClientIdentityProvidersProducer(this.delegatedClientIdentityProviderConfigurationProducer())).delegatedClientCookieGenerator(this.delegatedAuthenticationCookieGenerator())).delegatedClientDistributedSessionCookieGenerator((CasCookieBuilder)this.delegatedClientDistributedSessionCookieGenerator.getObject())).registeredServiceAccessStrategyEnforcer((AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getObject())).delegatedClientAuthenticationRequestCustomizers(this.delegatedClientAuthenticationRequestCustomizers())).delegatedAuthenticationAccessStrategyHelper(this.getDelegatedAuthenticationAccessStrategyHelper())).build();
    }

    @Bean
    @ConditionalOnMissingBean(name={"delegatedClientAuthenticationRequestCustomizers"})
    @RefreshScope
    public List<DelegatedClientAuthenticationRequestCustomizer> delegatedClientAuthenticationRequestCustomizers() {
        Collection customizers = this.applicationContext.getBeansOfType(DelegatedClientAuthenticationRequestCustomizer.class, false, true).values();
        return new ArrayList<DelegatedClientAuthenticationRequestCustomizer>(customizers);
    }

    @ConditionalOnMissingBean(name={"delegatedAuthenticationWebflowConfigurer"})
    @Bean
    @DependsOn(value={"defaultWebflowConfigurer", "defaultLogoutWebflowConfigurer"})
    public CasWebflowConfigurer delegatedAuthenticationWebflowConfigurer() {
        return new DelegatedAuthenticationWebflowConfigurer((FlowBuilderServices)this.flowBuilderServices.getObject(), (FlowDefinitionRegistry)this.loginFlowDefinitionRegistry.getObject(), (FlowDefinitionRegistry)this.logoutFlowDefinitionRegistry.getObject(), this.applicationContext, this.casProperties);
    }

    @ConditionalOnMissingBean(name={"delegatedClientWebflowManager"})
    @RefreshScope
    @Bean
    public DelegatedClientAuthenticationWebflowManager delegatedClientWebflowManager() {
        return new DefaultDelegatedClientAuthenticationWebflowManager(this.delegatedClientAuthenticationConfigurationContext());
    }

    @Bean
    public DelegatedSaml2ClientMetadataController delegatedSaml2ClientMetadataController() {
        return new DelegatedSaml2ClientMetadataController((Clients)this.builtClients.getObject(), (OpenSamlConfigBean)this.configBean.getObject());
    }

    @ConditionalOnMissingBean(name={"delegatedClientNavigationController"})
    @Bean
    public DefaultDelegatedAuthenticationNavigationController delegatedClientNavigationController() {
        return new DefaultDelegatedAuthenticationNavigationController(this.delegatedClientAuthenticationConfigurationContext());
    }

    @Bean
    @ConditionalOnMissingBean(name={"delegatedCasWebflowExecutionPlanConfigurer"})
    public CasWebflowExecutionPlanConfigurer delegatedCasWebflowExecutionPlanConfigurer() {
        return plan -> plan.registerWebflowConfigurer(this.delegatedAuthenticationWebflowConfigurer());
    }

    @Bean
    @ConditionalOnMissingBean(name={"delegatedAuthenticationCasMultifactorWebflowCustomizer"})
    public CasMultifactorWebflowCustomizer delegatedAuthenticationCasMultifactorWebflowCustomizer() {
        return () -> List.of("delegatedAuthentication");
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"delegatedClientIdentityProviderConfigurationProducer"})
    public DelegatedClientIdentityProviderConfigurationProducer delegatedClientIdentityProviderConfigurationProducer() {
        DelegatedAuthenticationAccessStrategyHelper helper = this.getDelegatedAuthenticationAccessStrategyHelper();
        return new DefaultDelegatedClientIdentityProviderConfigurationProducer((ServicesManager)this.servicesManager.getObject(), (AuthenticationServiceSelectionPlan)this.authenticationRequestServiceSelectionStrategies.getObject(), (Clients)this.builtClients.getObject(), helper, this.casProperties, this.delegatedAuthenticationCookieGenerator(), this.delegatedClientAuthenticationRequestCustomizers());
    }

    @ConditionalOnMissingBean(name={"delegatedAuthenticationCookieGenerator"})
    @Bean
    @RefreshScope
    public CasCookieBuilder delegatedAuthenticationCookieGenerator() {
        Pac4jDelegatedAuthenticationCookieProperties props = this.casProperties.getAuthn().getPac4j().getCookie();
        return new DelegatedAuthenticationCookieGenerator(CookieUtils.buildCookieGenerationContext((CookieProperties)props));
    }

    private DelegatedAuthenticationAccessStrategyHelper getDelegatedAuthenticationAccessStrategyHelper() {
        return new DelegatedAuthenticationAccessStrategyHelper((ServicesManager)this.servicesManager.getObject(), (AuditableExecution)this.delegatedAuthenticationPolicyAuditableEnforcer.getObject());
    }
}

