/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.validation.DelegatedAuthenticationServiceTicketValidationAuthorizer;
import org.apereo.cas.validation.RegisteredServiceDelegatedAuthenticationPolicyAuditableEnforcer;
import org.apereo.cas.validation.ServiceTicketValidationAuthorizer;
import org.apereo.cas.validation.ServiceTicketValidationAuthorizerConfigurer;
import org.apereo.cas.web.flow.DelegatedAuthenticationSingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategyConfigurer;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.DelegatedAuthentication})
@AutoConfiguration
public class DelegatedAuthenticationConfiguration {

    @Configuration(value="DelegatedAuthenticationSingleSignOnConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class DelegatedAuthenticationSingleSignOnConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"pac4jDelegatedAuthenticationSingleSignOnParticipationStrategy"})
        public SingleSignOnParticipationStrategy pac4jDelegatedAuthenticationSingleSignOnParticipationStrategy(@Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationServiceSelectionPlan, @Qualifier(value="defaultTicketRegistrySupport") TicketRegistrySupport ticketRegistrySupport, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new DelegatedAuthenticationSingleSignOnParticipationStrategy(servicesManager, authenticationServiceSelectionPlan, ticketRegistrySupport);
        }

        @Bean
        @ConditionalOnMissingBean(name={"pac4jDelegatedAuthenticationSingleSignOnParticipationStrategyConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SingleSignOnParticipationStrategyConfigurer pac4jDelegatedAuthenticationSingleSignOnParticipationStrategyConfigurer(@Qualifier(value="pac4jDelegatedAuthenticationSingleSignOnParticipationStrategy") SingleSignOnParticipationStrategy pac4jDelegatedAuthenticationSingleSignOnParticipationStrategy) {
            return chain -> chain.addStrategy(pac4jDelegatedAuthenticationSingleSignOnParticipationStrategy);
        }
    }

    @Configuration(value="DelegatedAuthenticationAuthorizerConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class DelegatedAuthenticationAuthorizerConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ServiceTicketValidationAuthorizer pac4jServiceTicketValidationAuthorizer(@Qualifier(value="registeredServiceDelegatedAuthenticationPolicyAuditableEnforcer") AuditableExecution registeredServiceDelegatedAuthenticationPolicyAuditableEnforcer, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new DelegatedAuthenticationServiceTicketValidationAuthorizer(servicesManager, registeredServiceDelegatedAuthenticationPolicyAuditableEnforcer);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ServiceTicketValidationAuthorizerConfigurer pac4jServiceTicketValidationAuthorizerConfigurer(@Qualifier(value="pac4jServiceTicketValidationAuthorizer") ServiceTicketValidationAuthorizer pac4jServiceTicketValidationAuthorizer) {
            return plan -> plan.registerAuthorizer(pac4jServiceTicketValidationAuthorizer);
        }
    }

    @Configuration(value="DelegatedAuthenticationBaseConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class DelegatedAuthenticationBaseConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"registeredServiceDelegatedAuthenticationPolicyAuditableEnforcer"})
        public AuditableExecution registeredServiceDelegatedAuthenticationPolicyAuditableEnforcer() {
            return new RegisteredServiceDelegatedAuthenticationPolicyAuditableEnforcer();
        }
    }
}

