/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import lombok.Generated;
import org.apereo.cas.authentication.principal.DelegatedClientAuthenticationCredentialResolver;
import org.apereo.cas.authentication.principal.ldap.LdapDelegatedClientAuthenticationCredentialResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationLdapProfileSelectionProperties;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationConfigurationContext;
import org.ldaptive.ConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.DelegatedAuthentication})
@AutoConfiguration
@ConditionalOnClass(value={ConnectionFactory.class})
public class DelegatedAuthenticationProfileSelectionConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedAuthenticationProfileSelectionConfiguration.class);

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"ldapDelegatedClientAuthenticationCredentialResolver"})
    public DelegatedClientAuthenticationCredentialResolver ldapDelegatedClientAuthenticationCredentialResolver(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="delegatedClientAuthenticationConfigurationContext") DelegatedClientAuthenticationConfigurationContext configContext) {
        return (DelegatedClientAuthenticationCredentialResolver)BeanSupplier.of(DelegatedClientAuthenticationCredentialResolver.class).when(BeanCondition.on((String)"cas.authn.pac4j.profile-selection.ldap.ldap-url").given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            Pac4jDelegatedAuthenticationLdapProfileSelectionProperties ldap = casProperties.getAuthn().getPac4j().getProfileSelection().getLdap();
            ConnectionFactory connectionFactory = LdapUtils.newLdaptiveConnectionFactory((AbstractLdapProperties)ldap);
            LOGGER.debug("Configured LDAP delegated authentication profile selection via [{}]", (Object)ldap.getLdapUrl());
            return new LdapDelegatedClientAuthenticationCredentialResolver(configContext, connectionFactory);
        }).otherwiseProxy().get();
    }
}

