/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.actions.logout;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.http.HttpResponse;
import org.apereo.cas.authentication.principal.ClientCredential;
import org.apereo.cas.logout.slo.SingleLogoutContinuation;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.http.HttpExecutionRequest;
import org.apereo.cas.util.http.HttpUtils;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationConfigurationContext;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.pac4j.core.client.Client;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.pac4j.saml.credentials.SAML2Credentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DelegatedAuthenticationIdentityProviderLogoutAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedAuthenticationIdentityProviderLogoutAction.class);
    private final DelegatedClientAuthenticationConfigurationContext configContext;

    protected Event doExecuteInternal(RequestContext requestContext) throws Exception {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
        JEEContext webContext = new JEEContext(request, response);
        String clientName = (String)this.configContext.getDelegatedClientNameExtractor().extract((WebContext)webContext).orElseThrow(() -> new IllegalArgumentException("Unable to determine delegated client name"));
        Client client = (Client)this.configContext.getIdentityProviders().findClient(clientName).orElseThrow(() -> new IllegalArgumentException("Unable to determine delegated client for " + clientName));
        LOGGER.debug("Received logout request from [{}]", (Object)client.getName());
        ClientCredential clientCredential = (ClientCredential)WebUtils.getCredential((RequestContext)requestContext, ClientCredential.class);
        if (clientCredential != null && HttpMethod.POST.matches(request.getMethod())) {
            SAML2Credentials saml2Credentials;
            webContext.getRequestAttribute(SingleLogoutContinuation.class.getName(), SingleLogoutContinuation.class).stream().filter(continuation -> StringUtils.isNotBlank((CharSequence)continuation.getUrl())).findFirst().ifPresent(continuation -> {
                HttpExecutionRequest exec = HttpExecutionRequest.builder().method(continuation.getMethod()).url(continuation.getUrl()).parameters(continuation.getData()).build();
                LOGGER.debug("Sending delegated logout response to [{}]", (Object)exec.getUrl());
                HttpResponse logoutResponse = HttpUtils.execute((HttpExecutionRequest)exec);
                FunctionUtils.doIf((logoutResponse == null || HttpStatus.valueOf((int)logoutResponse.getCode()).isError() ? 1 : 0) != 0, r -> LOGGER.warn("Submitting logout response to [{}] failed with response [{}]", (Object)continuation.getUrl(), r)).accept(logoutResponse);
                request.removeAttribute(SingleLogoutContinuation.class.getName());
            });
            Object object = clientCredential.getCredentials();
            if (object instanceof SAML2Credentials && (object = (saml2Credentials = (SAML2Credentials)object).getContext().getMessageContext().getMessage()) instanceof LogoutRequest) {
                LogoutRequest logoutRequest = (LogoutRequest)object;
                this.removeSsoSessionsForSessionIndexes(request, response, logoutRequest);
            }
            return new Event((Object)this, "done");
        }
        return new Event((Object)this, "proceed");
    }

    private void removeSsoSessionsForSessionIndexes(HttpServletRequest request, HttpServletResponse response, LogoutRequest logoutRequest) {
        logoutRequest.getSessionIndexes().forEach(sessionIndex -> this.configContext.getTicketRegistry().getSessionsWithAttributes(Map.of("sessionindex", List.of(Objects.requireNonNull(sessionIndex.getValue())))).filter(ticket -> !ticket.isExpired()).map(TicketGrantingTicket.class::cast).findFirst().ifPresent(ticket -> this.configContext.getSingleLogoutRequestExecutor().execute(ticket.getId(), request, response)));
    }

    @Generated
    public DelegatedAuthenticationIdentityProviderLogoutAction(DelegatedClientAuthenticationConfigurationContext configContext) {
        this.configContext = configContext;
    }
}

