/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.saml2;

import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.pac4j.client.DelegatedIdentityProviders;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlUtils;
import org.opensaml.core.xml.XMLObject;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.metadata.SAML2MetadataResolver;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller(value="delegatedSaml2ClientMetadataController")
@RequestMapping
public class DelegatedSaml2ClientMetadataController {
    public static final String BASE_ENDPOINT_SERVICE_PROVIDER = "/sp";
    private final DelegatedIdentityProviders identityProviders;
    private final OpenSamlConfigBean openSamlConfigBean;

    private static ResponseEntity<String> getSaml2ClientServiceProviderMetadataResponseEntity(SAML2Client saml2Client) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_XML);
        saml2Client.init();
        String md = saml2Client.getServiceProviderMetadataResolver().getMetadata();
        return new ResponseEntity((Object)md, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }

    private static ResponseEntity<String> getNotAcceptableResponseEntity() {
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_ACCEPTABLE);
    }

    @GetMapping(value={"/sp/metadata"})
    public ResponseEntity<String> getFirstServiceProviderMetadata() {
        Optional<SAML2Client> saml2Client = this.identityProviders.findAllClients().stream().filter(SAML2Client.class::isInstance).map(SAML2Client.class::cast).findFirst();
        return saml2Client.map(DelegatedSaml2ClientMetadataController::getSaml2ClientServiceProviderMetadataResponseEntity).orElseGet(DelegatedSaml2ClientMetadataController::getNotAcceptableResponseEntity);
    }

    @GetMapping(value={"/sp/idp/metadata"})
    public ResponseEntity<String> getFirstIdentityProviderMetadata() {
        Optional<SAML2Client> saml2Client = this.identityProviders.findAllClients().stream().filter(SAML2Client.class::isInstance).map(SAML2Client.class::cast).findFirst();
        return saml2Client.map(this::getSaml2ClientIdentityProviderMetadataResponseEntity).orElseGet(DelegatedSaml2ClientMetadataController::getNotAcceptableResponseEntity);
    }

    @GetMapping(value={"/sp/{client}/metadata"})
    public ResponseEntity<String> getServiceProviderMetadataByName(@PathVariable(value="client") String client) {
        Optional saml2Client = this.identityProviders.findClient(client);
        return saml2Client.map(value -> DelegatedSaml2ClientMetadataController.getSaml2ClientServiceProviderMetadataResponseEntity((SAML2Client)value)).orElseGet(DelegatedSaml2ClientMetadataController::getNotAcceptableResponseEntity);
    }

    @GetMapping(value={"/sp/{client}/idp/metadata"})
    public ResponseEntity<String> getIdentityProviderMetadataByName(@PathVariable(value="client") String client) {
        Optional saml2Client = this.identityProviders.findClient(client);
        return saml2Client.map(value -> this.getSaml2ClientIdentityProviderMetadataResponseEntity((SAML2Client)value)).orElseGet(DelegatedSaml2ClientMetadataController::getNotAcceptableResponseEntity);
    }

    private ResponseEntity<String> getSaml2ClientIdentityProviderMetadataResponseEntity(SAML2Client saml2Client) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_XML);
        saml2Client.init();
        SAML2MetadataResolver identityProviderMetadataResolver = saml2Client.getIdentityProviderMetadataResolver();
        identityProviderMetadataResolver.resolve();
        XMLObject entity = identityProviderMetadataResolver.getEntityDescriptorElement();
        String metadata = SamlUtils.transformSamlObject((OpenSamlConfigBean)this.openSamlConfigBean, (XMLObject)entity).toString();
        return new ResponseEntity((Object)metadata, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }

    @Generated
    public DelegatedSaml2ClientMetadataController(DelegatedIdentityProviders identityProviders, OpenSamlConfigBean openSamlConfigBean) {
        this.identityProviders = identityProviders;
        this.openSamlConfigBean = openSamlConfigBean;
    }
}

