/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.actions;

import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.hc.core5.net.URIBuilder;
import org.apereo.cas.pac4j.client.DelegatedIdentityProviders;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.DelegatedClientIdentityProviderConfiguration;
import org.apereo.cas.web.flow.DelegatedClientIdentityProviderConfigurationProducer;
import org.apereo.cas.web.flow.DelegationWebflowUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.pac4j.core.client.IndirectClient;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DelegatedAuthenticationClientRetryAction
extends BaseCasWebflowAction {
    private final DelegatedIdentityProviders identityProviders;
    private final DelegatedClientIdentityProviderConfigurationProducer providerConfigurationProducer;

    protected Event doExecuteInternal(RequestContext requestContext) throws Exception {
        return (Event)FunctionUtils.doUnchecked(() -> {
            HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
            String clientName = DelegationWebflowUtils.getDelegatedAuthenticationClientName((RequestContext)requestContext);
            IndirectClient client = this.identityProviders.findClient(clientName).map(IndirectClient.class::cast).get();
            DelegatedClientIdentityProviderConfiguration config = (DelegatedClientIdentityProviderConfiguration)this.providerConfigurationProducer.produce(requestContext, client).get();
            URIBuilder urlBuilder = new URIBuilder(config.getRedirectUrl());
            urlBuilder.addParameter("ForceAuthn", Boolean.TRUE.toString());
            response.sendRedirect(urlBuilder.toString());
            return null;
        });
    }

    @Generated
    public DelegatedAuthenticationClientRetryAction(DelegatedIdentityProviders identityProviders, DelegatedClientIdentityProviderConfigurationProducer providerConfigurationProducer) {
        this.identityProviders = identityProviders;
        this.providerConfigurationProducer = providerConfigurationProducer;
    }
}

