/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.audit.AuditTrailRecordResolutionPlanConfigurer;
import org.apereo.cas.audit.DelegatedAuthenticationAuditResourceResolver;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationMetaDataPopulator;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.provision.ChainingDelegatedClientUserProfileProvisioner;
import org.apereo.cas.authentication.principal.provision.DelegatedClientUserProfileProvisioner;
import org.apereo.cas.authentication.principal.provision.GroovyDelegatedClientUserProfileProvisioner;
import org.apereo.cas.authentication.principal.provision.RestfulDelegatedClientUserProfileProvisioner;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.RestEndpointProperties;
import org.apereo.cas.configuration.model.support.cookie.CookieProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationCoreProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationProvisioningProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationRestfulProperties;
import org.apereo.cas.configuration.model.support.replication.CookieSessionReplicationProperties;
import org.apereo.cas.logout.LogoutExecutionPlanConfigurer;
import org.apereo.cas.pac4j.DistributedJEESessionStore;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.pac4j.RefreshableDelegatedClients;
import org.apereo.cas.support.pac4j.authentication.ClientAuthenticationMetaDataPopulator;
import org.apereo.cas.support.pac4j.authentication.DefaultDelegatedClientFactory;
import org.apereo.cas.support.pac4j.authentication.DelegatedClientFactory;
import org.apereo.cas.support.pac4j.authentication.DelegatedClientFactoryCustomizer;
import org.apereo.cas.support.pac4j.authentication.RestfulDelegatedClientFactory;
import org.apereo.cas.support.pac4j.authentication.handler.support.DelegatedClientAuthenticationHandler;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.util.HttpRequestUtils;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.support.CookieUtils;
import org.apereo.inspektr.audit.spi.AuditActionResolver;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.pac4j.core.client.Clients;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.JEESessionStore;
import org.pac4j.core.context.session.SessionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.io.Resource;

@Configuration(value="pac4jAuthenticationEventExecutionPlanConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class Pac4jAuthenticationEventExecutionPlanConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(Pac4jAuthenticationEventExecutionPlanConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="defaultPrincipalResolver")
    private ObjectProvider<PrincipalResolver> defaultPrincipalResolver;
    @Autowired
    @Qualifier(value="authenticationActionResolver")
    private ObjectProvider<AuditActionResolver> authenticationActionResolver;
    @Autowired
    @Qualifier(value="defaultTicketFactory")
    private ObjectProvider<TicketFactory> ticketFactory;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private ObjectProvider<CentralAuthenticationService> centralAuthenticationService;

    @Bean
    @ConditionalOnMissingBean(name={"pac4jDelegatedClientFactory"})
    @RefreshScope
    public DelegatedClientFactory pac4jDelegatedClientFactory() {
        Pac4jDelegatedAuthenticationRestfulProperties rest = this.casProperties.getAuthn().getPac4j().getRest();
        if (StringUtils.isNotBlank((CharSequence)rest.getUrl())) {
            return new RestfulDelegatedClientFactory(this.casProperties);
        }
        Collection customizers = this.applicationContext.getBeansOfType(DelegatedClientFactoryCustomizer.class, false, true).values();
        AnnotationAwareOrderComparator.sortIfNecessary(customizers);
        return new DefaultDelegatedClientFactory(this.casProperties, customizers);
    }

    @ConditionalOnMissingBean(name={"delegatedClientDistributedSessionStore"})
    @Bean
    @RefreshScope
    public SessionStore delegatedClientDistributedSessionStore() {
        boolean replicate = this.casProperties.getAuthn().getPac4j().getCore().isReplicateSessions();
        if (replicate) {
            return new DistributedJEESessionStore((CentralAuthenticationService)this.centralAuthenticationService.getObject(), (TicketFactory)this.ticketFactory.getObject(), this.delegatedClientDistributedSessionCookieGenerator());
        }
        return JEESessionStore.INSTANCE;
    }

    @ConditionalOnMissingBean(name={"delegatedClientDistributedSessionCookieGenerator"})
    @Bean
    @RefreshScope
    public CasCookieBuilder delegatedClientDistributedSessionCookieGenerator() {
        CookieSessionReplicationProperties cookie = this.casProperties.getSessionReplication().getCookie();
        return CookieUtils.buildCookieRetrievingGenerator((CookieProperties)cookie);
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"builtClients"})
    public Clients builtClients() {
        return new RefreshableDelegatedClients(this.casProperties.getServer().getLoginUrl(), this.pac4jDelegatedClientFactory());
    }

    @ConditionalOnMissingBean(name={"clientPrincipalFactory"})
    @Bean
    @RefreshScope
    public PrincipalFactory clientPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @ConditionalOnMissingBean(name={"clientAuthenticationMetaDataPopulator"})
    @Bean
    @RefreshScope
    public AuthenticationMetaDataPopulator clientAuthenticationMetaDataPopulator() {
        return new ClientAuthenticationMetaDataPopulator();
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"clientAuthenticationHandler"})
    public AuthenticationHandler clientAuthenticationHandler() {
        Pac4jDelegatedAuthenticationCoreProperties pac4j = this.casProperties.getAuthn().getPac4j().getCore();
        DelegatedClientAuthenticationHandler h = new DelegatedClientAuthenticationHandler(pac4j.getName(), pac4j.getOrder(), (ServicesManager)this.servicesManager.getObject(), this.clientPrincipalFactory(), this.builtClients(), this.clientUserProfileProvisioner(), this.delegatedClientDistributedSessionStore());
        h.setTypedIdUsed(pac4j.isTypedIdUsed());
        h.setPrincipalAttributeId(pac4j.getPrincipalAttributeId());
        return h;
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"clientUserProfileProvisioner"})
    public DelegatedClientUserProfileProvisioner clientUserProfileProvisioner() {
        Pac4jDelegatedAuthenticationProvisioningProperties provisioning = this.casProperties.getAuthn().getPac4j().getProvisioning();
        ChainingDelegatedClientUserProfileProvisioner chain = new ChainingDelegatedClientUserProfileProvisioner();
        Resource script = provisioning.getGroovy().getLocation();
        if (script != null) {
            chain.addProvisioner((DelegatedClientUserProfileProvisioner)new GroovyDelegatedClientUserProfileProvisioner(script));
        }
        if (StringUtils.isNotBlank((CharSequence)provisioning.getRest().getUrl())) {
            chain.addProvisioner((DelegatedClientUserProfileProvisioner)new RestfulDelegatedClientUserProfileProvisioner((RestEndpointProperties)provisioning.getRest()));
        }
        if (chain.isEmpty()) {
            return DelegatedClientUserProfileProvisioner.noOp();
        }
        return chain;
    }

    @ConditionalOnMissingBean(name={"pac4jAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    @RefreshScope
    public AuthenticationEventExecutionPlanConfigurer pac4jAuthenticationEventExecutionPlanConfigurer() {
        return plan -> {
            if (!this.builtClients().findAllClients().isEmpty()) {
                LOGGER.info("Registering delegated authentication clients...");
                plan.registerAuthenticationHandlerWithPrincipalResolver(this.clientAuthenticationHandler(), (PrincipalResolver)this.defaultPrincipalResolver.getObject());
                plan.registerAuthenticationMetadataPopulator(this.clientAuthenticationMetaDataPopulator());
            }
        };
    }

    @ConditionalOnMissingBean(name={"delegatedAuthenticationAuditResourceResolver"})
    @Bean
    @RefreshScope
    public AuditResourceResolver delegatedAuthenticationAuditResourceResolver() {
        return new DelegatedAuthenticationAuditResourceResolver();
    }

    @Bean
    @ConditionalOnMissingBean(name={"delegatedAuthenticationAuditTrailRecordResolutionPlanConfigurer"})
    @RefreshScope
    public AuditTrailRecordResolutionPlanConfigurer delegatedAuthenticationAuditTrailRecordResolutionPlanConfigurer() {
        return plan -> {
            plan.registerAuditActionResolver("DELEGATED_CLIENT_ACTION_RESOLVER", (AuditActionResolver)this.authenticationActionResolver.getObject());
            plan.registerAuditResourceResolver("DELEGATED_CLIENT_RESOURCE_RESOLVER", this.delegatedAuthenticationAuditResourceResolver());
        };
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"delegatedAuthenticationLogoutExecutionPlanConfigurer"})
    public LogoutExecutionPlanConfigurer delegatedAuthenticationLogoutExecutionPlanConfigurer() {
        return plan -> {
            boolean replicate = this.casProperties.getAuthn().getPac4j().getCore().isReplicateSessions();
            if (replicate) {
                plan.registerLogoutPostProcessor(ticketGrantingTicket -> {
                    HttpServletRequest request = HttpRequestUtils.getHttpServletRequestFromRequestAttributes();
                    HttpServletResponse response = HttpRequestUtils.getHttpServletResponseFromRequestAttributes();
                    if (request != null && response != null) {
                        SessionStore store = this.delegatedClientDistributedSessionStore();
                        store.destroySession((WebContext)new JEEContext(request, response));
                    }
                });
            }
        };
    }
}

