/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.github.scribejava.core.model.OAuth1RequestToken;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.validation.DelegatedAuthenticationServiceTicketValidationAuthorizer;
import org.apereo.cas.validation.RegisteredServiceDelegatedAuthenticationPolicyAuditableEnforcer;
import org.apereo.cas.validation.ServiceTicketValidationAuthorizer;
import org.apereo.cas.validation.ServiceTicketValidationAuthorizerConfigurer;
import org.apereo.cas.web.flow.DelegatedAuthenticationSingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategyConfigurer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="pac4jDelegatedAuthenticationConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class Pac4jDelegatedAuthenticationConfiguration {
    @Autowired
    @Qualifier(value="defaultTicketRegistrySupport")
    private ObjectProvider<TicketRegistrySupport> ticketRegistrySupport;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="authenticationServiceSelectionPlan")
    private ObjectProvider<AuthenticationServiceSelectionPlan> authenticationServiceSelectionPlan;

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"registeredServiceDelegatedAuthenticationPolicyAuditableEnforcer"})
    public AuditableExecution registeredServiceDelegatedAuthenticationPolicyAuditableEnforcer() {
        return new RegisteredServiceDelegatedAuthenticationPolicyAuditableEnforcer();
    }

    @Bean
    @ConditionalOnMissingBean(name={"pac4jJacksonModule"})
    public Module pac4jJacksonModule() {
        SimpleModule module = new SimpleModule();
        module.setMixInAnnotation(OAuth1RequestToken.class, AbstractOAuth1RequestTokenMixin.class);
        return module;
    }

    @Bean
    @RefreshScope
    public ServiceTicketValidationAuthorizer pac4jServiceTicketValidationAuthorizer() {
        return new DelegatedAuthenticationServiceTicketValidationAuthorizer((ServicesManager)this.servicesManager.getObject(), this.registeredServiceDelegatedAuthenticationPolicyAuditableEnforcer());
    }

    @Bean
    @RefreshScope
    public ServiceTicketValidationAuthorizerConfigurer pac4jServiceTicketValidationAuthorizerConfigurer() {
        return plan -> plan.registerAuthorizer(this.pac4jServiceTicketValidationAuthorizer());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"pac4jDelegatedAuthenticationSingleSignOnParticipationStrategy"})
    public SingleSignOnParticipationStrategy pac4jDelegatedAuthenticationSingleSignOnParticipationStrategy() {
        return new DelegatedAuthenticationSingleSignOnParticipationStrategy((ServicesManager)this.servicesManager.getObject(), (AuthenticationServiceSelectionPlan)this.authenticationServiceSelectionPlan.getObject(), (TicketRegistrySupport)this.ticketRegistrySupport.getObject());
    }

    @Bean
    @ConditionalOnMissingBean(name={"pac4jDelegatedAuthenticationSingleSignOnParticipationStrategyConfigurer"})
    @RefreshScope
    public SingleSignOnParticipationStrategyConfigurer pac4jDelegatedAuthenticationSingleSignOnParticipationStrategyConfigurer() {
        return chain -> chain.addStrategy(this.pac4jDelegatedAuthenticationSingleSignOnParticipationStrategy());
    }

    private static abstract class AbstractOAuth1RequestTokenMixin
    extends OAuth1RequestToken {
        private static final long serialVersionUID = -7839084408338396531L;

        @JsonCreator
        AbstractOAuth1RequestTokenMixin(@JsonProperty(value="token") String token, @JsonProperty(value="tokenSecret") String tokenSecret, @JsonProperty(value="oauthCallbackConfirmed") boolean oauthCallbackConfirmed, @JsonProperty(value="rawResponse") String rawResponse) {
            super(token, tokenSecret, oauthCallbackConfirmed, rawResponse);
        }

        @JsonIgnore
        public abstract boolean isEmpty();
    }
}

