/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.config;

import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.captcha.GoogleRecaptchaProperties;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.pm.PasswordValidationService;
import org.apereo.cas.pm.web.flow.PasswordManagementCaptchaWebflowConfigurer;
import org.apereo.cas.pm.web.flow.PasswordManagementSingleSignOnParticipationStrategy;
import org.apereo.cas.pm.web.flow.PasswordManagementWebflowConfigurer;
import org.apereo.cas.pm.web.flow.actions.HandlePasswordExpirationWarningMessagesAction;
import org.apereo.cas.pm.web.flow.actions.InitPasswordChangeAction;
import org.apereo.cas.pm.web.flow.actions.InitPasswordResetAction;
import org.apereo.cas.pm.web.flow.actions.PasswordChangeAction;
import org.apereo.cas.pm.web.flow.actions.SendPasswordResetInstructionsAction;
import org.apereo.cas.pm.web.flow.actions.ValidatePasswordResetTokenAction;
import org.apereo.cas.pm.web.flow.actions.VerifyPasswordResetRequestAction;
import org.apereo.cas.pm.web.flow.actions.VerifySecurityQuestionsAction;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.web.CaptchaValidator;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.InitializeCaptchaAction;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategyConfigurer;
import org.apereo.cas.web.flow.ValidateCaptchaAction;
import org.apereo.cas.web.flow.actions.StaticEventExecutionAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.mvc.servlet.FlowHandler;
import org.springframework.webflow.mvc.servlet.FlowHandlerAdapter;

@Configuration(value="passwordManagementWebflowConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class PasswordManagementWebflowConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PasswordManagementWebflowConfiguration.class);
    @Autowired
    @Qualifier(value="defaultTicketRegistrySupport")
    private ObjectProvider<TicketRegistrySupport> ticketRegistrySupport;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="authenticationServiceSelectionPlan")
    private ObjectProvider<AuthenticationServiceSelectionPlan> authenticationServiceSelectionPlan;
    @Autowired
    @Qualifier(value="defaultPrincipalResolver")
    private ObjectProvider<PrincipalResolver> defaultPrincipalResolver;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private ObjectProvider<CentralAuthenticationService> centralAuthenticationService;
    @Autowired
    @Qualifier(value="ticketRegistry")
    private ObjectProvider<TicketRegistry> ticketRegistry;
    @Autowired
    @Qualifier(value="communicationsManager")
    private ObjectProvider<CommunicationsManager> communicationsManager;
    @Autowired
    private ObjectProvider<FlowBuilderServices> flowBuilderServices;
    @Autowired
    @Qualifier(value="loginFlowRegistry")
    private ObjectProvider<FlowDefinitionRegistry> loginFlowDefinitionRegistry;
    @Autowired
    @Qualifier(value="loginFlowExecutor")
    private ObjectProvider<FlowExecutor> loginFlowExecutor;
    @Autowired
    @Qualifier(value="defaultTicketFactory")
    private ObjectProvider<TicketFactory> ticketFactory;
    @Autowired
    @Qualifier(value="passwordValidationService")
    private ObjectProvider<PasswordValidationService> passwordValidationService;
    @Autowired
    @Qualifier(value="passwordChangeService")
    private ObjectProvider<PasswordManagementService> passwordManagementService;

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"passwordManagementSingleSignOnParticipationStrategy"})
    public SingleSignOnParticipationStrategy passwordManagementSingleSignOnParticipationStrategy() {
        return new PasswordManagementSingleSignOnParticipationStrategy((ServicesManager)this.servicesManager.getObject(), (TicketRegistrySupport)this.ticketRegistrySupport.getObject(), (AuthenticationServiceSelectionPlan)this.authenticationServiceSelectionPlan.getObject(), (CentralAuthenticationService)this.centralAuthenticationService.getObject());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"passwordManagementSingleSignOnParticipationStrategyConfigurer"})
    public SingleSignOnParticipationStrategyConfigurer passwordManagementSingleSignOnParticipationStrategyConfigurer() {
        return chain -> chain.addStrategy(this.passwordManagementSingleSignOnParticipationStrategy());
    }

    @RefreshScope
    @Bean
    public HandlerAdapter passwordResetHandlerAdapter() {
        FlowHandlerAdapter handler = new FlowHandlerAdapter(){

            public boolean supports(Object handler) {
                return super.supports(handler) && ((FlowHandler)handler).getFlowId().equals("pswdreset");
            }
        };
        handler.setFlowExecutor((FlowExecutor)this.loginFlowExecutor.getObject());
        return handler;
    }

    @ConditionalOnMissingBean(name={"initPasswordChangeAction"})
    @RefreshScope
    @Bean
    public Action initPasswordChangeAction() {
        return new InitPasswordChangeAction(this.casProperties);
    }

    @ConditionalOnMissingBean(name={"initPasswordResetAction"})
    @RefreshScope
    @Bean
    public Action initPasswordResetAction() {
        return new InitPasswordResetAction((PasswordManagementService)this.passwordManagementService.getObject());
    }

    @ConditionalOnMissingBean(name={"passwordChangeAction"})
    @RefreshScope
    @Bean
    public Action passwordChangeAction() {
        return new PasswordChangeAction((PasswordManagementService)this.passwordManagementService.getObject(), (PasswordValidationService)this.passwordValidationService.getObject());
    }

    @ConditionalOnMissingBean(name={"sendPasswordResetInstructionsAction"})
    @Bean
    @RefreshScope
    public Action sendPasswordResetInstructionsAction() {
        return new SendPasswordResetInstructionsAction(this.casProperties, (CommunicationsManager)this.communicationsManager.getObject(), (PasswordManagementService)this.passwordManagementService.getObject(), (TicketRegistry)this.ticketRegistry.getObject(), (TicketFactory)this.ticketFactory.getObject(), (PrincipalResolver)this.defaultPrincipalResolver.getObject());
    }

    @ConditionalOnMissingBean(name={"verifyPasswordResetRequestAction"})
    @Bean
    @RefreshScope
    public Action verifyPasswordResetRequestAction() {
        return new VerifyPasswordResetRequestAction(this.casProperties, (PasswordManagementService)this.passwordManagementService.getObject(), (CentralAuthenticationService)this.centralAuthenticationService.getObject());
    }

    @ConditionalOnMissingBean(name={"handlePasswordExpirationWarningMessagesAction"})
    @Bean
    @RefreshScope
    public Action handlePasswordExpirationWarningMessagesAction() {
        return new HandlePasswordExpirationWarningMessagesAction();
    }

    @ConditionalOnMissingBean(name={"verifySecurityQuestionsAction"})
    @Bean
    @RefreshScope
    public Action verifySecurityQuestionsAction() {
        if (!this.casProperties.getAuthn().getPm().getReset().isSecurityQuestionsEnabled()) {
            LOGGER.debug("Functionality to handle security questions for password management is not enabled");
            return new StaticEventExecutionAction("success");
        }
        return new VerifySecurityQuestionsAction((PasswordManagementService)this.passwordManagementService.getObject());
    }

    @ConditionalOnMissingBean(name={"validatePasswordResetTokenAction"})
    @Bean
    @RefreshScope
    public Action validatePasswordResetTokenAction() {
        return new ValidatePasswordResetTokenAction((PasswordManagementService)this.passwordManagementService.getObject(), (CentralAuthenticationService)this.centralAuthenticationService.getObject());
    }

    @ConditionalOnMissingBean(name={"passwordManagementWebflowConfigurer"})
    @RefreshScope
    @Bean
    @DependsOn(value={"defaultWebflowConfigurer"})
    public CasWebflowConfigurer passwordManagementWebflowConfigurer() {
        return new PasswordManagementWebflowConfigurer((FlowBuilderServices)this.flowBuilderServices.getObject(), (FlowDefinitionRegistry)this.loginFlowDefinitionRegistry.getObject(), this.applicationContext, this.casProperties);
    }

    @Bean
    @ConditionalOnMissingBean(name={"passwordManagementCasWebflowExecutionPlanConfigurer"})
    public CasWebflowExecutionPlanConfigurer passwordManagementCasWebflowExecutionPlanConfigurer() {
        return plan -> plan.registerWebflowConfigurer(this.passwordManagementWebflowConfigurer());
    }

    @ConditionalOnProperty(prefix="cas.authn.pm.google-recaptcha", name={"enabled"}, havingValue="true")
    @Configuration(value="passwordManagementCaptchaConfiguration", proxyBeanMethods=false)
    @DependsOn(value={"passwordManagementWebflowConfigurer"})
    public class PasswordManagementCaptchaConfiguration {
        @ConditionalOnMissingBean(name={"passwordManagementCaptchaWebflowConfigurer"})
        @RefreshScope
        @Bean
        public CasWebflowConfigurer passwordManagementCaptchaWebflowConfigurer() {
            PasswordManagementCaptchaWebflowConfigurer configurer = new PasswordManagementCaptchaWebflowConfigurer((FlowBuilderServices)PasswordManagementWebflowConfiguration.this.flowBuilderServices.getObject(), (FlowDefinitionRegistry)PasswordManagementWebflowConfiguration.this.loginFlowDefinitionRegistry.getObject(), PasswordManagementWebflowConfiguration.this.applicationContext, PasswordManagementWebflowConfiguration.this.casProperties);
            configurer.setOrder(PasswordManagementWebflowConfiguration.this.casProperties.getAuthn().getPm().getWebflow().getOrder() + 1);
            return configurer;
        }

        @ConditionalOnMissingBean(name={"passwordResetValidateCaptchaAction"})
        @RefreshScope
        @Bean
        public Action passwordResetValidateCaptchaAction() {
            GoogleRecaptchaProperties recaptcha = PasswordManagementWebflowConfiguration.this.casProperties.getAuthn().getPm().getGoogleRecaptcha();
            return new ValidateCaptchaAction(CaptchaValidator.getInstance((GoogleRecaptchaProperties)recaptcha));
        }

        @RefreshScope
        @Bean
        @ConditionalOnMissingBean(name={"passwordResetInitializeCaptchaAction"})
        public Action passwordResetInitializeCaptchaAction() {
            final GoogleRecaptchaProperties recaptcha = PasswordManagementWebflowConfiguration.this.casProperties.getAuthn().getPm().getGoogleRecaptcha();
            return new InitializeCaptchaAction(recaptcha){

                protected Event doExecute(RequestContext requestContext) {
                    WebUtils.putRecaptchaPasswordManagementEnabled((RequestContext)requestContext, (GoogleRecaptchaProperties)recaptcha);
                    return super.doExecute(requestContext);
                }
            };
        }

        @Bean
        @Autowired
        @ConditionalOnMissingBean(name={"passwordManagementCaptchaWebflowExecutionPlanConfigurer"})
        public CasWebflowExecutionPlanConfigurer passwordManagementCaptchaWebflowExecutionPlanConfigurer(@Qualifier(value="passwordManagementCaptchaWebflowConfigurer") CasWebflowConfigurer cfg) {
            return plan -> plan.registerWebflowConfigurer(cfg);
        }
    }
}

