/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.pm.PasswordManagementProperties;
import org.apereo.cas.pm.PasswordManagementQuery;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.pm.web.flow.PasswordManagementWebflowUtils;
import org.apereo.cas.pm.web.flow.actions.BasePasswordManagementAction;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class VerifyPasswordResetRequestAction
extends BasePasswordManagementAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(VerifyPasswordResetRequestAction.class);
    public static final String EVENT_ID_SECURITY_QUESTIONS_DISABLED = "questionsDisabled";
    private final CasConfigurationProperties casProperties;
    private final PasswordManagementService passwordManagementService;
    private final CentralAuthenticationService centralAuthenticationService;

    protected Event doExecute(RequestContext requestContext) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        String transientTicket = request.getParameter("pswdrst");
        if (StringUtils.isBlank((CharSequence)transientTicket)) {
            LOGGER.error("Password reset token is missing");
            return this.error();
        }
        try {
            TransientSessionTicket tst = (TransientSessionTicket)this.centralAuthenticationService.getTicket(transientTicket, TransientSessionTicket.class);
            String token = tst.getProperties().get("token").toString();
            String username = this.passwordManagementService.parseToken(token);
            this.centralAuthenticationService.deleteTicket(tst.getId());
            PasswordManagementQuery query = PasswordManagementQuery.builder().username(username).build();
            PasswordManagementWebflowUtils.putPasswordResetToken(requestContext, token);
            PasswordManagementProperties pm = this.casProperties.getAuthn().getPm();
            if (pm.getReset().isSecurityQuestionsEnabled()) {
                List<String> questions = VerifyPasswordResetRequestAction.canonicalizeSecurityQuestions(this.passwordManagementService.getSecurityQuestions(query));
                if (questions.isEmpty()) {
                    LOGGER.warn("No security questions could be found for [{}]", (Object)username);
                    return this.error();
                }
                PasswordManagementWebflowUtils.putPasswordResetSecurityQuestions(requestContext, questions);
            } else {
                LOGGER.debug("Security questions are not enabled");
            }
            PasswordManagementWebflowUtils.putPasswordResetUsername(requestContext, username);
            PasswordManagementWebflowUtils.putPasswordResetSecurityQuestionsEnabled(requestContext, pm.getReset().isSecurityQuestionsEnabled());
            if (pm.getReset().isSecurityQuestionsEnabled()) {
                return this.success();
            }
            return new EventFactorySupport().event((Object)this, EVENT_ID_SECURITY_QUESTIONS_DISABLED);
        }
        catch (Exception e) {
            LOGGER.error("Password reset token could not be verified: [{}]", (Object)e.getMessage());
            return this.error();
        }
    }

    @Generated
    public VerifyPasswordResetRequestAction(CasConfigurationProperties casProperties, PasswordManagementService passwordManagementService, CentralAuthenticationService centralAuthenticationService) {
        this.casProperties = casProperties;
        this.passwordManagementService = passwordManagementService;
        this.centralAuthenticationService = centralAuthenticationService;
    }
}

