/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow;

import java.util.Map;
import java.util.stream.Stream;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.pm.PasswordManagementProperties;
import org.apereo.cas.pm.PasswordChangeRequest;
import org.apereo.cas.pm.WeakPasswordException;
import org.apereo.cas.web.flow.StringToCharArrayConverter;
import org.apereo.cas.web.flow.actions.ConsumerExecutionAction;
import org.apereo.cas.web.flow.actions.StaticEventExecutionAction;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.action.EvaluateAction;
import org.springframework.webflow.action.SetAction;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.EndState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.State;
import org.springframework.webflow.engine.SubflowState;
import org.springframework.webflow.engine.TransitionSet;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.builder.BinderConfiguration;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.RequestContext;

public class PasswordManagementWebflowConfigurer
extends AbstractCasWebflowConfigurer {
    public static final String FLOW_VAR_ID_PASSWORD = "password";

    public PasswordManagementWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry loginFlowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
        this.setOrder(casProperties.getAuthn().getPm().getWebflow().getOrder());
    }

    protected void doInitialize() {
        Flow flow = this.getLoginFlow();
        this.createAccountStatusViewStates(flow);
    }

    public void postInitialization(ConfigurableApplicationContext applicationContext) {
        PasswordManagementProperties pm = this.casProperties.getAuthn().getPm();
        Flow flow = this.getLoginFlow();
        if (pm.getCore().isEnabled()) {
            Map providerMap = MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders((ApplicationContext)this.applicationContext);
            ActionState sendAccountInfoState = (ActionState)this.getState(flow, "sendPasswordResetInstructions", ActionState.class);
            providerMap.forEach((id, provider) -> {
                if (this.containsSubflowState(flow, provider.getId())) {
                    SubflowState mfaSubflowState = (SubflowState)this.getState(flow, provider.getId(), SubflowState.class);
                    this.createTransitionForState((TransitionableState)mfaSubflowState, "resumePasswordReset", "sendPasswordResetInstructions");
                    this.createTransitionForState((TransitionableState)sendAccountInfoState, provider.getId(), mfaSubflowState.getId());
                }
            });
        }
    }

    private void createAccountStatusViewStates(Flow flow) {
        this.enablePasswordManagementForFlow(flow);
        this.createViewState(flow, "casAuthenticationBlockedView", "login-error/casAuthenticationBlockedView");
        this.createViewState(flow, "casBadWorkstationView", "login-error/casBadWorkstationView");
        this.createViewState(flow, "casBadHoursView", "login-error/casBadHoursView");
        this.createViewState(flow, "casPasswordUpdateSuccess", "password-reset/casPasswordUpdateSuccessView");
        this.createViewState(flow, "casAccountLockedView", "login-error/casAccountLockedView");
        this.createViewState(flow, "casAccountDisabledView", "login-error/casAccountDisabledView");
        PasswordManagementProperties pm = this.casProperties.getAuthn().getPm();
        if (pm.getCore().isEnabled()) {
            this.configurePasswordManagementWebflow(flow);
        } else {
            ViewState expiredState = this.createViewState(flow, "casExpiredPassView", "login-error/casExpiredPassView");
            expiredState.getEntryActionList().add((Action)this.createEvaluateAction("initPasswordChangeAction"));
            ViewState mustChangeState = this.createViewState(flow, "casMustChangePassView", "login-error/casMustChangePassView");
            mustChangeState.getEntryActionList().add((Action)this.createEvaluateAction("initPasswordChangeAction"));
        }
    }

    private void configurePasswordManagementWebflow(Flow flow) {
        this.configurePasswordResetFlow(flow, "casExpiredPassView", "login-error/casExpiredPassView");
        this.configurePasswordResetFlow(flow, "casMustChangePassView", "login-error/casMustChangePassView");
        this.configurePasswordMustChangeForAuthnWarnings(flow);
        this.configurePasswordExpirationWarning(flow);
        this.createPasswordResetFlow();
        ActionState startState = (ActionState)flow.getStartState();
        this.prependActionsToActionStateExecutionList(flow, startState.getId(), new String[]{"validatePasswordResetTokenAction"});
        this.createTransitionForState((TransitionableState)startState, "resumePasswordReset", "sendPasswordResetInstructions");
        this.createTransitionForState((TransitionableState)startState, "resetPassword", "pswdResetSubflow");
        this.createTransitionForState((TransitionableState)startState, "invalidPasswordResetToken", "passwordResetErrorView");
        this.createViewState(flow, "passwordResetErrorView", "password-reset/casResetPasswordErrorView");
        ViewState accountLockedState = (ViewState)this.getState(flow, "casAccountLockedView", ViewState.class);
        ViewState accountDisabledState = (ViewState)this.getState(flow, "casAccountDisabledView", ViewState.class);
        SetAction enableUnlockAction = this.createSetAction("viewScope.enableAccountUnlock", "true");
        Stream.of(accountLockedState, accountDisabledState).forEach(state -> {
            state.getRenderActionList().add((Action)enableUnlockAction);
            state.getEntryActionList().add((Action)this.createEvaluateAction("accountUnlockStatusPrepareAction"));
        });
        EndState unlockedView = this.createEndState(flow, "casAccountUnlockedView", "login-error/casAccountUnlockedView");
        this.createTransitionForState((TransitionableState)accountLockedState, "submit", "unlockAccountStatus");
        ActionState unlockAction = this.createActionState(flow, "unlockAccountStatus", new String[]{"accountUnlockStatusAction"});
        this.createTransitionForState((TransitionableState)unlockAction, "success", unlockedView.getId());
        this.createTransitionForState((TransitionableState)unlockAction, "error", accountLockedState.getId());
        this.createTransitionForState((TransitionableState)accountDisabledState, "submit", "enableAccountStatus");
        ActionState enableAction = this.createActionState(flow, "enableAccountStatus", new String[]{"accountUnlockStatusAction"});
        this.createTransitionForState((TransitionableState)enableAction, "success", unlockedView.getId());
        this.createTransitionForState((TransitionableState)enableAction, "error", accountDisabledState.getId());
        ActionState authnFailure = (ActionState)this.getState(flow, "handleAuthenticationFailure", ActionState.class);
        this.insertTransitionForState((TransitionableState)authnFailure, WeakPasswordException.class.getSimpleName(), "weakPasswordDetectedView");
        ViewState weakPasswordView = this.createViewState(flow, "weakPasswordDetectedView", "password-reset/casWeakPasswordDetectedView");
        this.createTransitionForState((TransitionableState)weakPasswordView, "continue", "casMustChangePassView");
    }

    private void configurePasswordExpirationWarning(Flow flow) {
        TransitionableState warningState = this.getTransitionableState(flow, "showAuthenticationWarningMessages");
        warningState.getEntryActionList().add((Action)this.createEvaluateAction("handlePasswordExpirationWarningMessagesAction"));
    }

    private void configurePasswordMustChangeForAuthnWarnings(Flow flow) {
        TransitionableState warningState = this.getTransitionableState(flow, "showAuthenticationWarningMessages");
        warningState.getEntryActionList().add((Action)this.createEvaluateAction("flowScope.pswdChangePostLogin=true"));
        this.createTransitionForState(warningState, "changePassword", "casMustChangePassView");
    }

    private void createPasswordResetFlow() {
        Flow flow = this.getLoginFlow();
        if (flow != null) {
            boolean autoLogin = this.casProperties.getAuthn().getPm().getCore().isAutoLogin();
            ViewState state = (ViewState)this.getState(flow, "viewLoginForm", ViewState.class);
            this.createTransitionForState((TransitionableState)state, "resetPassword", "casResetPasswordSendInstructionsView");
            ViewState viewState = this.createViewState(flow, "casResetPasswordSendInstructionsView", "password-reset/casResetPasswordSendInstructionsView");
            this.createTransitionForState((TransitionableState)viewState, "findAccount", "sendPasswordResetInstructions");
            ActionState sendAccountInfoState = this.createActionState(flow, "sendPasswordResetInstructions", new String[]{"sendPasswordResetInstructionsAction"});
            this.createTransitionForState((TransitionableState)sendAccountInfoState, "success", "casResetPasswordSentInstructionsView");
            this.createTransitionForState((TransitionableState)sendAccountInfoState, "error", viewState.getId());
            this.createViewState(flow, "casResetPasswordSentInstructionsView", "password-reset/casResetPasswordSentInstructionsView");
            this.registerPasswordResetFlowDefinition();
            ActionState initializeLoginFormState = (ActionState)this.getState(flow, "initializeLoginForm", ActionState.class);
            String originalTargetState = initializeLoginFormState.getTransition("success").getTargetStateId();
            SubflowState pswdResetSubFlowState = this.createSubflowState(flow, "pswdResetSubflow", "pswdreset");
            TransitionableState createTgt = this.getTransitionableState(flow, "createTicketGrantingTicket");
            EvaluateAction setAction = this.createEvaluateAction(String.join((CharSequence)"doChangePassword", "flowScope.", " = requestParameters.", " != null"));
            createTgt.getEntryActionList().add((Action)setAction);
            this.createDecisionState(flow, "checkForPswdResetToken", "requestParameters.pswdrst != null", "pswdResetSubflow", originalTargetState);
            this.createTransitionForState((TransitionableState)initializeLoginFormState, "success", "checkForPswdResetToken", true);
            ActionState redirect = this.createActionState(flow, "redirectToLogin", StaticEventExecutionAction.SUCCESS);
            this.createStateDefaultTransition((TransitionableState)redirect, flow.getStartState().getId());
            this.createTransitionForState((TransitionableState)pswdResetSubFlowState, "pswdResetComplete", autoLogin ? "realSubmit" : "redirectToLogin");
            this.createDecisionState(flow, "checkDoChangePassword", "flowScope.doChangePassword == true", "casMustChangePassView", createTgt.getTransition("success").getTargetStateId()).getEntryActionList().add((Action)this.createEvaluateAction("flowScope.pswdChangePostLogin=true"));
            this.createTransitionForState(createTgt, "success", "checkDoChangePassword", true);
            this.createDecisionState(flow, "postLoginPswdChangeCheck", "flowScope.pswdChangePostLogin == true", this.getTransitionableState(flow, "showAuthenticationWarningMessages").getTransition("proceed").getTargetStateId(), autoLogin ? "realSubmit" : "redirectToLogin");
            this.createTransitionForState(this.getTransitionableState(flow, "casPasswordUpdateSuccess"), "proceed", "postLoginPswdChangeCheck");
        }
    }

    private void registerPasswordResetFlowDefinition() {
        Flow pswdFlow = this.buildFlow("pswdreset");
        pswdFlow.getStartActionList().add((Action)this.createEvaluateAction("initialFlowSetupAction"));
        ActionState initReset = this.createActionState(pswdFlow, "initPasswordReset", new String[]{"initPasswordResetAction"});
        this.createStateDefaultTransition((TransitionableState)initReset, "casMustChangePassView");
        ActionState verifyQuestions = this.createActionState(pswdFlow, "verifySecurityQuestions", new String[]{"verifySecurityQuestionsAction"});
        this.createTransitionForState((TransitionableState)verifyQuestions, "success", "initPasswordReset");
        this.createTransitionForState((TransitionableState)verifyQuestions, "error", "passwordResetErrorView");
        ActionState verifyRequest = this.createActionState(pswdFlow, "verifyPasswordResetRequest", new String[]{"verifyPasswordResetRequestAction"});
        this.createTransitionForState((TransitionableState)verifyRequest, "success", "getSecurityQuestionsView");
        this.createTransitionForState((TransitionableState)verifyRequest, "error", "passwordResetErrorView");
        this.createTransitionForState((TransitionableState)verifyRequest, "questionsDisabled", "initPasswordReset");
        ViewState questionsView = this.createViewState(pswdFlow, "getSecurityQuestionsView", "password-reset/casResetPasswordVerifyQuestionsView");
        this.createTransitionForState((TransitionableState)questionsView, "submit", "verifySecurityQuestions", Map.of("bind", Boolean.FALSE, "validate", Boolean.FALSE));
        this.enablePasswordManagementForFlow(pswdFlow);
        this.createViewState(pswdFlow, "passwordResetErrorView", "password-reset/casResetPasswordErrorView");
        this.createViewState(pswdFlow, "casPasswordUpdateSuccess", "password-reset/casPasswordUpdateSuccessView");
        this.configurePasswordResetFlow(pswdFlow, "casMustChangePassView", "login-error/casMustChangePassView");
        pswdFlow.setStartState((State)verifyRequest);
        this.mainFlowDefinitionRegistry.registerFlowDefinition((FlowDefinition)pswdFlow);
        this.createEndState(pswdFlow, "pswdResetComplete");
        this.createTransitionForState(this.getTransitionableState(pswdFlow, "casPasswordUpdateSuccess"), "proceed", "pswdResetComplete");
    }

    private void enablePasswordManagementForFlow(Flow flow) {
        ConsumerExecutionAction action = new ConsumerExecutionAction(context -> {
            WebUtils.putAccountProfileManagementEnabled((RequestContext)context, (Boolean)this.applicationContext.containsBean("accountProfileFlowRegistry"));
            WebUtils.putPasswordManagementEnabled((RequestContext)context, (Boolean)this.casProperties.getAuthn().getPm().getCore().isEnabled());
            WebUtils.putForgotUsernameEnabled((RequestContext)context, (Boolean)this.casProperties.getAuthn().getPm().getForgotUsername().isEnabled());
        });
        flow.getStartActionList().add((Action)action);
    }

    private void configurePasswordResetFlow(Flow flow, String id, String viewId) {
        this.createFlowVariable(flow, FLOW_VAR_ID_PASSWORD, PasswordChangeRequest.class);
        Map<String, Map<String, String>> propertiesToBind = Map.of(FLOW_VAR_ID_PASSWORD, Map.of("converter", StringToCharArrayConverter.ID), "confirmedPassword", Map.of("converter", StringToCharArrayConverter.ID));
        BinderConfiguration binder = this.createStateBinderConfiguration(propertiesToBind);
        ViewState viewState = this.createViewState(flow, id, viewId, binder);
        this.createStateModelBinding((TransitionableState)viewState, FLOW_VAR_ID_PASSWORD, PasswordChangeRequest.class);
        viewState.getEntryActionList().add((Action)this.createEvaluateAction("initPasswordChangeAction"));
        this.createTransitionForState((TransitionableState)viewState, "submit", "passwordChangeAction", Map.of("bind", Boolean.TRUE, "validate", Boolean.TRUE));
        this.createStateDefaultTransition((TransitionableState)viewState, id);
        ActionState pswChangeAction = this.createActionState(flow, "passwordChangeAction", (Action)this.createEvaluateAction("passwordChangeAction"));
        TransitionSet transitionSet = pswChangeAction.getTransitionSet();
        transitionSet.add(this.createTransition("passwordUpdateSuccess", "casPasswordUpdateSuccess"));
        transitionSet.add(this.createTransition("error", id));
    }
}

