/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.pm.InvalidPasswordException;
import org.apereo.cas.pm.PasswordChangeRequest;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.pm.PasswordValidationService;
import org.apereo.cas.pm.web.flow.PasswordManagementWebflowUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class PasswordChangeAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PasswordChangeAction.class);
    private static final String PASSWORD_VALIDATION_FAILURE_CODE = "pm.validationFailure";
    private static final String DEFAULT_MESSAGE = "Could not update the account password";
    private final PasswordManagementService passwordManagementService;
    private final PasswordValidationService passwordValidationService;

    protected static PasswordChangeRequest getPasswordChangeRequest(RequestContext requestContext) {
        PasswordChangeRequest bean = (PasswordChangeRequest)requestContext.getFlowScope().get("password", PasswordChangeRequest.class);
        bean.setUsername(PasswordManagementWebflowUtils.getPasswordResetUsername(requestContext));
        return bean;
    }

    protected Event doExecuteInternal(RequestContext requestContext) {
        try {
            PasswordChangeRequest bean = PasswordChangeAction.getPasswordChangeRequest(requestContext);
            Optional.ofNullable((UsernamePasswordCredential)WebUtils.getCredential((RequestContext)requestContext, UsernamePasswordCredential.class)).ifPresent(credential -> bean.setCurrentPassword(credential.getPassword()));
            LOGGER.debug("Attempting to validate the password change bean for username [{}]", (Object)bean.getUsername());
            if (StringUtils.isBlank((CharSequence)bean.getUsername()) || !this.passwordValidationService.isValid(bean)) {
                LOGGER.error("Failed to validate the provided password");
                return this.getErrorEvent(requestContext, PASSWORD_VALIDATION_FAILURE_CODE, DEFAULT_MESSAGE, new Object[0]);
            }
            if (this.passwordManagementService.change(bean)) {
                UsernamePasswordCredential credential2 = new UsernamePasswordCredential(bean.getUsername(), bean.toPassword());
                WebUtils.putCredential((RequestContext)requestContext, (Credential)credential2);
                LOGGER.info("Password successfully changed for [{}]", (Object)bean.getUsername());
                return this.getSuccessEvent(requestContext, bean);
            }
        }
        catch (InvalidPasswordException e) {
            return this.getErrorEvent(requestContext, PASSWORD_VALIDATION_FAILURE_CODE + (String)StringUtils.defaultIfBlank((CharSequence)e.getCode(), (CharSequence)""), (String)StringUtils.defaultIfBlank((CharSequence)e.getValidationMessage(), (CharSequence)DEFAULT_MESSAGE), e.getParams());
        }
        catch (Throwable e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        return this.getErrorEvent(requestContext, "pm.updateFailure", DEFAULT_MESSAGE, new Object[0]);
    }

    protected Event getSuccessEvent(RequestContext requestContext, PasswordChangeRequest bean) {
        return new EventFactorySupport().event((Object)this, "passwordUpdateSuccess", (AttributeMap)new LocalAttributeMap("passwordChangeRequest", (Object)bean));
    }

    private Event getErrorEvent(RequestContext ctx, String code, String message, Object ... params) {
        WebUtils.addErrorMessageToContext((RequestContext)ctx, (String)code, (String)message, (Object[])params);
        return this.error();
    }

    @Generated
    public PasswordChangeAction(PasswordManagementService passwordManagementService, PasswordValidationService passwordValidationService) {
        this.passwordManagementService = passwordManagementService;
        this.passwordValidationService = passwordValidationService;
    }

    @Generated
    public PasswordManagementService getPasswordManagementService() {
        return this.passwordManagementService;
    }

    @Generated
    public PasswordValidationService getPasswordValidationService() {
        return this.passwordValidationService;
    }
}

