/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import lombok.Generated;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.pm.PasswordResetUrlBuilder;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class AccountProfilePasswordChangeRequestAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AccountProfilePasswordChangeRequestAction.class);
    private final TicketRegistry ticketRegistry;
    private final PasswordResetUrlBuilder passwordResetUrlBuilder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Event doExecuteInternal(RequestContext requestContext) throws Exception {
        TicketGrantingTicket tgt = WebUtils.getTicketGrantingTicket((RequestContext)requestContext);
        try {
            Event event = (Event)FunctionUtils.doUnchecked(() -> {
                Principal principal = tgt.getAuthentication().getPrincipal();
                String url = this.passwordResetUrlBuilder.build(principal.getId()).toExternalForm();
                LOGGER.debug("Redirecting password reset flow to [{}]", (Object)url);
                WebUtils.putServiceRedirectUrl((RequestContext)requestContext, (String)url);
                return this.success(url);
            });
            return event;
        }
        finally {
            this.ticketRegistry.deleteTicket((Ticket)tgt);
        }
    }

    @Generated
    public AccountProfilePasswordChangeRequestAction(TicketRegistry ticketRegistry, PasswordResetUrlBuilder passwordResetUrlBuilder) {
        this.ticketRegistry = ticketRegistry;
        this.passwordResetUrlBuilder = passwordResetUrlBuilder;
    }

    @Generated
    public TicketRegistry getTicketRegistry() {
        return this.ticketRegistry;
    }

    @Generated
    public PasswordResetUrlBuilder getPasswordResetUrlBuilder() {
        return this.passwordResetUrlBuilder;
    }
}

