/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.pm.PasswordChangeBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.binding.validation.ValidationContext;

public class PasswordValidator {
    @Autowired
    private CasConfigurationProperties casProperties;

    public void validateCasMustChangePassView(PasswordChangeBean bean, ValidationContext context) {
        MessageContext messages = context.getMessageContext();
        if (!bean.getPassword().equals(bean.getConfirmedPassword())) {
            messages.addMessage(new MessageBuilder().error().source((Object)"pm.passwordsMustMatch").defaultText("Provided passwords do not match.").build());
            return;
        }
        if (!bean.getPassword().matches(this.casProperties.getAuthn().getPm().getPolicyPattern())) {
            messages.addMessage(new MessageBuilder().error().source((Object)"pm.passwordFailedCriteria").defaultText("Password policy rejected the provided insecure password.").build());
        }
    }
}

