/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.pm.PasswordManagementProperties;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.util.io.CommunicationsManager;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class SendPasswordResetInstructionsAction
extends AbstractAction {
    public static final String PARAMETER_NAME_TOKEN = "t";
    private static final Logger LOGGER = LoggerFactory.getLogger(SendPasswordResetInstructionsAction.class);
    @Autowired
    private CasConfigurationProperties casProperties;
    private final CommunicationsManager communicationsManager;
    private PasswordManagementService passwordManagementService;

    public SendPasswordResetInstructionsAction(CommunicationsManager communicationsManager, PasswordManagementService passwordManagementService) {
        this.communicationsManager = communicationsManager;
        this.passwordManagementService = passwordManagementService;
    }

    protected Event doExecute(RequestContext requestContext) throws Exception {
        if (!this.communicationsManager.isMailSenderDefined()) {
            LOGGER.warn("CAS is unable to send password-reset emails given no settings are defined to account for email servers");
            return this.error();
        }
        PasswordManagementProperties pm = this.casProperties.getAuthn().getPm();
        HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)requestContext);
        String username = request.getParameter("username");
        if (StringUtils.isBlank((CharSequence)username)) {
            LOGGER.warn("No username is provided");
            return this.error();
        }
        String to = this.passwordManagementService.findEmail(username);
        if (StringUtils.isBlank((CharSequence)to)) {
            LOGGER.warn("No recipient is provided");
            return this.error();
        }
        String token = this.passwordManagementService.createToken(username);
        String url = this.casProperties.getServer().getPrefix().concat("/pswdreset?t=").concat(token);
        LOGGER.debug("Generated password reset URL [{}]; Link is only active for the next [{}] minute(s)", (Object)url, (Object)Float.valueOf(pm.getReset().getExpirationMinutes()));
        if (this.sendPasswordResetEmailToAccount(to, url)) {
            return this.success();
        }
        LOGGER.error("Failed to notify account [{}]", (Object)to);
        return this.error();
    }

    protected boolean sendPasswordResetEmailToAccount(String to, String url) {
        PasswordManagementProperties.Reset reset = this.casProperties.getAuthn().getPm().getReset();
        String text = String.format(reset.getText(), url);
        return this.communicationsManager.email(text, reset.getFrom(), reset.getSubject(), to, null, null);
    }
}

