/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.config;

import java.io.Serializable;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.audit.AuditTrailRecordResolutionPlan;
import org.apereo.cas.audit.AuditTrailRecordResolutionPlanConfigurer;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.util.EncryptionJwtSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.pm.PasswordManagementProperties;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.pm.PasswordResetTokenCipherExecutor;
import org.apereo.cas.pm.PasswordValidationService;
import org.apereo.cas.pm.impl.GroovyResourcePasswordManagementService;
import org.apereo.cas.pm.impl.JsonResourcePasswordManagementService;
import org.apereo.cas.pm.impl.NoOpPasswordManagementService;
import org.apereo.cas.util.io.CommunicationsManager;
import org.apereo.inspektr.audit.spi.AuditActionResolver;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.apereo.inspektr.audit.spi.support.BooleanAuditActionResolver;
import org.apereo.inspektr.audit.spi.support.FirstParameterAuditResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

@Configuration(value="passwordManagementConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class PasswordManagementConfiguration
implements AuditTrailRecordResolutionPlanConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PasswordManagementConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="communicationsManager")
    private CommunicationsManager communicationsManager;

    @ConditionalOnMissingBean(name={"passwordManagementCipherExecutor"})
    @RefreshScope
    @Bean
    public CipherExecutor passwordManagementCipherExecutor() {
        PasswordManagementProperties pm = this.casProperties.getAuthn().getPm();
        EncryptionJwtSigningJwtCryptographyProperties crypto = pm.getReset().getCrypto();
        if (pm.isEnabled() && crypto.isEnabled()) {
            return new PasswordResetTokenCipherExecutor(crypto.getEncryption().getKey(), crypto.getSigning().getKey(), crypto.getAlg());
        }
        return CipherExecutor.noOp();
    }

    @ConditionalOnMissingBean(name={"passwordValidationService"})
    @RefreshScope
    @Bean
    public PasswordValidationService passwordValidationService() {
        String policyPattern = this.casProperties.getAuthn().getPm().getPolicyPattern();
        return (credential, bean) -> {
            if (StringUtils.isEmpty((Object)bean.getPassword())) {
                LOGGER.error("Provided password is blank");
                return false;
            }
            if (!bean.getPassword().equals(bean.getConfirmedPassword())) {
                LOGGER.error("Provided password does not match the confirmed password");
                return false;
            }
            if (!bean.getPassword().matches(policyPattern)) {
                LOGGER.error("Provided password does not match the pattern required for password policy [{}}", (Object)policyPattern);
                return false;
            }
            return true;
        };
    }

    @ConditionalOnMissingBean(name={"passwordChangeService"})
    @RefreshScope
    @Bean
    public PasswordManagementService passwordChangeService() {
        PasswordManagementProperties pm = this.casProperties.getAuthn().getPm();
        if (pm.isEnabled()) {
            Resource location = pm.getJson().getLocation();
            if (location != null) {
                LOGGER.debug("Configuring password management based on JSON resource [{}]", (Object)location);
                return new JsonResourcePasswordManagementService((CipherExecutor<Serializable, String>)this.passwordManagementCipherExecutor(), this.casProperties.getServer().getPrefix(), this.casProperties.getAuthn().getPm(), location);
            }
            Resource groovyScript = pm.getGroovy().getLocation();
            if (groovyScript != null) {
                LOGGER.debug("Configuring password management based on Groovy resource [{}]", (Object)groovyScript);
                return new GroovyResourcePasswordManagementService((CipherExecutor<Serializable, String>)this.passwordManagementCipherExecutor(), this.casProperties.getServer().getPrefix(), this.casProperties.getAuthn().getPm(), groovyScript);
            }
            LOGGER.warn("No storage service (LDAP, Database, etc) is configured to handle the account update and password service operations. Password management functionality will have no effect and will be disabled until a storage service is configured. To explicitly disable the password management functionality, add 'cas.authn.pm.enabled=false' to the CAS configuration");
        } else {
            LOGGER.debug("Password management is disabled. To enable the password management functionality, add 'cas.authn.pm.enabled=true' to the CAS configuration and then configure storage options for account updates");
        }
        return new NoOpPasswordManagementService((CipherExecutor<Serializable, String>)this.passwordManagementCipherExecutor(), this.casProperties.getServer().getPrefix(), this.casProperties.getAuthn().getPm());
    }

    @PostConstruct
    public void initialize() {
        PasswordManagementProperties pm = this.casProperties.getAuthn().getPm();
        if (pm.isEnabled()) {
            this.communicationsManager.validate();
        }
    }

    public void configureAuditTrailRecordResolutionPlan(AuditTrailRecordResolutionPlan plan) {
        plan.registerAuditActionResolver("CHANGE_PASSWORD_ACTION_RESOLVER", (AuditActionResolver)new BooleanAuditActionResolver("_SUCCESS", "_FAILED"));
        plan.registerAuditResourceResolver("CHANGE_PASSWORD_RESOURCE_RESOLVER", (AuditResourceResolver)new FirstParameterAuditResourceResolver());
    }
}

