/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.config;

import lombok.Generated;
import org.apereo.cas.audit.AuditTrailRecordResolutionPlanConfigurer;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.util.EncryptionJwtSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.pm.PasswordHistoryProperties;
import org.apereo.cas.configuration.model.support.pm.PasswordManagementProperties;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.pm.DefaultPasswordValidationService;
import org.apereo.cas.pm.PasswordHistoryService;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.pm.PasswordResetTokenCipherExecutor;
import org.apereo.cas.pm.PasswordValidationService;
import org.apereo.cas.pm.impl.GroovyResourcePasswordManagementService;
import org.apereo.cas.pm.impl.JsonResourcePasswordManagementService;
import org.apereo.cas.pm.impl.NoOpPasswordManagementService;
import org.apereo.cas.pm.impl.history.AmnesiacPasswordHistoryService;
import org.apereo.cas.pm.impl.history.GroovyPasswordHistoryService;
import org.apereo.cas.pm.impl.history.InMemoryPasswordHistoryService;
import org.apereo.cas.util.cipher.CipherExecutorUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.inspektr.audit.spi.AuditActionResolver;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.apereo.inspektr.audit.spi.support.BooleanAuditActionResolver;
import org.apereo.inspektr.audit.spi.support.DefaultAuditActionResolver;
import org.apereo.inspektr.audit.spi.support.FirstParameterAuditResourceResolver;
import org.apereo.inspektr.audit.spi.support.SpringWebflowActionExecutionAuditablePrincipalResolver;
import org.apereo.inspektr.common.spi.PrincipalResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;

@Configuration(value="passwordManagementConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class PasswordManagementConfiguration
implements InitializingBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PasswordManagementConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="returnValueResourceResolver")
    private ObjectProvider<AuditResourceResolver> returnValueResourceResolver;
    @Autowired
    @Qualifier(value="communicationsManager")
    private ObjectProvider<CommunicationsManager> communicationsManager;

    @ConditionalOnMissingBean(name={"passwordManagementCipherExecutor"})
    @RefreshScope
    @Bean
    public CipherExecutor passwordManagementCipherExecutor() {
        PasswordManagementProperties pm = this.casProperties.getAuthn().getPm();
        EncryptionJwtSigningJwtCryptographyProperties crypto = pm.getReset().getCrypto();
        if (pm.getCore().isEnabled() && crypto.isEnabled()) {
            return CipherExecutorUtils.newStringCipherExecutor((EncryptionJwtSigningJwtCryptographyProperties)crypto, PasswordResetTokenCipherExecutor.class);
        }
        return CipherExecutor.noOp();
    }

    @ConditionalOnMissingBean(name={"passwordValidationService"})
    @RefreshScope
    @Bean
    public PasswordValidationService passwordValidationService() {
        String policyPattern = this.casProperties.getAuthn().getPm().getCore().getPolicyPattern();
        return new DefaultPasswordValidationService(policyPattern, this.passwordHistoryService());
    }

    @ConditionalOnMissingBean(name={"passwordHistoryService"})
    @RefreshScope
    @Bean
    public PasswordHistoryService passwordHistoryService() {
        PasswordManagementProperties pm = this.casProperties.getAuthn().getPm();
        PasswordHistoryProperties history = pm.getHistory();
        if (pm.getCore().isEnabled() && history.getCore().isEnabled()) {
            if (history.getGroovy().getLocation() != null) {
                return new GroovyPasswordHistoryService(history.getGroovy().getLocation());
            }
            return new InMemoryPasswordHistoryService();
        }
        return new AmnesiacPasswordHistoryService();
    }

    @ConditionalOnMissingBean(name={"passwordChangeService"})
    @RefreshScope
    @Bean
    public PasswordManagementService passwordChangeService() {
        PasswordManagementProperties pm = this.casProperties.getAuthn().getPm();
        if (pm.getCore().isEnabled()) {
            Resource location = pm.getJson().getLocation();
            if (location != null) {
                LOGGER.debug("Configuring password management based on JSON resource [{}]", (Object)location);
                return new JsonResourcePasswordManagementService(this.passwordManagementCipherExecutor(), this.casProperties.getServer().getPrefix(), this.casProperties.getAuthn().getPm(), location, this.passwordHistoryService());
            }
            Resource groovyScript = pm.getGroovy().getLocation();
            if (groovyScript != null) {
                LOGGER.debug("Configuring password management based on Groovy resource [{}]", (Object)groovyScript);
                return new GroovyResourcePasswordManagementService(this.passwordManagementCipherExecutor(), this.casProperties.getServer().getPrefix(), this.casProperties.getAuthn().getPm(), groovyScript, this.passwordHistoryService());
            }
            LOGGER.warn("No storage service is configured to handle the account update and password service operations. Password management functionality will have no effect and will be disabled until a storage service is configured. To explicitly disable the password management, add 'cas.authn.pm.core.enabled=false' to the CAS configuration");
        } else {
            LOGGER.debug("Password management is disabled. To enable the password management functionality, add 'cas.authn.pm.core.enabled=true' to the CAS configuration and then configure storage options for account updates");
        }
        return new NoOpPasswordManagementService(this.passwordManagementCipherExecutor(), this.casProperties.getServer().getPrefix(), this.casProperties.getAuthn().getPm());
    }

    @Bean
    @ConditionalOnMissingBean(name={"passwordManagementAuditTrailRecordResolutionPlanConfigurer"})
    public AuditTrailRecordResolutionPlanConfigurer passwordManagementAuditTrailRecordResolutionPlanConfigurer() {
        return plan -> {
            plan.registerAuditActionResolver("CHANGE_PASSWORD_ACTION_RESOLVER", (AuditActionResolver)new BooleanAuditActionResolver("_SUCCESS", "_FAILED"));
            plan.registerAuditResourceResolver("CHANGE_PASSWORD_RESOURCE_RESOLVER", (AuditResourceResolver)new FirstParameterAuditResourceResolver());
            plan.registerAuditActionResolver("REQUEST_CHANGE_PASSWORD_ACTION_RESOLVER", (AuditActionResolver)new DefaultAuditActionResolver());
            plan.registerAuditResourceResolver("REQUEST_CHANGE_PASSWORD_RESOURCE_RESOLVER", (AuditResourceResolver)this.returnValueResourceResolver.getObject());
            plan.registerAuditPrincipalResolver("REQUEST_CHANGE_PASSWORD_PRINCIPAL_RESOLVER", (PrincipalResolver)new SpringWebflowActionExecutionAuditablePrincipalResolver("username"));
        };
    }

    public void afterPropertiesSet() {
        PasswordManagementProperties pm = this.casProperties.getAuthn().getPm();
        if (pm.getCore().isEnabled()) {
            ((CommunicationsManager)this.communicationsManager.getObject()).validate();
        }
    }
}

